/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.AWTException;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.Intl;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.tool.IKeyboardDevc;
import thunderheadeng.gui.tool.IMouseDevc;
import thunderheadeng.gui.tool.SwingMouse;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.ISelector;
import thunderheadeng.util.BitOptions;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.RWProp;
import thunderheadeng.util.time.WallClock;

public class RoamFunc<T extends CursorTool>
extends AToolFunction<T> {
    public static final int OPT_KEYBOARD = 1;
    public static final int OPT_MOUSE = 2;
    public static final int OPT_HTD = 4;
    public static final int OPT_ROAM_DEFAULT = 3;
    public static final RWProp<Integer> FORWARD = new RWProp<Integer>((Object)"FORWARD", 87);
    public static final RWProp<Integer> BACKWARD = new RWProp<Integer>((Object)"BACKWARD", 83);
    public static final RWProp<Integer> LEFT = new RWProp<Integer>((Object)"LEFT", 65);
    public static final RWProp<Integer> RIGHT = new RWProp<Integer>((Object)"RIGHT", 68);
    public static final RWProp<Integer> UP = new RWProp<Integer>((Object)"UP", 32);
    public static final RWProp<Integer> DOWN = new RWProp<Integer>((Object)"DOWN", 67);
    public static final RWProp<Integer> FASTER = new RWProp<Integer>((Object)"FASTER", 16);
    public static final List<RWProp<Integer>> MOVE_KEY_PROPS = Arrays.asList(FORWARD, BACKWARD, LEFT, RIGHT, UP, DOWN);
    public static final Cursor BLANK_CURSOR = guiUtil.createTeciCursor("Freelook", "blank16.gif", 15, 16);
    public static final Icon ICON = guiUtil.loadTeciIcon("running_man.gif");
    private final ISelector<T> d_selectionTool;
    private Robot d_robot;
    private Point d_lastMouseLoc = new Point(0, 0);
    private double d_pitch;
    private double d_roll;
    private double d_yaw;
    private Point3d d_loc = new Point3d();
    private double d_lastUpdateTime = -1.0;
    private boolean d_roamMode = false;
    private final PropertySet d_moveKeys = new PropertySet();
    private final Set<Integer> d_isMoveKey = new HashSet<Integer>();
    private final WallClock d_clock = new WallClock();
    private DragModeParams d_dragParams = new DragModeParams();
    private RoamModeParams d_roamParams = new RoamModeParams();
    private KBParams d_kbParams = new KBParams();
    private BitOptions d_options = new BitOptions(3L);
    private RoamPixelOffsets d_roamOffsets = new RoamPixelOffsets();
    private final SwingMouse d_mouse = new SwingMouse();
    private static final double PIXEL_TOL = 15.0;

    public RoamFunc(ISelector<T> iSelector) {
        this.d_selectionTool = iSelector;
        try {
            this.d_robot = new Robot();
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
        }
        this.d_clock.pause();
        this.updateMoveKeyMappings();
    }

    public void setKeyMapping(RWProp<Integer> rWProp, int n) {
        this.d_moveKeys.setIfNotDefault(rWProp, n);
    }

    public int getKeyMapping(RWProp<Integer> rWProp) {
        return this.d_moveKeys.get(rWProp);
    }

    private void updateMoveKeyMappings() {
        this.d_isMoveKey.clear();
        for (RWProp<Integer> rWProp : MOVE_KEY_PROPS) {
            this.d_isMoveKey.add(this.d_moveKeys.get(rWProp));
        }
    }

    private static int getMouseAnimateZBtn(boolean bl) {
        return 1;
    }

    private static int getMouseAnimateXBtn(boolean bl) {
        return 2;
    }

    private static int getMouseAnimateYBtn(boolean bl) {
        return 3;
    }

    public void setModelBounds(AABox aABox) {
        double d = aABox.getMin().distance(aABox.getMax());
        DragModeParams dragModeParams = this.getDragParams();
        RoamModeParams roamModeParams = this.getRoamParams();
        this.setRoamParams(roamModeParams);
        this.setDragParams(new DragModeParams(dragModeParams.orientSpeed, 0.001 * d, 1.0));
    }

    public void setOptions(CursorTool cursorTool, int n) {
        this.d_options = new BitOptions(n);
        if (this.d_options.getAny(4L)) {
            this.beginAnimation(cursorTool);
        }
    }

    public int getOptions() {
        return (int)this.d_options.getRaw();
    }

    public KBParams getKeyboardParams() {
        return this.d_kbParams;
    }

    public void setKeyboardParams(KBParams kBParams) {
        this.d_kbParams = kBParams;
    }

    public DragModeParams getDragParams() {
        return this.d_dragParams;
    }

    public void setDragParams(DragModeParams dragModeParams) {
        this.d_dragParams = dragModeParams;
    }

    public RoamModeParams getRoamParams() {
        return this.d_roamParams;
    }

    public void setRoamParams(RoamModeParams roamModeParams) {
        this.d_roamParams = roamModeParams;
    }

    private void recordCameraState(T t) {
        Camera camera = ((CursorTool)t).getView().getCamera();
        if (camera == null) {
            return;
        }
        Camera.Position position = camera.getPositionInfo();
        Vector3d vector3d = Util3D.vector(position.pos, position.ref);
        Vector3d vector3d2 = position.up;
        Vector3d vector3d3 = new Vector3d(0.0, 1.0, 0.0);
        Vector3d vector3d4 = new Vector3d(vector3d.x, vector3d.y, 0.0);
        double d = vector3d3.angle(vector3d4);
        Vector3d vector3d5 = Util3D.cross(vector3d3, vector3d4);
        if (vector3d5.z < 0.0) {
            d = -d;
        }
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        Matrix4d matrix4d = Util.rotMat(0.0, 0.0, 1.0, -d);
        matrix4d.transform(vector3d);
        Vector3d vector3d6 = new Vector3d(0.0, vector3d.y, vector3d.z);
        double d2 = vector3d3.angle(vector3d6);
        Vector3d vector3d7 = Util3D.cross(vector3d3, vector3d6);
        if (vector3d7.x < 0.0) {
            d2 = -d2;
        }
        if (Double.isNaN(d2)) {
            d2 = 0.0;
        }
        matrix4d = Util.rotMat(1.0, 0.0, 0.0, -d2);
        matrix4d.mul(Util.rotMat(0.0, 0.0, 1.0, -d));
        matrix4d.transform(vector3d2);
        Vector3d vector3d8 = new Vector3d(vector3d2.x, 0.0, vector3d2.z);
        double d3 = GeomConstants.VEC3D_ZPOS.angle(vector3d8);
        Vector3d vector3d9 = Util3D.cross(GeomConstants.VEC3D_ZPOS, vector3d8);
        if (vector3d9.y < 0.0) {
            d3 = -d3;
        }
        if (Double.isNaN(d3)) {
            d3 = 0.0;
        }
        this.d_yaw = d;
        this.d_pitch = d2;
        this.d_roll = d3;
        this.d_loc = new Point3d(position.pos);
    }

    private Quat4d calcOrient() {
        Quat4d quat4d = RoamFunc.newQuat(this.d_yaw, 0.0, 0.0, 1.0);
        quat4d.mul(RoamFunc.newQuat(this.d_pitch, 1.0, 0.0, 0.0));
        quat4d.mul(RoamFunc.newQuat(this.d_roll, 0.0, 1.0, 0.0));
        return quat4d;
    }

    private static void calcOrientVecs(Quat4d quat4d, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.set(quat4d);
        Matrix4d matrix4d2 = matrix4d;
        if (vector3d != null) {
            vector3d.set(1.0, 0.0, 0.0);
            matrix4d2.transform(vector3d);
        }
        if (vector3d2 != null) {
            vector3d2.set(0.0, 1.0, 0.0);
            matrix4d2.transform(vector3d2);
        }
        if (vector3d3 != null) {
            vector3d3.set(0.0, 0.0, 1.0);
            matrix4d2.transform(vector3d3);
        }
    }

    private static Quat4d newQuat(double d, double d2, double d3, double d4) {
        Quat4d quat4d = new Quat4d();
        quat4d.set(new AxisAngle4d(d2, d3, d4, d));
        return quat4d;
    }

    private void updateCameraState(T t) {
        Point3d point3d = this.d_loc;
        Quat4d quat4d = this.calcOrient();
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        RoamFunc.calcOrientVecs(quat4d, null, vector3d, vector3d2);
        Camera camera = ((CursorTool)t).getView().getCamera();
        camera.setPositionInfo(new Camera.Position(point3d, Util3D.add(point3d, (Tuple3d)vector3d), vector3d2));
        this.modified((CursorTool)t);
    }

    @Override
    public void activate(T t) {
        this.recordCameraState(t);
    }

    private void modified(CursorTool cursorTool) {
        if (cursorTool != null) {
            cursorTool.repaintSurface();
        }
    }

    private void beginAnimation(CursorTool cursorTool) {
        if (!this.d_clock.isPaused()) {
            return;
        }
        cursorTool.beginAnimation();
        this.d_lastUpdateTime = this.d_clock.resume();
        this.modified(cursorTool);
    }

    private void endAnimation(CursorTool cursorTool) {
        this.d_clock.pause();
        cursorTool.endAnimation();
    }

    private boolean isKeyDown(CursorTool cursorTool, int n) {
        return cursorTool.getDevices().getKeyboard().isPressed(n);
    }

    private boolean isMouseButtonDown(CursorTool cursorTool, IMouseDevc.Button button) {
        return cursorTool.getDevices().getMouse().isPressed(button);
    }

    private boolean isLButtonDown(CursorTool cursorTool) {
        return this.isMouseButtonDown(cursorTool, IMouseDevc.Button.LEFT);
    }

    private boolean isMButtonDown(CursorTool cursorTool) {
        return this.isMouseButtonDown(cursorTool, IMouseDevc.Button.MIDDLE);
    }

    private boolean isRButtonDown(CursorTool cursorTool) {
        return this.isMouseButtonDown(cursorTool, IMouseDevc.Button.RIGHT);
    }

    private boolean getMouseAnimateMode(T t) {
        return this.d_roamMode && (this.isLButtonDown((CursorTool)t) || this.isRButtonDown((CursorTool)t) || this.isMButtonDown((CursorTool)t));
    }

    private boolean getMouseStaticMode(T t) {
        return this.d_roamMode || this.isLButtonDown((CursorTool)t) || this.isRButtonDown((CursorTool)t) || this.isMButtonDown((CursorTool)t);
    }

    private boolean getKeyboardAnimateMode(T t) {
        for (RWProp<Integer> rWProp : MOVE_KEY_PROPS) {
            if (!this.isKeyDown((CursorTool)t, this.d_moveKeys.get(rWProp))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mousePressed(T t, MouseEvent mouseEvent) {
        this.d_lastMouseLoc = mouseEvent.getPoint();
        if (this.getMouseAnimateMode(t)) {
            this.beginAnimation((CursorTool)t);
        }
    }

    private Camera getCamera(T t) {
        return ((CursorTool)t).getView().getCamera();
    }

    @Override
    public void mouseReleased(T t, MouseEvent mouseEvent) {
        if (!((CursorTool)t).dragAboveTolerance(0)) {
            if (SwingMouse.getPredef(mouseEvent) == IMouseDevc.Button.MIDDLE) {
                this.d_roamMode = !this.d_roamMode;
            } else if (!this.d_roamMode && this.d_selectionTool != null) {
                this.d_selectionTool.select(t, mouseEvent);
            }
        }
        this.setCursorVisible(t, !this.getHideCursor());
        if (this.getMouseAnimateMode(t)) {
            IMouseDevc.Button button = SwingMouse.getPredef(mouseEvent);
            if (button != null) {
                switch (button) {
                    case LEFT: {
                        this.d_roamOffsets.localX = 0;
                        break;
                    }
                    case RIGHT: {
                        this.d_roamOffsets.localY = 0;
                    }
                }
            }
            if (!this.isLButtonDown((CursorTool)t) && !this.isMButtonDown((CursorTool)t)) {
                this.d_roamOffsets.localZ = 0;
            }
            if (!this.isMButtonDown((CursorTool)t) && !this.isRButtonDown((CursorTool)t)) {
                this.d_roamOffsets.zturn = 0;
            }
        } else {
            this.d_roamOffsets = new RoamPixelOffsets();
        }
    }

    private void setCursorVisible(T t, boolean bl) {
        if (bl) {
            ((CursorTool)t).restoreSystemCursor();
        } else {
            ((CursorTool)t).getAttachedComponent().setCursor(BLANK_CURSOR);
        }
    }

    private boolean getHideCursor() {
        return this.d_roamMode;
    }

    @Override
    public void keyPressed(T t, KeyEvent keyEvent) {
        if (this.d_isMoveKey.contains(keyEvent.getKeyCode())) {
            this.beginAnimation((CursorTool)t);
        } else {
            switch (keyEvent.getKeyCode()) {
                case 27: {
                    this.d_roamMode = false;
                    this.setCursorVisible(t, !this.getHideCursor());
                    this.modified((CursorTool)t);
                }
            }
        }
    }

    @Override
    public void keyReleased(T t, KeyEvent keyEvent) {
    }

    private static double adjustForTol(double d, double d2) {
        double d3 = Math.abs(d);
        if (d3 > d2) {
            double d4 = d < 0.0 ? -1.0 : 1.0;
            return d4 * (d3 - d2);
        }
        return 0.0;
    }

    private Object getInUseHTD(T t) {
        return null;
    }

    @Override
    public boolean animate(T t, IAnimSession iAnimSession) {
        if (this.getCamera(t) == null) {
            return false;
        }
        double d = this.d_clock.getTime();
        double d2 = d - this.d_lastUpdateTime;
        Quat4d quat4d = this.calcOrient();
        if (this.getKeyboardAnimateMode(t)) {
            Vector3d vector3d;
            Vector3d vector3d2;
            IKeyboardDevc iKeyboardDevc = ((CursorTool)t).getDevices().getKeyboard();
            boolean bl = iKeyboardDevc.isPressed(this.d_moveKeys.get(FORWARD));
            boolean bl2 = iKeyboardDevc.isPressed(this.d_moveKeys.get(BACKWARD));
            boolean bl3 = iKeyboardDevc.isPressed(this.d_moveKeys.get(LEFT));
            boolean bl4 = iKeyboardDevc.isPressed(this.d_moveKeys.get(RIGHT));
            boolean bl5 = iKeyboardDevc.isPressed(this.d_moveKeys.get(UP));
            boolean bl6 = iKeyboardDevc.isPressed(this.d_moveKeys.get(DOWN));
            boolean bl7 = iKeyboardDevc.isPressed(this.d_moveKeys.get(FASTER));
            double d3 = !bl7 ? this.d_kbParams.getSpeed() : this.d_kbParams.getSpeed() * 2.0;
            double d4 = d3 * d2;
            Vector3d vector3d3 = new Vector3d();
            if (bl5) {
                vector3d3.z += d4;
            }
            if (bl6) {
                vector3d3.z -= d4;
            }
            if (bl3 || bl4) {
                vector3d2 = new Vector3d();
                RoamFunc.calcOrientVecs(quat4d, vector3d2, null, null);
                vector3d2.normalize();
                vector3d2.scale(d4);
                vector3d = new Vector3d();
                if (bl4) {
                    vector3d.add(vector3d2);
                }
                if (bl3) {
                    vector3d.sub(vector3d2);
                }
                vector3d3.add(vector3d);
            }
            if (bl || bl2) {
                vector3d2 = new Vector3d();
                RoamFunc.calcOrientVecs(quat4d, null, vector3d2, null);
                vector3d2.normalize();
                vector3d2.scale(d4);
                vector3d = new Vector3d();
                if (bl) {
                    vector3d.add(vector3d2);
                }
                if (bl2) {
                    vector3d.sub(vector3d2);
                }
                vector3d3.add(vector3d);
            }
            this.d_loc.add(vector3d3);
        } else if (this.getMouseAnimateMode(t)) {
            Vector3d vector3d;
            double d5;
            double d6;
            double d7 = RoamFunc.adjustForTol(this.d_roamOffsets.zturn, 15.0);
            double d8 = RoamFunc.adjustForTol(this.d_roamOffsets.localX, 15.0);
            double d9 = RoamFunc.adjustForTol(this.d_roamOffsets.localY, 15.0);
            double d10 = RoamFunc.adjustForTol(this.d_roamOffsets.localZ, 15.0);
            if (d7 != 0.0) {
                d6 = d2 * this.d_roamParams.turnAccel;
                double d11 = -d7 * d6;
                this.d_yaw += d11;
            }
            d6 = d2 * this.d_roamParams.moveAccel;
            Vector3d vector3d4 = new Vector3d();
            if (d8 != 0.0) {
                d5 = d8 * d6;
                vector3d = new Vector3d();
                RoamFunc.calcOrientVecs(quat4d, vector3d, null, null);
                vector3d.normalize();
                vector3d.scale(d5);
                vector3d4.add(vector3d);
            }
            if (d10 != 0.0) {
                d5 = -d10 * d6;
                vector3d = new Vector3d();
                RoamFunc.calcOrientVecs(quat4d, vector3d, null, null);
                Vector3d vector3d5 = Util3D.cross(GeomConstants.VEC3D_ZPOS, vector3d);
                vector3d5.normalize();
                vector3d5.scale(d5);
                vector3d4.add(vector3d5);
            }
            if (d9 != 0.0) {
                d5 = -d9 * d6;
                vector3d4.z += d5;
            }
            this.d_loc.add(vector3d4);
        } else if (this.getInUseHTD(t) == null) {
            this.endAnimation((CursorTool)t);
        }
        this.updateCameraState(t);
        this.d_lastUpdateTime = d;
        return this.d_clock.isPaused() && this.getInUseHTD(t) == null;
    }

    @Override
    public boolean isAltMenuAccessEnabled() {
        return false;
    }

    @Override
    public boolean isDrawable(T t) {
        return false;
    }

    @Override
    public boolean enableZoomAboutPoint(T t) {
        return false;
    }

    @Override
    public Cursor getCursor(T t) {
        return Cursor.getPredefinedCursor(0);
    }

    @Override
    public void mouseWheelMoved(T t, MouseWheelEvent mouseWheelEvent) {
        if (((CursorTool)t).getPressedKeys().contains(17)) {
            double d = -mouseWheelEvent.getPreciseWheelRotation() * 0.2;
            double d2 = Math.pow(2.0, d);
            this.d_dragParams = new DragModeParams(this.d_dragParams.orientSpeed, this.d_dragParams.moveSpeed, this.d_dragParams.moveFactor * d2);
            this.d_kbParams = new KBParams(this.d_kbParams.speed, this.d_kbParams.factor * d2);
            ((CursorTool)t).updateStatusMessage();
        } else {
            super.mouseWheelMoved(t, mouseWheelEvent);
        }
    }

    @Override
    public void mouseMoved(T t, MouseEvent mouseEvent) {
        this.respondToMouse(t, mouseEvent);
    }

    @Override
    public void mouseDragged(T t, MouseEvent mouseEvent) {
        this.respondToMouse(t, mouseEvent);
    }

    public void respondToMouse(T t, MouseEvent mouseEvent) {
        Object object;
        this.recordCameraState(t);
        Point point = mouseEvent.getPoint();
        int n = point.x - this.d_lastMouseLoc.x;
        int n2 = point.y - this.d_lastMouseLoc.y;
        if (this.d_roamMode) {
            if (this.d_robot != null) {
                object = ((CursorTool)t).getAttachedComponent().getLocationOnScreen();
                this.d_robot.mouseMove(((Point)object).x + this.d_lastMouseLoc.x, ((Point)object).y + this.d_lastMouseLoc.y);
            }
        } else {
            this.d_lastMouseLoc = mouseEvent.getPoint();
        }
        if (this.getMouseAnimateMode(t)) {
            object = ((CursorTool)t).getDevices().getMouse();
            IMouseDevc.Button button = object.getMostRecentlyPressedPredef(Stream.of(IMouseDevc.Button.LEFT, IMouseDevc.Button.MIDDLE, IMouseDevc.Button.RIGHT));
            if (button != null) {
                switch (button) {
                    case LEFT: {
                        this.d_roamOffsets.localX += n;
                        this.d_roamOffsets.localZ += n2;
                        break;
                    }
                    case MIDDLE: {
                        this.d_roamOffsets.zturn += n;
                        this.d_roamOffsets.localZ += n2;
                        break;
                    }
                    default: {
                        this.d_roamOffsets.zturn += n;
                        this.d_roamOffsets.localY += n2;
                    }
                }
            }
        } else if (this.getCamera(t) != null && this.getMouseStaticMode(t)) {
            boolean bl;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (!this.d_roamMode) {
                bl4 = bl3 = this.isKeyDown((CursorTool)t, 17) && this.isLButtonDown((CursorTool)t) || this.isMButtonDown((CursorTool)t);
                bl2 = this.isKeyDown((CursorTool)t, 18) && this.isLButtonDown((CursorTool)t) || this.isRButtonDown((CursorTool)t);
            }
            boolean bl5 = bl3 || bl4 || bl2;
            boolean bl6 = bl = !bl5;
            if (bl5) {
                Vector3d vector3d;
                Vector3d vector3d2;
                Quat4d quat4d = this.calcOrient();
                double d = this.d_dragParams.getMovementSpeed();
                double d2 = (double)n * d;
                double d3 = (double)n2 * -d;
                Vector3d vector3d3 = new Vector3d();
                if (bl2) {
                    vector3d3.add(new Vector3d(0.0, 0.0, d3));
                }
                if (bl3) {
                    vector3d2 = new Vector3d();
                    RoamFunc.calcOrientVecs(quat4d, vector3d2, null, null);
                    vector3d = Util3D.cross(GeomConstants.VEC3D_ZPOS, vector3d2);
                    if (Util3D.safeNormalize(vector3d, 1.0E-9) == 0.0) {
                        RoamFunc.calcOrientVecs(quat4d, null, vector3d, null);
                    }
                    vector3d.scale(d3);
                    vector3d3.add(vector3d);
                }
                if (bl4) {
                    vector3d2 = new Vector3d();
                    RoamFunc.calcOrientVecs(quat4d, null, vector3d2, null);
                    vector3d = Util3D.cross(vector3d2, GeomConstants.VEC3D_ZPOS);
                    if (Util3D.safeNormalize(vector3d, 1.0E-9) == 0.0) {
                        RoamFunc.calcOrientVecs(quat4d, vector3d, null, null);
                    }
                    vector3d.scale(d2);
                    vector3d3.add(vector3d);
                }
                this.d_loc.add(vector3d3);
            }
            if (bl) {
                double d = this.d_dragParams.orientSpeed;
                this.d_pitch -= (double)n2 * d;
                this.d_yaw -= (double)n * d;
                this.d_roll = 0.0;
                double d4 = this.d_pitch / (Math.PI * 2);
                if (d4 > 1.0) {
                    this.d_pitch = (d4 - Math.floor(d4)) * (Math.PI * 2);
                } else if (d4 < -1.0) {
                    this.d_pitch = (d4 - Math.ceil(d4)) * (Math.PI * 2);
                }
                double d5 = this.d_yaw / (Math.PI * 2);
                if (d5 > 1.0) {
                    this.d_yaw = (d5 - Math.floor(d5)) * (Math.PI * 2);
                } else if (d5 < -1.0) {
                    this.d_yaw = (d5 - Math.ceil(d5)) * (Math.PI * 2);
                }
                double d6 = 1.5707963267948966 - Math.toRadians(1.0);
                if (this.d_pitch > d6) {
                    this.d_pitch = d6;
                } else if (this.d_pitch < -d6) {
                    this.d_pitch = -d6;
                }
            }
            this.updateCameraState(t);
        }
    }

    @Override
    public String getStatusMessage(T t) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(String.format(Intl.intl("Movement Speed Factor: %s (Ctrl+scroll wheel to change)"), ((CursorTool)t).format(this.d_dragParams.moveFactor)));
        arrayList.add(Intl.intl("Click-drag to look"));
        arrayList.add(String.format(Intl.intl("[%1$s][%2$s][%3$s][%4$s] to move"), KeyEvent.getKeyText(this.d_moveKeys.get(FORWARD)), KeyEvent.getKeyText(this.d_moveKeys.get(BACKWARD)), KeyEvent.getKeyText(this.d_moveKeys.get(LEFT)), KeyEvent.getKeyText(this.d_moveKeys.get(RIGHT))));
        arrayList.add(String.format(Intl.intl("[%s] to move down"), KeyEvent.getKeyText(this.d_moveKeys.get(DOWN))));
        arrayList.add(String.format(Intl.intl("[%s] to move up"), KeyEvent.getKeyText(this.d_moveKeys.get(UP))));
        return String.join((CharSequence)"; ", arrayList);
    }

    private static class RoamPixelOffsets {
        public int zturn = 0;
        public int localX = 0;
        public int localY = 0;
        public int localZ = 0;

        private RoamPixelOffsets() {
        }
    }

    public static class KBParams {
        public final double speed;
        public final double factor;

        public KBParams() {
            this(4.0, 1.0);
        }

        public KBParams(double d, double d2) {
            this.speed = d;
            this.factor = d2;
        }

        public double getSpeed() {
            return this.speed * this.factor;
        }
    }

    public static class RoamModeParams {
        public final double turnAccel;
        public final double moveAccel;

        public RoamModeParams() {
            this(0.001, 0.05);
        }

        public RoamModeParams(double d, double d2) {
            this.turnAccel = d;
            this.moveAccel = d2;
        }
    }

    public static class DragModeParams {
        public final double orientSpeed;
        public final double moveSpeed;
        public final double moveFactor;

        public DragModeParams() {
            this(0.003, 0.001, 1.0);
        }

        public DragModeParams(double d, double d2, double d3) {
            this.orientSpeed = d;
            this.moveSpeed = d2;
            this.moveFactor = d3;
        }

        public double getMovementSpeed() {
            return this.moveSpeed * this.moveFactor;
        }
    }
}

