/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.vecmath.Vector3d;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;

public class OrbitFunc
extends AToolFunction<CursorTool> {
    public static final Cursor CURSOR = guiUtil.createTeciCursor("Orbit", "orbit32.png", 15, 15);
    public static final Icon ICON = guiUtil.loadTeciIcon("orbit16.png");
    private Vector3d d_vLast;

    @Override
    public Cursor getCursor(CursorTool cursorTool) {
        return cursorTool.isDragging() ? CURSOR : null;
    }

    @Override
    public boolean isDrawable(CursorTool cursorTool) {
        return false;
    }

    private void turnMEIntoVec(CursorTool cursorTool, MouseEvent mouseEvent, Vector3d vector3d) {
        double d = (double)mouseEvent.getX() - (double)cursorTool.getView().getSurface().getWidth() / 2.0;
        double d2 = -((double)mouseEvent.getY() - (double)cursorTool.getView().getSurface().getHeight() / 2.0);
        double d3 = (double)cursorTool.getView().getSurface().getWidth() / 2.5;
        vector3d.x = d;
        vector3d.y = d2;
        vector3d.z = d3 * d3 <= d * d + d2 * d2 ? 0.0 : Math.sqrt(d3 * d3 - d * d - d2 * d2);
    }

    @Override
    public void mousePressed(CursorTool cursorTool, MouseEvent mouseEvent) {
        if (this.d_vLast == null) {
            this.d_vLast = new Vector3d();
            this.turnMEIntoVec(cursorTool, mouseEvent, this.d_vLast);
        }
        this.turnMEIntoVec(cursorTool, mouseEvent, this.d_vLast);
    }

    @Override
    public void mouseReleased(CursorTool cursorTool, MouseEvent mouseEvent) {
        this.d_vLast = null;
    }

    @Override
    public void mouseMoved(CursorTool cursorTool, MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(CursorTool cursorTool, MouseEvent mouseEvent) {
        if (this.d_vLast == null) {
            this.d_vLast = new Vector3d();
            this.turnMEIntoVec(cursorTool, mouseEvent, this.d_vLast);
        }
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        this.turnMEIntoVec(cursorTool, mouseEvent, vector3d);
        Vector3d vector3d3 = new Vector3d();
        vector3d3.sub(vector3d, this.d_vLast);
        vector3d2.cross(this.d_vLast, vector3d);
        if (vector3d2.length() < 0.1) {
            return;
        }
        double d = vector3d2.length() / (this.d_vLast.length() * vector3d.length());
        if (d > 1.0) {
            d = 1.0;
        } else if (d < -1.0) {
            d = -1.0;
        }
        double d2 = Math.asin(d) * 180.0 / 3.1415926;
        vector3d2.normalize();
        cursorTool.getView().getCamera().orbit(-1.5 * d2, vector3d2.x, vector3d2.y, vector3d2.z);
        this.d_vLast.set(vector3d);
        cursorTool.repaintSurface();
    }
}

