/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.ISelector;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.ManipFunc;
import thunderheadeng.scene3d.navtools.SelectionFunc;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.Pair;

public class MultiFunc
extends AToolFunction<CursorTool> {
    private static final int PAN_BTN = 2;
    private static final int ORBIT_BTN = 3;
    private final IToolFunction<CursorTool> d_orbit;
    private final IToolFunction<CursorTool> d_pan;
    private final ManipFunc d_manip;
    private final SelectionFunc d_select;
    private final List<IToolFunction<CursorTool>> d_allFuncs;
    private Mode d_mode;
    private boolean t_panned = false;
    private boolean t_orbited = false;

    public MultiFunc(SelectionFunc selectionFunc, IToolFunction<CursorTool> iToolFunction, IToolFunction<CursorTool> iToolFunction2) {
        this(null, selectionFunc, iToolFunction, iToolFunction2);
    }

    public MultiFunc(ManipFunc manipFunc, SelectionFunc selectionFunc, IToolFunction<CursorTool> iToolFunction, IToolFunction<CursorTool> iToolFunction2) {
        this.d_manip = manipFunc;
        this.d_select = selectionFunc;
        this.d_orbit = iToolFunction;
        this.d_pan = iToolFunction2;
        this.d_mode = Mode.SELECT;
        this.d_allFuncs = new ArrayList<IToolFunction<CursorTool>>();
        if (this.d_manip != null) {
            this.d_allFuncs.add(this.d_manip);
        }
        this.d_allFuncs.add(this.d_select);
        if (this.d_pan != null) {
            this.d_allFuncs.add(this.d_pan);
        }
        if (this.d_orbit != null) {
            this.d_allFuncs.add(this.d_orbit);
        }
    }

    public IToolFunction<CursorTool> getActiveFunc(CursorTool cursorTool) {
        if (cursorTool.isDragging(2) && this.d_pan != null) {
            return this.d_pan;
        }
        if (cursorTool.isDragging(3) && this.d_orbit != null) {
            return this.d_orbit;
        }
        switch (this.d_mode) {
            case MANIP: {
                return this.d_manip;
            }
        }
        return this.d_select;
    }

    public void select(CursorTool cursorTool, MouseEvent mouseEvent) {
        if (this.getActiveFunc(cursorTool) instanceof ISelector) {
            ((ISelector)((Object)this.getActiveFunc(cursorTool))).select(cursorTool, mouseEvent);
        }
    }

    @Override
    public Cursor getCursor(CursorTool cursorTool) {
        return this.getActiveFunc(cursorTool).getCursor(cursorTool);
    }

    @Override
    public void activate(CursorTool cursorTool) {
        cursorTool.setCancelOnRightClick(false);
        for (IToolFunction<CursorTool> iToolFunction : this.d_allFuncs) {
            iToolFunction.activate(cursorTool);
        }
    }

    @Override
    public void deactivate(CursorTool cursorTool) {
        for (IToolFunction<CursorTool> iToolFunction : this.d_allFuncs) {
            iToolFunction.deactivate(cursorTool);
        }
    }

    @Override
    public void cancel(CursorTool cursorTool) {
        this.t_panned = false;
        this.t_orbited = false;
        for (IToolFunction<CursorTool> iToolFunction : this.d_allFuncs) {
            iToolFunction.cancel(cursorTool);
        }
        this.d_mode = Mode.SELECT;
    }

    @Override
    public boolean isDrawable(CursorTool cursorTool) {
        return this.getActiveFunc(cursorTool).isDrawable(cursorTool);
    }

    @Override
    public boolean showDragGuides(CursorTool cursorTool) {
        return this.getActiveFunc(cursorTool).showDragGuides(cursorTool);
    }

    @Override
    public boolean enableZoomAboutPoint(CursorTool cursorTool) {
        return true;
    }

    @Override
    public boolean isAltMenuAccessEnabled() {
        return false;
    }

    @Override
    public Pair<SnapMode, IIsectFilter> getSnapInfo(CursorTool cursorTool) {
        return this.getActiveFunc(cursorTool).getSnapInfo(cursorTool);
    }

    @Override
    public ISnapConstraint getDefaultConstraint(CursorTool cursorTool) {
        return this.getActiveFunc(cursorTool).getDefaultConstraint(cursorTool);
    }

    @Override
    public ISnapConstraint getSnapConstraint(CursorTool cursorTool) {
        return this.getActiveFunc(cursorTool).getSnapConstraint(cursorTool);
    }

    @Override
    public void keyPressed(CursorTool cursorTool, KeyEvent keyEvent) {
        for (IToolFunction<CursorTool> iToolFunction : this.d_allFuncs) {
            iToolFunction.keyPressed(cursorTool, keyEvent);
        }
    }

    @Override
    public void keyReleased(CursorTool cursorTool, KeyEvent keyEvent) {
        for (IToolFunction<CursorTool> iToolFunction : this.d_allFuncs) {
            iToolFunction.keyReleased(cursorTool, keyEvent);
        }
    }

    @Override
    public void mouseEntered(CursorTool cursorTool, MouseEvent mouseEvent) {
        for (IToolFunction<CursorTool> iToolFunction : this.d_allFuncs) {
            iToolFunction.mouseEntered(cursorTool, mouseEvent);
        }
    }

    @Override
    public void mouseExited(CursorTool cursorTool, MouseEvent mouseEvent) {
        for (IToolFunction<CursorTool> iToolFunction : this.d_allFuncs) {
            iToolFunction.mouseExited(cursorTool, mouseEvent);
        }
    }

    @Override
    public void mouseMoved(CursorTool cursorTool, MouseEvent mouseEvent) {
        for (IToolFunction<CursorTool> iToolFunction : this.d_allFuncs) {
            iToolFunction.mouseMoved(cursorTool, mouseEvent);
        }
    }

    @Override
    public void mousePressed(CursorTool cursorTool, MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            if (this.d_manip != null && !cursorTool.isKeyPressed(18)) {
                this.d_manip.mousePressed(cursorTool, mouseEvent);
            }
            if (this.d_manip != null && this.d_manip.isManipulating()) {
                this.d_mode = Mode.MANIP;
            } else {
                this.d_mode = Mode.SELECT;
                this.d_select.mousePressed(cursorTool, mouseEvent);
            }
        } else if (mouseEvent.getButton() == 2 && this.d_pan != null) {
            this.d_pan.mousePressed(cursorTool, mouseEvent);
        } else if (mouseEvent.getButton() == 3 && this.d_orbit != null) {
            this.d_orbit.mousePressed(cursorTool, mouseEvent);
        }
        if (mouseEvent.getButton() == 3 && this.d_mode == Mode.SELECT) {
            this.d_select.mousePressed(cursorTool, mouseEvent);
        }
        this.updateToolDisplay(cursorTool);
    }

    @Override
    public void mouseDragged(CursorTool cursorTool, MouseEvent mouseEvent) {
        IToolFunction<CursorTool> iToolFunction = this.getActiveFunc(cursorTool);
        iToolFunction.mouseDragged(cursorTool, mouseEvent);
        this.t_panned |= iToolFunction == this.d_pan && cursorTool.isDragging(2);
        this.t_orbited |= iToolFunction == this.d_orbit && cursorTool.isDragging(3);
        this.updateToolDisplay(cursorTool);
    }

    protected void updateToolDisplay(CursorTool cursorTool) {
        cursorTool.updateMouseProps();
        cursorTool.showToolCursor();
        cursorTool.markNativeDirty();
        cursorTool.repaintSurface();
    }

    @Override
    public void mouseReleased(CursorTool cursorTool, MouseEvent mouseEvent) {
        boolean bl = this.t_panned;
        boolean bl2 = this.t_orbited;
        if (mouseEvent.getButton() == 2 && this.d_pan != null) {
            this.d_pan.mouseReleased(cursorTool, mouseEvent);
            this.t_panned = false;
        } else if (mouseEvent.getButton() == 3 && this.d_orbit != null) {
            this.d_orbit.mouseReleased(cursorTool, mouseEvent);
            this.t_orbited = false;
        }
        if (this.d_mode == Mode.SELECT) {
            if (mouseEvent.getButton() == 1 || mouseEvent.getButton() == 3 && !bl2 && !bl) {
                this.d_select.mouseReleased(cursorTool, mouseEvent);
            }
        } else if (this.d_mode == Mode.MANIP) {
            assert (this.d_manip != null);
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() > 1) {
                this.d_manip.cancel(cursorTool);
                this.d_mode = Mode.SELECT;
                this.d_select.mouseReleased(cursorTool, mouseEvent);
            } else if (mouseEvent.getButton() == 3 && !bl2 && !bl) {
                this.d_manip.cancel(cursorTool);
                this.d_mode = Mode.SELECT;
            } else if (mouseEvent.getButton() == 1) {
                this.d_manip.mouseReleased(cursorTool, mouseEvent);
                if (!this.d_manip.isManipulating()) {
                    this.d_mode = Mode.SELECT;
                }
            }
        }
        this.updateToolDisplay(cursorTool);
    }

    @Override
    public String getStatusMessage(CursorTool cursorTool) {
        return this.getActiveFunc(cursorTool).getStatusMessage(cursorTool);
    }

    private static enum Mode {
        MANIP,
        SELECT;

    }
}

