/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.scene3d.gui.IOffset;
import thunderheadeng.scene3d.gui.ValueEditorUtil;
import thunderheadeng.scene3d.manip.ManipMgr;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CompositeFunc;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.ConstraintUtil;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomPicker;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.LineConstraint;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.theUtil;

public class ManipFunc
extends AToolFunction<CursorTool>
implements ValueEditor.IListener {
    private final IToolController d_controller;
    private final ManipMgr d_manipMgr;
    private final GeomPicker d_picker;
    private final double d_pickTol;
    private final IUnitSrc d_lenUnit;
    private ValueEditor d_valueEditor;
    private CursorTool t_tool;

    public ManipFunc(IToolController iToolController, ManipMgr manipMgr, GeomPicker geomPicker, double d, IUnitSrc iUnitSrc) {
        this.d_controller = iToolController;
        this.d_manipMgr = manipMgr;
        this.d_picker = geomPicker;
        this.d_pickTol = d;
        this.d_lenUnit = iUnitSrc;
    }

    @Override
    public boolean isAltMenuAccessEnabled() {
        return false;
    }

    @Override
    public void activate(CursorTool cursorTool) {
        this.t_tool = cursorTool;
        this.getValueEditor(cursorTool).attach();
    }

    @Override
    public void deactivate(CursorTool cursorTool) {
        this.getValueEditor(cursorTool).detach();
        this.t_tool = null;
    }

    protected ValueEditor getValueEditor(CursorTool cursorTool) {
        if (this.d_valueEditor != null) {
            return this.d_valueEditor;
        }
        this.d_valueEditor = new ValueEditor(cursorTool.getAttachedComponent());
        this.d_valueEditor.addListener(this);
        ValueEditorUtil.configure(this.d_valueEditor, this.d_lenUnit, "OFFSET");
        return this.d_valueEditor;
    }

    @Override
    public Cursor getCursor(CursorTool cursorTool) {
        return null;
    }

    @Override
    public boolean showDragGuides(CursorTool cursorTool) {
        return false;
    }

    @Override
    public boolean isDrawable(CursorTool cursorTool) {
        return !(cursorTool.getFunction() instanceof CompositeFunc);
    }

    public Point3d getAngledSnapBasis(CursorTool cursorTool) {
        return this.d_manipMgr.isManipulating() ? this.d_manipMgr.getManipBegin() : null;
    }

    @Override
    public Pair<SnapMode, IIsectFilter> getSnapInfo(CursorTool cursorTool) {
        if (this.d_manipMgr.isManipulating()) {
            Pair<SnapMode, IIsectFilter> pair = this.d_manipMgr.getSelectedHandle().getPickFilter();
            if (pair == null) {
                pair = new Pair<SnapMode, Object>(SnapMode.ANY, null);
            }
            return pair;
        }
        return super.getSnapInfo(cursorTool);
    }

    @Override
    public void mousePressed(CursorTool cursorTool, MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            IsectInfo isectInfo;
            if (!this.d_manipMgr.isManipulating() && this.d_manipMgr.canManipulate() && (isectInfo = this.findHighlightHandle(cursorTool)) != null && this.d_manipMgr.getSelectedHandle() != null) {
                this.d_manipMgr.begin(isectInfo.isectPoint);
                cursorTool.repaintSurface();
            }
        } else if (mouseEvent.getButton() == 3) {
            this.endManip(cursorTool, false);
        }
    }

    @Override
    public void mouseReleased(CursorTool cursorTool, MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && this.d_manipMgr.isManipulating() && this.d_manipMgr.isModified()) {
            this.endManip(cursorTool, true);
        }
    }

    @Override
    public void mouseMoved(CursorTool cursorTool, MouseEvent mouseEvent) {
        this.modify(cursorTool, mouseEvent);
    }

    @Override
    public void mouseDragged(CursorTool cursorTool, MouseEvent mouseEvent) {
        this.modify(cursorTool, mouseEvent);
    }

    protected IsectInfo findHighlightHandle(final CursorTool cursorTool) {
        Object object;
        IsectInfo isectInfo = null;
        if (this.d_manipMgr.canManipulate()) {
            object = new DefaultFilter(IHandle.class);
            Collection<IsectInfo> collection = this.d_picker.pick(new TaskProgress(), GeomPicker.Mode.PICK, cursorTool.getP1().referenceSnapSc, this.d_pickTol, (IIsectFilter)object);
            PlanarConstraint planarConstraint = cursorTool.getView().getCamera() instanceof OrthoCamera ? new PlanarConstraint(cursorTool.getView().getCamera().getViewPlane()) : null;
            ArrayList<IsectInfo> arrayList = new ArrayList<IsectInfo>();
            for (IsectInfo isectInfo2 : collection) {
                Point3d point3d = isectInfo2.isectPoint;
                if (!arrayList.isEmpty() && (!((IsectInfo)arrayList.get((int)0)).isectPoint.epsilonEquals(point3d, 1.0E-9) || ((IsectInfo)arrayList.get((int)0)).searchType != isectInfo2.searchType)) break;
                ISnapConstraint iSnapConstraint = ((IHandle)isectInfo2.obj).getConstraint(isectInfo2.isectPoint);
                if (ConstraintUtil.conflict(planarConstraint, iSnapConstraint)) continue;
                arrayList.add(isectInfo2);
            }
            Collections.sort(arrayList, new Comparator<IsectInfo>(){

                @Override
                public int compare(IsectInfo isectInfo, IsectInfo isectInfo2) {
                    int n;
                    IHandle iHandle = (IHandle)isectInfo.obj;
                    ISnapConstraint iSnapConstraint = iHandle.getConstraint(isectInfo.isectPoint);
                    IHandle iHandle2 = (IHandle)isectInfo2.obj;
                    ISnapConstraint iSnapConstraint2 = iHandle2.getConstraint(isectInfo2.isectPoint);
                    int n2 = this.rank(iSnapConstraint);
                    if (n2 != (n = this.rank(iSnapConstraint2))) {
                        return n2 - n;
                    }
                    if (iSnapConstraint instanceof LineConstraint && iSnapConstraint2 instanceof LineConstraint) {
                        LineConstraint lineConstraint = (LineConstraint)iSnapConstraint;
                        LineConstraint lineConstraint2 = (LineConstraint)iSnapConstraint2;
                        Vector3d vector3d = Util3D.normalize(cursorTool.getView().getCamera().getViewVector());
                        double d = Math.abs(lineConstraint.dir.dot(vector3d));
                        double d2 = Math.abs(lineConstraint2.dir.dot(vector3d));
                        return Double.compare(d, d2);
                    }
                    return 0;
                }

                private int rank(ISnapConstraint iSnapConstraint) {
                    if (iSnapConstraint instanceof LineConstraint) {
                        return 0;
                    }
                    if (iSnapConstraint instanceof PlanarConstraint) {
                        return 1;
                    }
                    return 2;
                }
            });
            if (!arrayList.isEmpty()) {
                isectInfo = (IsectInfo)arrayList.get(0);
            }
        }
        object = isectInfo != null ? (IHandle)isectInfo.obj : null;
        this.d_manipMgr.setSelectedHandle((IHandle)object);
        return isectInfo;
    }

    @Override
    public ISnapConstraint getSnapConstraint(CursorTool cursorTool) {
        if (this.d_manipMgr.isManipulating()) {
            Vector3d vector3d;
            ISnapConstraint iSnapConstraint = this.d_manipMgr.getManipConstraint();
            if (iSnapConstraint instanceof PlanarConstraint && cursorTool.getView().getCamera() instanceof OrthoCamera && Util3D.testPerpendicular(vector3d = Util3D.normalize(cursorTool.getView().getCamera().getViewVector()), ((PlanarConstraint)iSnapConstraint).plane.getNormal(), 1.0E-9)) {
                PlanarConstraint planarConstraint = new PlanarConstraint(new Plane3d(vector3d, this.d_manipMgr.getManipBegin()));
                try {
                    iSnapConstraint = ConstraintUtil.intersect(iSnapConstraint, (ISnapConstraint)planarConstraint);
                }
                catch (ConstraintUtil.NoIntersectionException noIntersectionException) {
                    // empty catch block
                }
            }
            if (iSnapConstraint == null && cursorTool.getView().getCamera() instanceof OrthoCamera && (this.d_manipMgr.getSelectedHandle().getPickFilter() == null || !((SnapMode)((Object)this.d_manipMgr.getSelectedHandle().getPickFilter().v1)).requiresFilter)) {
                vector3d = Util3D.normalize(cursorTool.getView().getCamera().getViewVector());
                iSnapConstraint = new PlanarConstraint(new Plane3d(vector3d, this.d_manipMgr.getManipBegin()));
            }
            return iSnapConstraint;
        }
        return null;
    }

    @Override
    public ISnapConstraint getDefaultConstraint(CursorTool cursorTool) {
        if (this.d_manipMgr.isManipulating()) {
            return cursorTool.suggestPlanarContraint(this.d_manipMgr.getManipBegin());
        }
        return null;
    }

    protected void modify(CursorTool cursorTool, MouseEvent mouseEvent) {
        if (this.d_manipMgr.isManipulating()) {
            try {
                CursorTool.SnapInfo snapInfo = cursorTool.getP1();
                if (snapInfo.constrained.isEmpty()) {
                    throw new ManipException();
                }
                Point3d point3d = snapInfo.constrained.getLast();
                this.d_manipMgr.modify(point3d);
                this.updateManip(cursorTool);
            }
            catch (ManipException manipException) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            cursorTool.repaintSurface();
        } else {
            this.findHighlightHandle(cursorTool);
        }
    }

    @Override
    public void valueEditorChanged(ValueEditor valueEditor, boolean bl) {
        Object object;
        Point3d point3d = this.d_manipMgr.getManipBegin();
        Unit unit = this.d_controller.getLengthUnits()[0];
        IOffset iOffset = ValueEditorUtil.getOffset(valueEditor);
        Point3d point3d2 = null;
        if (iOffset instanceof IOffset.Distance) {
            object = this.d_manipMgr.getManipLast();
            Vector3d vector3d = Util3D.vector(point3d, (Point3d)object);
            if (vector3d.lengthSquared() > 0.0) {
                vector3d.normalize();
            }
            IOffset.Distance distance = (IOffset.Distance)iOffset;
            vector3d.scale(distance.dist.getValue(unit));
            point3d2 = Util3D.add(point3d, (Tuple3d)vector3d);
        } else if (iOffset instanceof IOffset.DirOffset) {
            object = (IOffset.DirOffset)iOffset;
            point3d2 = ((IOffset.DirOffset)object).relative ? Util3D.add(point3d, (Tuple3d)((IOffset.DirOffset)object).offset.getPoint3dValue(unit)) : ((IOffset.DirOffset)object).offset.getPoint3dValue(unit);
        }
        if (point3d2 == null) {
            return;
        }
        if (this.d_manipMgr.getManipConstraint() != null && (point3d2 = this.d_manipMgr.getManipConstraint().snapPoint(point3d2)) == null) {
            return;
        }
        if (theUtil.eq0(point3d.distance(point3d2), 1.0E-9)) {
            return;
        }
        try {
            this.d_manipMgr.modify(point3d2);
        }
        catch (ManipException manipException) {
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
        if (bl) {
            this.endManip(this.t_tool, true);
        }
        valueEditor.getAttachedComponent().repaint();
    }

    @Override
    public void cancel(CursorTool cursorTool) {
        this.endManip(cursorTool, false);
    }

    private void endManip(CursorTool cursorTool, boolean bl) {
        if (this.d_manipMgr.isManipulating()) {
            this.d_manipMgr.end(bl);
            this.d_manipMgr.setSelectedHandle(null);
            ValueEditor valueEditor = this.getValueEditor(cursorTool);
            valueEditor.clear();
            valueEditor.getAttachedComponent().repaint();
        }
        if (this.t_tool != null) {
            this.t_tool.reset();
        }
    }

    public ManipMgr getManipMgr() {
        return this.d_manipMgr;
    }

    public boolean isManipulating() {
        return this.d_manipMgr.isManipulating();
    }

    @Override
    public String getStatusMessage(CursorTool cursorTool) {
        if (this.d_manipMgr.isManipulating()) {
            return this.getManipMsg(cursorTool);
        }
        Point3d point3d = cursorTool.getP1().constrained.isEmpty() ? cursorTool.getP1().referenceSnap : cursorTool.getP1().constrained.getLast();
        return cursorTool.toString(point3d);
    }

    protected String getManipMsg(CursorTool cursorTool) {
        return this.getValueEditor(cursorTool).getStatusMessage();
    }

    protected void updateManip(CursorTool cursorTool) {
        ValueEditor valueEditor = this.getValueEditor(cursorTool);
        Point3d point3d = this.d_manipMgr.getManipBegin();
        Point3d point3d2 = this.d_manipMgr.getManipLast();
        Unit unit = cursorTool.getModelView().getLengthUnits()[0];
        ValueEditorUtil.setOffset(valueEditor, new IOffset.Distance(new UnitDouble(point3d.distance(point3d2), unit)), false);
        ValueEditorUtil.setOffset(valueEditor, new IOffset.DirOffset(new UnitPoint3D(point3d2, unit), false), false);
        Point3d point3d3 = Util3D.sub(point3d2, (Tuple3d)point3d);
        ValueEditorUtil.setOffset(valueEditor, new IOffset.DirOffset(new UnitPoint3D(point3d3, unit), true), false);
    }
}

