/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.vecmath.Point2d;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.Pair;

public interface IToolFunction<T extends CursorTool> {
    public Cursor getCursor(T var1);

    public void activate(T var1);

    public void deactivate(T var1);

    public void cancel(T var1);

    public boolean isDrawable(T var1);

    public boolean showDragGuides(T var1);

    public boolean enableZoomAboutPoint(T var1);

    public boolean isAltMenuAccessEnabled();

    public Pair<SnapMode, IIsectFilter> getSnapInfo(T var1);

    public ISnapConstraint getSnapConstraint(T var1);

    public ISnapConstraint getDefaultConstraint(T var1);

    public void keyPressed(T var1, KeyEvent var2);

    public void keyReleased(T var1, KeyEvent var2);

    public void mouseEntered(T var1, MouseEvent var2);

    public void mouseExited(T var1, MouseEvent var2);

    public void mousePressed(T var1, MouseEvent var2);

    public void mouseReleased(T var1, MouseEvent var2);

    public void mouseDragged(T var1, MouseEvent var2);

    public void mouseMoved(T var1, MouseEvent var2);

    public boolean animate(T var1, IAnimSession var2);

    default public void mouseWheelMoved(T t, MouseWheelEvent mouseWheelEvent) {
        double d = (double)mouseWheelEvent.getWheelRotation() * 100.0 / (double)((CursorTool)t).getView().getSurface().getWidth();
        d = 1.0 / Math.pow(2.0, d);
        if (((CursorTool)t).enableZoomAboutPoint()) {
            Point2d point2d = ((CursorTool)t).getView().windowScreenToViewScreen(mouseWheelEvent.getPoint());
            ((CursorTool)t).getView().zoomAboutPoint(d, point2d);
        } else {
            ((CursorTool)t).getView().zoom(d);
        }
        ((CursorTool)t).repaintSurface();
    }

    public String getStatusMessage(T var1);
}

