/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;

public class DragFunc
extends AToolFunction<CursorTool> {
    public static final Cursor CURSOR = guiUtil.createTeciCursor("Drag", "DRAG.gif", 15, 15);
    public static final Icon ICON = guiUtil.loadTeciIcon("drag16.gif");
    private Point3d d_iniPickPos;

    @Override
    public Cursor getCursor(CursorTool cursorTool) {
        return CURSOR;
    }

    @Override
    public boolean isDrawable(CursorTool cursorTool) {
        return false;
    }

    private Point3d getPickPos(CursorTool cursorTool) {
        Camera camera = cursorTool.getView().getCamera();
        Plane3d plane3d = camera.getRefPlane();
        CursorTool.Ray ray = cursorTool.getPickRay();
        return Inter3D.linePlaneIntersection(ray.begin, ray.dir, plane3d, 1.0E-9);
    }

    @Override
    public void mousePressed(CursorTool cursorTool, MouseEvent mouseEvent) {
        this.d_iniPickPos = this.getPickPos(cursorTool);
    }

    @Override
    public void mouseDragged(CursorTool cursorTool, MouseEvent mouseEvent) {
        Point3d point3d = this.getPickPos(cursorTool);
        if (this.d_iniPickPos == null || point3d == null) {
            return;
        }
        Vector3d vector3d = new Vector3d();
        vector3d.sub(this.d_iniPickPos, point3d);
        Camera camera = cursorTool.getView().getCamera();
        camera.translateWorld(vector3d, true);
        cursorTool.repaintSurface();
    }

    @Override
    public void mouseReleased(CursorTool cursorTool, MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(CursorTool cursorTool, MouseEvent mouseEvent) {
    }
}

