/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.animate.IAnimator;
import thunderheadeng.geometry.Box3d;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.gui.colorscheme.ColorMgr;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.tool.IDeviceManager;
import thunderheadeng.gui.tool.IToolListener;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.gui.tool.ToolAdapter;
import thunderheadeng.io.nativexfer.INativeStream;
import thunderheadeng.io.nativexfer.INativelyMirrored;
import thunderheadeng.io.nativexfer.NativelyMirroredHelper;
import thunderheadeng.scene3d.SceneColors;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.GenericActor;
import thunderheadeng.scene3d.nativebuffered.IRenderable;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.nativebuffered.RenderComponent;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.CompositeIsectFilter;
import thunderheadeng.scene3d.picking.ConstraintUtil;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomPicker;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.LineConstraint;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.FilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.theUtil;

public class CursorTool
extends ToolAdapter
implements Tool,
IRenderable,
INativelyMirrored,
IAnimator {
    public static final int TOLMODE_X_OR_Y = 0;
    public static final int TOLMODE_X_AND_Y = 1;
    public static final double PIXEL_TOL = 2.0;
    public static final double SNAP_PIXEL_TOL = 10.0;
    private static final int CURSOR_SIZE = 4;
    public static final int CANCEL_KEY = 27;
    public static final int FINISH_KEY = 10;
    public static final int DISABLE_SNAP_KEY = 18;
    public static final int MODIFIER_KEY = 17;
    public static final int CONSTRAIN_KEY = 16;
    private static final Cursor INVIS_CURSOR = guiUtil.createTeciCursor("Blank", "blank16.gif", 0, 0);
    private IToolFunction d_toolFunc;
    private Pair<SnapMode, IIsectFilter> d_snapInfo;
    private ISnapConstraint d_setConstraint;
    private Pair<Future<SnapResult>, PointSnapper> d_snapTask;
    private SnapInfo d_p0;
    private SnapInfo d_p1;
    private ISnapConstraint d_lockedConstraint;
    private boolean d_mouseIn;
    private boolean d_active = false;
    private boolean d_cancelOnRightClick = true;
    private Set<Integer> d_pressedKeys = new HashSet<Integer>(4);
    private Set<Integer> d_pressedBtns = new HashSet<Integer>(3);
    private final IToolController d_controller;
    private final List<IToolListener> d_toolListeners = new ArrayList<IToolListener>();
    private View d_view;
    private Cursor d_toolCursor;
    private boolean d_pointerVisible = true;
    private boolean d_guidesVisible = true;
    private static NumberFormat d_numFormat = NumberFormat.getNumberInstance();
    private final AltDisabler d_altDisabler = new AltDisabler();
    private boolean d_consumeEvents;
    private final GenericActor d_snapDisplay3d;
    private final List<GenericActor> d_constraintDisplays;
    private NativelyMirroredHelper d_nativeHelper = new NativelyMirroredHelper(this);
    private final char d_separator;

    protected boolean showDragGuides() {
        return this.d_toolFunc != null ? this.d_toolFunc.showDragGuides(this) : false;
    }

    protected boolean enableZoomAboutPoint() {
        return this.d_toolFunc != null ? this.d_toolFunc.enableZoomAboutPoint(this) : true;
    }

    public CursorTool(IToolController iToolController) {
        this(iToolController, null);
    }

    public CursorTool(IToolController iToolController, IToolFunction iToolFunction) {
        this(iToolController, iToolFunction, false);
    }

    public CursorTool(IToolController iToolController, IToolFunction iToolFunction, boolean bl) {
        this.d_nativeHelper.createPeer();
        this.d_controller = iToolController;
        this.d_toolFunc = iToolFunction;
        this.d_snapDisplay3d = new GenericActor();
        this.d_constraintDisplays = new ArrayList<GenericActor>();
        this.d_snapInfo = null;
        this.d_p0 = this.d_p1 = new SnapInfo();
        this.d_consumeEvents = false;
        this.d_toolCursor = null;
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance();
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        char c = decimalFormatSymbols.getDecimalSeparator();
        this.d_separator = (char)(c != ',' ? 44 : 59);
        this.updateMouseProps();
        this.updateStatusMessage(" ");
        if (!bl) {
            this.init();
        }
    }

    protected void init() {
        this.nativeConstructed(CursorTool.class);
    }

    @Override
    public boolean update(IAnimSession iAnimSession) {
        if (this.getFunction() != null) {
            return this.getFunction().animate(this, iAnimSession);
        }
        return true;
    }

    public void beginAnimation() {
        IAnimSession iAnimSession = this.d_controller.getAnimSession();
        if (iAnimSession != null) {
            iAnimSession.addAnimator(this);
            iAnimSession.wakeUp();
        }
    }

    public void endAnimation() {
        IAnimSession iAnimSession = this.d_controller.getAnimSession();
        if (iAnimSession != null) {
            iAnimSession.removeAnimator(this);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void addToolListener(IToolListener iToolListener) {
        this.d_toolListeners.add(iToolListener);
    }

    @Override
    public void removeToolListener(IToolListener iToolListener) {
        this.d_toolListeners.remove(iToolListener);
    }

    private void notifyFinished(boolean bl) {
        ArrayList<IToolListener> arrayList = new ArrayList<IToolListener>(this.d_toolListeners);
        for (IToolListener iToolListener : arrayList) {
            iToolListener.toolEnded(this, bl);
        }
    }

    public IToolFunction getFunction() {
        return this.d_toolFunc;
    }

    public void setConsumeEvents(boolean bl) {
        this.d_consumeEvents = bl;
    }

    public void updateMouseProps() {
        Cursor cursor = this.getCursor();
        if (cursor != null || this.d_pointerVisible) {
            this.setToolCursor(cursor);
        } else {
            this.setToolCursor(INVIS_CURSOR);
        }
    }

    protected Cursor getCursor() {
        return this.d_toolFunc != null ? this.d_toolFunc.getCursor(this) : this.d_toolCursor;
    }

    protected boolean repaintDuringMove(MouseEvent mouseEvent) {
        return this.isDrawable();
    }

    protected boolean repaintDuringDrag(MouseEvent mouseEvent) {
        return this.isDrawable();
    }

    public void setPointerVisible(boolean bl) {
        this.d_pointerVisible = bl;
        this.updateMouseProps();
    }

    public boolean isPointerVisible() {
        return this.d_pointerVisible;
    }

    public void setGuidesVisible(boolean bl) {
        this.d_guidesVisible = bl;
        this.markNativeDirty();
    }

    public boolean areGuidesVisible() {
        return this.d_guidesVisible;
    }

    public void setView(View view) {
        this.d_view = view;
    }

    public View getView() {
        return this.d_view;
    }

    public Component getAttachedComponent() {
        return this.d_controller.getRenderComp();
    }

    public ColorMgr getColors() {
        return this.d_controller.getColors();
    }

    protected void setToolCursor(Cursor cursor) {
        this.d_toolCursor = cursor;
    }

    protected Cursor getToolCursor() {
        return this.d_toolCursor;
    }

    public void setCancelOnRightClick(boolean bl) {
        this.d_cancelOnRightClick = bl;
    }

    public boolean getCancelOnRightClick() {
        return this.d_cancelOnRightClick;
    }

    protected boolean isPointVisible(Point3d point3d) {
        if (this.getAttachedComponent() instanceof RenderComponent) {
            RenderComponent renderComponent = (RenderComponent)this.getAttachedComponent();
            Point3d point3d2 = this.getView().worldToScreen(point3d);
            float f = renderComponent.getZValue((int)point3d2.x, (int)point3d2.y);
            return Math.abs(point3d2.z - (double)f) < 1.0E-4 || point3d2.z < (double)f;
        }
        return true;
    }

    protected void getPickRay(Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        Camera camera = this.getView().getCamera();
        point3d2.set(this.getView().worldToScreen(point3d));
        point3d2.z = 0.0;
        point3d2.set(this.getView().screenToWorld(point3d2));
        vector3d.set(camera.getViewVector(point3d));
        vector3d.normalize();
    }

    public Ray getPickRay(Point3d point3d) {
        Ray ray = new Ray();
        this.getPickRay(point3d, ray.begin, ray.dir);
        return ray;
    }

    public Ray getPickRay() {
        return this.getPickRay(this.getP1().referenceSnap);
    }

    public String toString(double d) {
        Unit[] unitArray = this.d_controller.getLengthUnits();
        double d2 = UnitDouble.convert(d, unitArray[0], unitArray[1]);
        return d_numFormat.format(d2) + " " + unitArray[1];
    }

    public String toString(Point3d point3d) {
        return this.pointToString(point3d, "(", this.d_separator + " ", ")");
    }

    public String pointToString(Point3d point3d, String string, String string2, String string3) {
        Unit[] unitArray = this.d_controller.getLengthUnits();
        Unit unit = unitArray[1];
        double d = UnitDouble.convert(point3d.x, unitArray[0], unit);
        double d2 = UnitDouble.convert(point3d.y, unitArray[0], unit);
        double d3 = UnitDouble.convert(point3d.z, unitArray[0], unit);
        return string + this.format(d) + string2 + this.format(d2) + string2 + this.format(d3) + string3 + " " + unit;
    }

    public String format(double d) {
        return d_numFormat.format(d);
    }

    public Set<Integer> getPressedButtons() {
        return this.d_pressedBtns;
    }

    protected static boolean testBit(int n, int n2) {
        return (n & n2) == n2;
    }

    protected void updatePressedModifiers(InputEvent inputEvent) {
        int[][] nArrayArray;
        int n = inputEvent.getModifiersEx();
        int[][] nArrayArray2 = nArrayArray = new int[][]{{1024, 1}, {2048, 2}, {4096, 3}};
        int n2 = nArrayArray2.length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray = nArrayArray2[i];
            if (CursorTool.testBit(n, nArray[0])) {
                this.d_pressedBtns.add(nArray[1]);
                continue;
            }
            this.d_pressedBtns.remove(nArray[1]);
        }
        for (int[] nArray : nArrayArray2 = new int[][]{{512, 18}, {64, 16}, {128, 17}, {256, 157}}) {
            if (CursorTool.testBit(n, nArray[0])) {
                this.d_pressedKeys.add(nArray[1]);
                continue;
            }
            this.d_pressedKeys.remove(nArray[1]);
        }
    }

    @Override
    public final void mousePressed(MouseEvent mouseEvent) {
        this.cancelSnapTask();
        this.pauseRepaint();
        this.updatePressedModifiers(mouseEvent);
        this.setSnap(this.d_p1, true);
        if (this.d_toolFunc != null) {
            this.d_toolFunc.mousePressed(this, mouseEvent);
        }
        this.resumeRepaint();
    }

    public boolean isActive() {
        return this.d_active;
    }

    protected Point getComponentMousePos(MouseEvent mouseEvent) {
        Point point;
        if (!this.getAttachedComponent().isShowing()) {
            return null;
        }
        Point point2 = this.getAttachedComponent().getLocationOnScreen();
        Dimension dimension = this.getAttachedComponent().getSize();
        if (mouseEvent != null) {
            point = mouseEvent.getPoint();
        } else {
            point = MouseInfo.getPointerInfo().getLocation();
            point = new Point(point.x - point2.x, point.y - point2.y);
        }
        if (point.x >= 0 && point.y >= 0 && point.x < dimension.width && point.y < dimension.height) {
            return point;
        }
        return null;
    }

    public IDeviceManager getDevices() {
        return this.d_controller.getDevices();
    }

    @Override
    public void activate() {
        this.pauseRepaint();
        this.showToolCursor();
        this.checkMouseIn();
        this.d_active = true;
        if (this.d_toolFunc != null) {
            this.d_toolFunc.activate(this);
        }
        this.d_altDisabler.activate();
        this.resumeRepaint();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CursorTool.this.getAttachedComponent().requestFocusInWindow();
            }
        });
    }

    protected boolean checkMouseIn() {
        Point point = this.getComponentMousePos(null);
        if (point != null) {
            MouseEvent mouseEvent = new MouseEvent(this.getAttachedComponent(), 0, 0L, 0, point.x, point.y, 0, false);
            this.mouseEntered(mouseEvent);
            this.mouseMoved(mouseEvent);
            return true;
        }
        return false;
    }

    @Override
    public void deactivate() {
        this.pauseRepaint();
        this.d_altDisabler.deactivate();
        this.restoreSystemCursor();
        Point point = this.getAttachedComponent().getMousePosition();
        if (point != null) {
            MouseEvent mouseEvent = new MouseEvent(this.getAttachedComponent(), 0, 0L, 0, point.x, point.y, 0, false);
            this.mouseExited(mouseEvent);
        }
        this.d_active = false;
        if (this.d_toolFunc != null) {
            this.d_toolFunc.deactivate(this);
        }
        this.reset();
        this.resumeRepaint();
    }

    @Override
    public void cancel() {
        if (this.d_toolFunc != null) {
            this.d_toolFunc.cancel(this);
        }
        this.notifyFinished(true);
    }

    public void finish() {
        this.notifyFinished(false);
    }

    public void pauseRepaint() {
        this.d_view.getSurface().pauseRender();
    }

    public void resumeRepaint() {
        this.d_view.getSurface().resumeRender();
    }

    public void resumeRepaint(boolean bl) {
        this.d_view.getSurface().resumeRender(bl);
    }

    @Override
    public void repaintSurface() {
        if (this.d_view != null) {
            this.getView().getSurface().render();
        }
    }

    public void reset() {
        this.cancelSnapTask();
        this.d_p0 = this.d_p1 = new SnapInfo(this.d_p1.timestamp, this.d_p1.referenceSnapSc, this.d_p1.referenceSnap, (Collection<IsectInfo>)Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        this.updateDisplay3d(this.d_p1);
        this.d_lockedConstraint = null;
    }

    @Override
    public final void mouseReleased(MouseEvent mouseEvent) {
        this.cancelSnapTask();
        this.pauseRepaint();
        this.updateStatusMessage();
        this.updatePressedModifiers(mouseEvent);
        if (this.isDrawable()) {
            this.repaintSurface();
        }
        if (this.d_toolFunc != null) {
            this.d_toolFunc.mouseReleased(this, mouseEvent);
        }
        if (mouseEvent.getButton() == 3 && this.getCancelOnRightClick() && !this.isDragging()) {
            this.cancel();
        }
        this.markNativeDirty();
        this.resumeRepaint();
    }

    @Override
    public final void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseDragged(final MouseEvent mouseEvent) {
        this.d_mouseIn = true;
        this.updateMovement(mouseEvent, new Runnable(){

            @Override
            public void run() {
                if (CursorTool.this.d_toolFunc != null) {
                    CursorTool.this.d_toolFunc.mouseDragged(CursorTool.this, mouseEvent);
                }
            }
        });
    }

    protected void updateLockedConstraint() {
        if (this.d_pressedKeys.contains(16)) {
            if (this.d_lockedConstraint == null) {
                this.d_lockedConstraint = this.getFirstConstraint(this.d_p1);
            }
        } else {
            this.d_lockedConstraint = null;
        }
    }

    protected boolean wasDragged(int n) {
        return this.aboveTolerance(n);
    }

    @Override
    public final void mouseMoved(final MouseEvent mouseEvent) {
        this.d_mouseIn = true;
        this.updateMovement(mouseEvent, new Runnable(){

            @Override
            public void run() {
                if (CursorTool.this.d_toolFunc != null) {
                    CursorTool.this.d_toolFunc.mouseMoved(CursorTool.this, mouseEvent);
                }
            }
        });
    }

    @Override
    public final void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.updatePressedModifiers(mouseWheelEvent);
        if (this.d_toolFunc != null) {
            this.d_toolFunc.mouseWheelMoved(this, mouseWheelEvent);
        }
    }

    protected void cancelSnapTask() {
        if (this.d_snapTask != null) {
            ((PointSnapper)this.d_snapTask.v2).cancel();
            this.d_snapTask = null;
        }
    }

    private void updateMovement(MouseEvent mouseEvent, Runnable runnable) {
        this.pauseRepaint();
        this.updateLockedConstraint();
        this.cancelSnapTask();
        Point2d point2d = this.getView().windowScreenToViewScreen(mouseEvent.getPoint());
        PointSnapper pointSnapper = new PointSnapper(this, point2d);
        try {
            SnapResult snapResult = pointSnapper.call();
            this.setSnap(this.snapConstraint(point2d, snapResult), false);
            runnable.run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
        }
        this.resumeRepaint();
    }

    private Runnable getCompleteTask(final Point2d point2d, final Future<SnapResult> future, final Runnable runnable) {
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                SnapResult snapResult;
                try {
                    snapResult = (SnapResult)future.get();
                }
                catch (ExecutionException executionException) {
                    if (!(executionException.getCause() instanceof CancellationException)) {
                        executionException.printStackTrace();
                    }
                    return;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return;
                }
                Runnable runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        if (CursorTool.this.d_snapTask != null && future == ((CursorTool)CursorTool.this).d_snapTask.v1) {
                            CursorTool.this.d_snapTask = null;
                            CursorTool.this.pauseRepaint();
                            CursorTool.this.setSnap(CursorTool.this.snapConstraint(point2d, snapResult), false);
                            runnable.run();
                            CursorTool.this.resumeRepaint();
                        }
                    }
                };
                EventQueue.invokeLater(runnable2);
            }
        };
        return runnable2;
    }

    private void setSnap(SnapInfo snapInfo, boolean bl) {
        if (bl) {
            this.d_p0 = snapInfo;
        }
        this.d_p1 = snapInfo;
        this.updateDisplay3d(this.d_p1);
        this.markNativeDirty();
        if (this.isDrawable()) {
            this.repaintSurface();
        }
        this.updateStatusMessage();
    }

    public void updateStatusMessage() {
        if (this.d_controller.getStatusMessage() != null) {
            this.d_controller.getStatusMessage().setMessage(this.getStatusMessage());
        }
    }

    protected void updateStatusMessage(String string) {
        if (this.d_controller.getStatusMessage() != null) {
            this.d_controller.getStatusMessage().setMessage(string);
        }
    }

    protected String getStatusMessage() {
        String string = this.d_toolFunc != null ? this.d_toolFunc.getStatusMessage(this) : null;
        return string == null ? "" : string;
    }

    @Override
    public final void mouseEntered(final MouseEvent mouseEvent) {
        this.d_mouseIn = true;
        this.updateMovement(mouseEvent, new Runnable(){

            @Override
            public void run() {
                if (CursorTool.this.d_toolFunc != null) {
                    CursorTool.this.d_toolFunc.mouseEntered(CursorTool.this, mouseEvent);
                }
            }
        });
        this.showToolCursor();
    }

    @Override
    public final void mouseExited(MouseEvent mouseEvent) {
        this.cancelSnapTask();
        boolean bl = this.isDrawable();
        this.pauseRepaint();
        this.d_mouseIn = false;
        this.updatePressedModifiers(mouseEvent);
        if (this.d_toolFunc != null) {
            this.d_toolFunc.mouseExited(this, mouseEvent);
        }
        this.updateStatusMessage(" ");
        this.showToolCursor();
        this.markNativeDirty();
        if (bl) {
            this.repaintSurface();
        }
        this.resumeRepaint();
    }

    public boolean dragAboveTolerance(int n) {
        return this.d_p1.timestamp - this.d_p0.timestamp > 200L && this.aboveTolerance(n);
    }

    public boolean aboveTolerance(int n) {
        return CursorTool.aboveTolerance(n, this.getP0().referenceSnapSc, this.getP1().referenceSnapSc);
    }

    public static boolean aboveTolerance(int n, Point2d point2d, Point2d point2d2) {
        double d = Math.abs(point2d.x - point2d2.x);
        double d2 = Math.abs(point2d.y - point2d2.y);
        if (n == 1) {
            return d >= 2.0 && d2 >= 2.0;
        }
        if (n == 0) {
            return d >= 2.0 || d2 >= 2.0;
        }
        return true;
    }

    public IToolController getModelView() {
        return this.d_controller;
    }

    public double getTolWorld() {
        return this.d_view.screenToWorld(10.0);
    }

    public boolean isDragging(int n) {
        return this.d_pressedBtns.contains(n);
    }

    public boolean isDragging() {
        return !this.d_pressedBtns.isEmpty();
    }

    public boolean isKeyPressed(int n) {
        return this.d_pressedKeys.contains(n);
    }

    public Set<Integer> getPressedKeys() {
        return this.d_pressedKeys;
    }

    protected boolean consumeKeyEvent(KeyEvent keyEvent) {
        return this.d_consumeEvents;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.pauseRepaint();
        if (this.consumeKeyEvent(keyEvent)) {
            keyEvent.consume();
        }
        switch (keyEvent.getKeyCode()) {
            case 27: {
                this.cancel();
            }
        }
        this.updatePressedModifiers(keyEvent);
        this.d_pressedKeys.add(keyEvent.getKeyCode());
        this.updateStatusMessage();
        if (this.d_toolFunc != null) {
            this.d_toolFunc.keyPressed(this, keyEvent);
        }
        this.resumeRepaint();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.consumeKeyEvent(keyEvent)) {
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.pauseRepaint();
        if (this.consumeKeyEvent(keyEvent)) {
            keyEvent.consume();
        }
        this.updatePressedModifiers(keyEvent);
        this.d_pressedKeys.remove(keyEvent.getKeyCode());
        this.updateStatusMessage();
        if (this.d_toolFunc != null) {
            this.d_toolFunc.keyReleased(this, keyEvent);
        }
        this.resumeRepaint();
    }

    public boolean isMouseIn() {
        return this.d_mouseIn;
    }

    public void showToolCursor() {
        this.getAttachedComponent().setCursor(this.d_toolCursor);
    }

    protected void restoreSystemCursor() {
        this.getAttachedComponent().setCursor(null);
    }

    protected boolean isDrawable() {
        return !(!this.isDragging() && !this.d_mouseIn || this.d_toolFunc != null && !this.d_toolFunc.isDrawable(this));
    }

    private void write(INativeStream iNativeStream, Point2d point2d) {
        iNativeStream.writeDoubles(point2d.x, point2d.y);
    }

    private void write(INativeStream iNativeStream, Point3d point3d) {
        iNativeStream.writeDoubles(point3d.x, point3d.y, point3d.z);
    }

    @Override
    public void writeNativeData(INativeStream iNativeStream) {
        Object object;
        iNativeStream.writeBoolean(this.isDrawable());
        SnapInfo snapInfo = this.getP0();
        this.write(iNativeStream, snapInfo.referenceSnapSc);
        if (this.d_snapTask != null) {
            this.write(iNativeStream, ((PointSnapper)this.d_snapTask.v2).d_viewScr);
            iNativeStream.writeBoolean(false);
        } else {
            object = this.getP1();
            this.write(iNativeStream, ((SnapInfo)object).referenceSnapSc);
            iNativeStream.writeBoolean(((SnapInfo)object).isSnapped());
        }
        object = this.getColors().getColor(SceneColors.TOOL_GUIDES_COLOR).getComponents(new float[4]);
        iNativeStream.writeFloats((float[])object);
        float[] fArray = this.getColors().getColor(SceneColors.TOOL_COLOR).getComponents(new float[4]);
        iNativeStream.writeFloats(fArray);
        float[] fArray2 = this.getColors().getColor(SceneColors.SNAP_POINT_COLOR).getComponents(new float[4]);
        iNativeStream.writeFloats(fArray2);
        iNativeStream.writeBooleans(this.areGuidesVisible(), this.showDragGuides(), this.isDragging());
    }

    @Override
    public Class resolveNativeClass() {
        return CursorTool.class;
    }

    @Override
    public void markNativeClean() {
        this.d_nativeHelper.markNativeClean();
    }

    @Override
    public void markNativeDirty() {
        this.d_nativeHelper.markNativeDirty();
    }

    @Override
    public void nativeConstructed(Class clazz) {
        this.d_nativeHelper.nativeConstructed(clazz);
    }

    @Override
    public Integer getKey() {
        return this.d_nativeHelper.getKey();
    }

    public Point2d toScreen(Point3d point3d) {
        Point3d point3d2 = this.getView() != null ? this.getView().worldToScreen(point3d) : new Point3d();
        return new Point2d(point3d2.x, point3d2.y);
    }

    public SnapInfo getP0() {
        return this.d_p0;
    }

    public SnapInfo getP1() {
        return this.d_p1;
    }

    @Deprecated
    protected final void snapP0(MouseEvent mouseEvent) {
    }

    @Deprecated
    protected final void snapP1(MouseEvent mouseEvent) {
    }

    protected void isect(Point3d point3d, Vector3d vector3d, Plane3d plane3d, List<Double> list) {
        double d = Inter3D.linePlaneIntersectionT(point3d, vector3d, plane3d, 1.0E-9);
        if (Double.isNaN(d)) {
            return;
        }
        list.add(d);
    }

    protected Point3d[] clipInfLine(Box3d box3d, Point3d point3d, Vector3d vector3d) {
        int n = 0;
        int n2 = 1;
        int[] nArray = new int[]{2, 3, 4, 5};
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int n3 : nArray) {
            Plane3d plane3d = box3d.getPlanes()[n3];
            this.isect(point3d, vector3d, plane3d, arrayList);
        }
        if (arrayList.size() % 2 == 1) {
            this.isect(point3d, vector3d, box3d.getPlanes()[n], arrayList);
            if (arrayList.size() % 2 == 1) {
                this.isect(point3d, vector3d, box3d.getPlanes()[n2], arrayList);
                if (arrayList.size() % 2 == 1) {
                    return null;
                }
            }
        }
        Object object = new ConvexHull(box3d.getPlanes()[nArray[0]], box3d.getPlanes()[nArray[1]], box3d.getPlanes()[nArray[2]], box3d.getPlanes()[nArray[3]]);
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            Point3d point3d2;
            Point3d point3d3;
            Point3d point3d4;
            double d;
            double d2 = (Double)arrayList.get(i);
            if (theUtil.eq(d2, d = ((Double)arrayList.get(i + 1)).doubleValue(), 1.0E-9) || !((ConvexHull)object).contains(point3d4 = Util3D.getMidPoint(point3d3 = Util3D.linePoint(point3d, vector3d, d2), point3d2 = Util3D.linePoint(point3d, vector3d, d)), 1.0E-9)) continue;
            return new Point3d[]{point3d3, point3d2};
        }
        return null;
    }

    protected ISnapConstraint getFirstConstraint(SnapInfo snapInfo) {
        Iterator<IsectInfo> iterator = snapInfo.snaps.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        IsectInfo isectInfo = iterator.next();
        if (isectInfo.obj instanceof ISnapConstraint) {
            return (ISnapConstraint)isectInfo.obj;
        }
        Point2d point2d = this.toScreen(isectInfo.isectPoint);
        Predicate<IsectInfo> predicate = null;
        Collection<IsectInfo> collection = snapInfo.snaps;
        if (collection instanceof FilteredCollection) {
            FilteredCollection filteredCollection = (FilteredCollection)collection;
            predicate = filteredCollection.getFilter();
            collection = filteredCollection.getUnfiltered();
        }
        for (IsectInfo isectInfo2 : collection) {
            Point2d point2d2;
            if (!(isectInfo2.obj instanceof ISnapConstraint) || !(point2d2 = this.toScreen(isectInfo2.isectPoint)).epsilonEquals(point2d, 1.0E-9) || predicate != null && !predicate.test(isectInfo2)) continue;
            return (ISnapConstraint)isectInfo2.obj;
        }
        return null;
    }

    protected void updateDisplay3d(SnapInfo snapInfo) {
        ISnapConstraint[] iSnapConstraintArray;
        Color color = this.getColors().getColor(SceneColors.TOOL_GUIDES_COLOR);
        ArrayList<GenericActor> arrayList = new ArrayList<GenericActor>(this.d_constraintDisplays);
        this.d_constraintDisplays.clear();
        Box3d box3d = null;
        for (ISnapConstraint object2 : iSnapConstraintArray = new ISnapConstraint[]{this.d_lockedConstraint, this.getFirstConstraint(snapInfo)}) {
            if (!(object2 instanceof LineConstraint)) continue;
            if (box3d == null) {
                int n = this.getView().getSurface().getWidth();
                int n2 = this.getView().getSurface().getHeight();
                box3d = this.getView().toFrustum(new Point2d(0.0, 0.0), new Point2d(n, n2));
            }
            LineConstraint lineConstraint = (LineConstraint)object2;
            Point3d[] point3dArray = this.clipInfLine(box3d, lineConstraint.p, lineConstraint.dir);
            if (point3dArray == null) continue;
            GenericActor genericActor = new GenericActor();
            genericActor.setLineStipplePattern(1, (short)-3856);
            double d = object2 == this.d_lockedConstraint ? 2.0 : 1.0;
            genericActor.setLineWidth(d);
            genericActor.setEdgeColor(color);
            genericActor.resetData();
            genericActor.addLine(point3dArray[0], point3dArray[1]);
            genericActor.finalizeData();
            this.d_constraintDisplays.add(genericActor);
        }
        boolean bl = this.d_snapDisplay3d.isEmpty();
        this.d_snapDisplay3d.setLineStipplePattern(1, (short)-256);
        this.d_snapDisplay3d.setLineWidth(2.0);
        this.d_snapDisplay3d.setEdgeColor(color);
        this.d_snapDisplay3d.setPointSize(5.0);
        this.d_snapDisplay3d.setVertexColor(color);
        this.d_snapDisplay3d.resetData();
        if (snapInfo.isSnapped()) {
            Point3d object = snapInfo.referenceSnap;
            for (Point3d point3d : snapInfo.constrained) {
                if (point3d.epsilonEquals(object, 1.0E-9)) continue;
                this.d_snapDisplay3d.addLine(object, point3d);
                this.d_snapDisplay3d.addPoint(point3d);
                object = point3d;
            }
        }
        this.d_snapDisplay3d.finalizeData();
        ModelScene modelScene = this.d_controller.getToolScenes()[0];
        if (modelScene != null) {
            modelScene.removeObjects(arrayList);
            modelScene.addObjects(this.d_constraintDisplays);
            if (!this.d_snapDisplay3d.isEmpty()) {
                modelScene.addObjects(this.d_snapDisplay3d);
            } else {
                modelScene.removeObjects(this.d_snapDisplay3d);
            }
            if (!arrayList.isEmpty() || !this.d_constraintDisplays.isEmpty() || bl != this.d_snapDisplay3d.isEmpty()) {
                this.repaintSurface();
            }
        }
    }

    private SnapInfo snapConstraint(Point2d point2d, SnapResult snapResult) {
        Object object;
        Object object2;
        Collection<IsectInfo> collection = snapResult.snappedInfos;
        List list = snapResult.searchedInfos;
        List list2 = !list.isEmpty() ? list : collection;
        Iterator<IsectInfo> iterator = list2.iterator();
        Point3d point3d = iterator.hasNext() ? iterator.next().isectPoint : null;
        Point3d point3d2 = point3d == null ? this.getView().screenToWorld(new Point3d(point2d.x, point2d.y, 0.0)) : point3d;
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        try {
            object2 = Arrays.asList(this.d_lockedConstraint, this.getSnapConstraint());
            object = object2.iterator();
            while (object.hasNext()) {
                Pair<Point3d, Point3d> pair;
                Ray ray;
                ISnapConstraint iSnapConstraint = object.next();
                if (iSnapConstraint == null) continue;
                if (point3d == null) {
                    ray = this.getPickRay(point3d2);
                    pair = this.constrain(iSnapConstraint, ray);
                    point3d2 = (Point3d)pair.v1;
                    list = Collections.EMPTY_LIST;
                    point3d = (Point3d)pair.v2;
                } else if (this.getView().getCamera() instanceof OrthoCamera) {
                    ray = this.getPickRay(point3d);
                    pair = this.constrain(iSnapConstraint, ray);
                    point3d = (Point3d)pair.v2;
                } else {
                    point3d = this.constrain(iSnapConstraint, point3d);
                }
                arrayList.add(point3d);
            }
        }
        catch (ConstraintException constraintException) {
            return new SnapInfo(System.currentTimeMillis(), this.toScreen(point3d2), point3d2, list, new Point3d[0]);
        }
        if (point3d == null) {
            try {
                object2 = this.getDefaultConstraint();
                object = this.constrain((ISnapConstraint)object2, this.getPickRay(point3d2));
                point3d2 = (Point3d)((Pair)object).v1;
                list = Collections.EMPTY_LIST;
                point3d = (Point3d)((Pair)object).v2;
            }
            catch (ConstraintException constraintException) {
                point3d = point3d2;
            }
        }
        if (arrayList.isEmpty()) {
            arrayList.add(point3d);
        }
        return new SnapInfo(System.currentTimeMillis(), this.toScreen(point3d2), point3d2, list, arrayList);
    }

    protected Pair<Point3d, Point3d> constrain(ISnapConstraint iSnapConstraint, Ray ray) throws ConstraintException {
        if (iSnapConstraint == null) {
            return new Pair<Point3d, Point3d>(ray.begin, ray.begin);
        }
        Pair<Point3d, Point3d> pair = iSnapConstraint.snapRay(ray.begin, ray.dir);
        if (pair == null) {
            throw new ConstraintException();
        }
        return pair;
    }

    protected Point3d constrain(ISnapConstraint iSnapConstraint, Point3d point3d) throws ConstraintException {
        if (iSnapConstraint == null) {
            return point3d;
        }
        Point3d point3d2 = iSnapConstraint.snapPoint(point3d);
        if (point3d2 == null) {
            throw new ConstraintException();
        }
        return point3d2;
    }

    public GeomPicker getSnapper() {
        return this.getModelView().getSnapper();
    }

    private IIsectFilter getConstraintSnapFilter() {
        ISnapConstraint iSnapConstraint = this.getSnapConstraint();
        final ArrayList<ISnapConstraint> arrayList = new ArrayList<ISnapConstraint>(2);
        if (iSnapConstraint != null) {
            arrayList.add(iSnapConstraint);
        }
        if (this.d_lockedConstraint != null) {
            arrayList.add(this.d_lockedConstraint);
        }
        if (!arrayList.isEmpty()) {
            return new DefaultFilter(){

                @Override
                public boolean acceptPickObject(Object object) {
                    if (object instanceof ISnapConstraint) {
                        for (ISnapConstraint iSnapConstraint : arrayList) {
                            if (!ConstraintUtil.conflict(iSnapConstraint, (ISnapConstraint)object)) continue;
                            return false;
                        }
                    }
                    return true;
                }
            };
        }
        return null;
    }

    protected boolean isSnapEnabled() {
        return !this.d_pressedKeys.contains(18);
    }

    protected Pair<SnapMode, IIsectFilter> getSnapInfo() {
        if (!this.isSnapEnabled() || this.getSnapper() == null) {
            return new Pair<SnapMode, Object>(SnapMode.NONE, null);
        }
        if (this.d_snapInfo != null) {
            return this.d_snapInfo;
        }
        if (this.d_toolFunc != null) {
            return this.d_toolFunc.getSnapInfo(this);
        }
        return new Pair<SnapMode, Object>(SnapMode.NONE, null);
    }

    public void setSnapInfo(SnapMode snapMode, IIsectFilter iIsectFilter) {
        this.d_snapInfo = new Pair<SnapMode, IIsectFilter>(snapMode, iIsectFilter);
    }

    public void setSnapConstraint(ISnapConstraint iSnapConstraint) {
        this.d_setConstraint = iSnapConstraint;
    }

    public ISnapConstraint getSnapConstraint() {
        if (this.d_setConstraint != null) {
            return this.d_setConstraint;
        }
        if (this.d_toolFunc != null) {
            return this.d_toolFunc.getSnapConstraint(this);
        }
        return null;
    }

    public ISnapConstraint getDefaultConstraint() {
        Object object;
        if (this.d_toolFunc != null && (object = this.d_toolFunc.getDefaultConstraint(this)) != null) {
            return object;
        }
        object = null;
        if (this.getView().getCamera() instanceof OrthoCamera) {
            object = new Vector3d(this.getView().getCamera().getViewVector());
            ((Vector3d)object).normalize();
            ((Tuple3d)object).negate();
        } else {
            object = new Vector3d(0.0, 0.0, 1.0);
        }
        return new PlanarConstraint(new Plane3d((Vector3d)object, new Point3d(0.0, 0.0, 0.0)));
    }

    public PlanarConstraint suggestPlanarContraint(Point3d point3d) {
        Vector3d vector3d;
        if (this.getView().getCamera() instanceof OrthoCamera) {
            vector3d = Util3D.normalize(this.getView().getCamera().getViewVector());
            vector3d.negate();
        } else {
            vector3d = Util3D.normalize(this.getView().getCamera().getViewVector(point3d));
            vector3d.negate();
            vector3d = GeomUtil.getClosestAxis(vector3d);
        }
        return new PlanarConstraint(new Plane3d(vector3d, point3d));
    }

    protected boolean isAltMenuAccessEnabled() {
        if (this.d_toolFunc != null) {
            return this.d_toolFunc.isAltMenuAccessEnabled();
        }
        return true;
    }

    public static class SnapInfo {
        public final long timestamp;
        public final Point3d referenceSnap;
        public final Point2d referenceSnapSc;
        public final Collection<IsectInfo> snaps;
        public final Deque<Point3d> constrained;

        public SnapInfo() {
            this(Long.MAX_VALUE, new Point2d(), new Point3d(), (Collection<IsectInfo>)Collections.EMPTY_LIST, new Point3d());
        }

        public SnapInfo(long l, Point2d point2d, Point3d point3d, Collection<IsectInfo> collection, Point3d ... point3dArray) {
            this(l, point2d, point3d, collection, Arrays.asList(point3dArray));
        }

        public SnapInfo(long l, Point2d point2d, Point3d point3d, Collection<IsectInfo> collection, Collection<Point3d> collection2) {
            this.timestamp = l;
            this.constrained = new ArrayDeque<Point3d>(collection2);
            if (!this.constrained.isEmpty() && this.constrained.getLast().epsilonEquals(point3d, 1.0E-9)) {
                this.constrained.clear();
                this.constrained.push(point3d);
            }
            this.referenceSnapSc = point2d;
            this.referenceSnap = point3d;
            this.snaps = collection;
        }

        public boolean isSnapped() {
            return !this.constrained.isEmpty() && (this.constrained.getLast() != this.referenceSnap || !this.snaps.isEmpty());
        }
    }

    private class AltDisabler
    implements FocusListener {
        private final KeyEventDispatcher altDisabler = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 18 && !CursorTool.this.isAltMenuAccessEnabled()) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(CursorTool.this.getAttachedComponent(), keyEvent);
                    return true;
                }
                return false;
            }
        };

        private AltDisabler() {
        }

        public void activate() {
            CursorTool.this.getAttachedComponent().addFocusListener(this);
            if (CursorTool.this.getAttachedComponent().isFocusOwner()) {
                this.attach();
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.attach();
        }

        protected void attach() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.altDisabler);
        }

        public void deactivate() {
            CursorTool.this.getAttachedComponent().removeFocusListener(this);
            this.detach();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.detach();
        }

        public void detach() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.altDisabler);
        }
    }

    private static class PointSnapper
    implements Callable<SnapResult> {
        private final GeomPicker d_snapper;
        private final View d_view;
        private final Point2d d_viewScr;
        private final IIsectFilter d_constraintFilter;
        private final Pair<SnapMode, IIsectFilter> d_snapInfo;
        private final TaskProgress d_progress;

        public PointSnapper(CursorTool cursorTool, Point2d point2d) {
            this.d_viewScr = point2d;
            this.d_snapper = cursorTool.getSnapper();
            this.d_view = cursorTool.getView();
            this.d_constraintFilter = cursorTool.getConstraintSnapFilter();
            this.d_snapInfo = cursorTool.getSnapInfo();
            this.d_progress = new TaskProgress();
        }

        public void cancel() {
            this.d_progress.cancel();
        }

        @Override
        public SnapResult call() throws Exception {
            SnapResult snapResult = new SnapResult();
            IIsectFilter iIsectFilter = this.d_constraintFilter != null ? this.d_constraintFilter : GeomPicker.ACCEPT_ALL;
            IIsectFilter iIsectFilter2 = this.d_constraintFilter != null && this.d_snapInfo.v2 != null ? new CompositeIsectFilter(this.d_constraintFilter, (IIsectFilter)this.d_snapInfo.v2) : (IIsectFilter)this.d_snapInfo.v2;
            switch ((SnapMode)((Object)this.d_snapInfo.v1)) {
                case ANY: {
                    snapResult.searchedInfos = this.d_snapper.pick(this.d_progress, GeomPicker.Mode.SNAP, this.d_viewScr, 10.0, iIsectFilter);
                    snapResult.snappedInfos = snapResult.searchedInfos;
                    break;
                }
                case FILTERED_ONE_PASS: {
                    assert (this.d_snapInfo.v2 != null);
                    snapResult.searchedInfos = this.d_snapper.pick(this.d_progress, GeomPicker.Mode.SNAP, this.d_viewScr, 10.0, iIsectFilter2);
                    break;
                }
                case FILTERED_TWO_PASS: {
                    snapResult.snappedInfos = this.d_snapper.pick(this.d_progress, GeomPicker.Mode.SNAP, this.d_viewScr, 10.0, iIsectFilter);
                    if (snapResult.snappedInfos.isEmpty()) break;
                    assert (this.d_snapInfo.v2 != null);
                    IsectInfo isectInfo = snapResult.snappedInfos.iterator().next();
                    Point3d point3d = this.d_view.worldToScreen(isectInfo.isectPoint);
                    Point2d point2d = new Point2d(point3d.x, point3d.y);
                    snapResult.searchedInfos = this.d_snapper.pick(this.d_progress, GeomPicker.Mode.SNAP, point2d, 0.5, iIsectFilter2);
                }
            }
            return snapResult;
        }
    }

    protected static class SnapResult {
        public Collection<IsectInfo> snappedInfos = Collections.EMPTY_LIST;
        public Collection<IsectInfo> searchedInfos = Collections.EMPTY_LIST;

        protected SnapResult() {
        }
    }

    protected static class ConstraintException
    extends Exception {
        protected ConstraintException() {
        }
    }

    public static class Ray {
        public final Point3d begin;
        public final Vector3d dir;

        public Ray() {
            this.begin = new Point3d();
            this.dir = new Vector3d();
        }

        public Ray(Point3d point3d, Vector3d vector3d) {
            this.begin = point3d;
            this.dir = vector3d;
        }
    }
}

