/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.vecmath.Point2d;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolFunction;

public class CompositeFunc<T extends CursorTool>
extends AToolFunction<T> {
    public static final int NULL_EVENT_MOVE = 0;
    public static final int NULL_EVENT_GESTURE = 1;
    public static final int NULL_EVENT_CLICK = 2;
    public static final int ALT_EVENT_MOVE = 3;
    public static final int ALT_EVENT_GESTURE = 4;
    public static final int ALT_EVENT_CLICK = 5;
    public static final int SHIFT_EVENT_MOVE = 6;
    public static final int SHIFT_EVENT_GESTURE = 7;
    public static final int SHIFT_EVENT_CLICK = 8;
    private final IToolFunction d_defaultTool;
    private final Map<Integer, IToolFunction> d_eventToolMap = new LinkedHashMap<Integer, IToolFunction>();
    private IToolFunction d_currentTool;

    public CompositeFunc() {
        this.d_defaultTool = new DefaultTool();
        this.d_currentTool = this.d_defaultTool;
    }

    @Override
    public void cancel(T t) {
        ArrayList<IToolFunction> arrayList = new ArrayList<IToolFunction>();
        for (IToolFunction iToolFunction : this.d_eventToolMap.values()) {
            if (arrayList.contains(iToolFunction)) continue;
            iToolFunction.cancel(t);
            arrayList.add(iToolFunction);
        }
    }

    public IToolFunction getCurrentFunc() {
        return this.d_currentTool;
    }

    @Override
    public void activate(T t) {
        this.setToMove((CursorTool)t, 0);
    }

    public void setEventTool(int n, IToolFunction iToolFunction) {
        if (iToolFunction == null) {
            iToolFunction = this.d_defaultTool;
        }
        this.d_eventToolMap.put(n, iToolFunction);
    }

    public void setToolEvents(IToolFunction iToolFunction, int ... nArray) {
        for (int n : nArray) {
            this.setEventTool(n, iToolFunction);
        }
    }

    @Override
    public boolean showDragGuides(T t) {
        return this.d_currentTool.showDragGuides(t);
    }

    @Override
    public boolean isDrawable(T t) {
        IToolFunction iToolFunction = this.d_currentTool;
        return iToolFunction != null ? iToolFunction.isDrawable(t) : false;
    }

    @Override
    public boolean isAltMenuAccessEnabled() {
        return this.d_eventToolMap.get(5) == null && this.d_eventToolMap.get(4) == null && this.d_eventToolMap.get(3) == null;
    }

    @Override
    public Cursor getCursor(T t) {
        return this.d_currentTool.getCursor(t);
    }

    private boolean shiftPressed(int n) {
        return (n & 0x40) == 64;
    }

    private boolean altPressed(int n) {
        return (n & 0x200) == 512;
    }

    private void setToMove(CursorTool cursorTool, int n) {
        IToolFunction iToolFunction = null;
        iToolFunction = this.shiftPressed(n) ? this.d_eventToolMap.get(6) : (this.altPressed(n) ? this.d_eventToolMap.get(3) : this.d_eventToolMap.get(0));
        this.setCurrentTool(cursorTool, iToolFunction);
    }

    private MouseEvent newMouseEvent(CursorTool cursorTool, KeyEvent keyEvent, int n) {
        int n2 = cursorTool.getPressedButtons().isEmpty() ? 0 : cursorTool.getPressedButtons().iterator().next();
        Point2d point2d = cursorTool.getView().viewScreenToWindowScreen(cursorTool.getP1().referenceSnapSc);
        MouseEvent mouseEvent = new MouseEvent(keyEvent.getComponent(), n, keyEvent.getWhen(), keyEvent.getModifiersEx(), (int)point2d.x, (int)point2d.y, 1, false, n2);
        return mouseEvent;
    }

    private void updateKeyEvent(CursorTool cursorTool, KeyEvent keyEvent) {
        if (cursorTool.isDragging()) {
            IToolFunction iToolFunction = null;
            iToolFunction = this.shiftPressed(keyEvent.getModifiersEx()) ? this.d_eventToolMap.get(7) : (this.altPressed(keyEvent.getModifiersEx()) ? this.d_eventToolMap.get(4) : this.d_eventToolMap.get(1));
            if (iToolFunction == this.d_currentTool) {
                return;
            }
            MouseEvent mouseEvent = this.newMouseEvent(cursorTool, keyEvent, 502);
            this.d_currentTool.mouseReleased(cursorTool, mouseEvent);
            this.setCurrentTool(cursorTool, iToolFunction);
            mouseEvent = this.newMouseEvent(cursorTool, keyEvent, 501);
            this.d_currentTool.mousePressed(cursorTool, mouseEvent);
        } else {
            IToolFunction iToolFunction = null;
            iToolFunction = this.shiftPressed(keyEvent.getModifiersEx()) ? this.d_eventToolMap.get(6) : (this.altPressed(keyEvent.getModifiersEx()) ? this.d_eventToolMap.get(3) : this.d_eventToolMap.get(0));
            if (iToolFunction == this.d_currentTool) {
                return;
            }
            this.setCurrentTool(cursorTool, iToolFunction);
            MouseEvent mouseEvent = this.newMouseEvent(cursorTool, keyEvent, 503);
            this.d_currentTool.mouseMoved(cursorTool, mouseEvent);
        }
    }

    @Override
    public void keyPressed(T t, KeyEvent keyEvent) {
        this.updateKeyEvent((CursorTool)t, keyEvent);
    }

    @Override
    public void keyReleased(T t, KeyEvent keyEvent) {
        this.updateKeyEvent((CursorTool)t, keyEvent);
    }

    @Override
    public void mousePressed(T t, MouseEvent mouseEvent) {
        IToolFunction iToolFunction = null;
        iToolFunction = this.shiftPressed(mouseEvent.getModifiersEx()) ? this.d_eventToolMap.get(7) : (this.altPressed(mouseEvent.getModifiersEx()) ? this.d_eventToolMap.get(4) : this.d_eventToolMap.get(1));
        this.setCurrentTool((CursorTool)t, iToolFunction);
        this.d_currentTool.mousePressed(t, mouseEvent);
    }

    @Override
    public void mouseMoved(T t, MouseEvent mouseEvent) {
        this.d_currentTool.mouseMoved(t, mouseEvent);
        this.updateCursor((CursorTool)t);
    }

    @Override
    public void mouseDragged(T t, MouseEvent mouseEvent) {
        this.d_currentTool.mouseDragged(t, mouseEvent);
        this.updateCursor((CursorTool)t);
    }

    @Override
    public void mouseReleased(T t, MouseEvent mouseEvent) {
        this.d_currentTool.mouseReleased(t, mouseEvent);
        if (!((CursorTool)t).dragAboveTolerance(0)) {
            IToolFunction iToolFunction = this.d_currentTool;
            IToolFunction iToolFunction2 = null;
            iToolFunction2 = this.shiftPressed(mouseEvent.getModifiersEx()) ? this.d_eventToolMap.get(8) : (this.altPressed(mouseEvent.getModifiersEx()) ? this.d_eventToolMap.get(5) : this.d_eventToolMap.get(2));
            if (iToolFunction2 != null) {
                this.setCurrentTool((CursorTool)t, iToolFunction2, false);
                iToolFunction2.mousePressed(t, mouseEvent);
                iToolFunction2.mouseReleased(t, mouseEvent);
                this.setCurrentTool((CursorTool)t, iToolFunction);
            }
        }
        this.setToMove((CursorTool)t, mouseEvent.getModifiersEx());
        this.updateCursor((CursorTool)t);
    }

    public void setCurrentTool(CursorTool cursorTool, IToolFunction iToolFunction) {
        this.setCurrentTool(cursorTool, iToolFunction, true);
    }

    public void setCurrentTool(CursorTool cursorTool, IToolFunction iToolFunction, boolean bl) {
        if (iToolFunction == this.d_currentTool) {
            return;
        }
        if (iToolFunction == null) {
            iToolFunction = this.d_defaultTool;
        }
        this.d_currentTool = iToolFunction;
        if (bl) {
            this.updateCursor(cursorTool);
        }
        cursorTool.markNativeDirty();
        cursorTool.repaintSurface();
    }

    private void updateCursor(CursorTool cursorTool) {
        Cursor cursor = this.d_currentTool.getCursor(cursorTool);
        cursorTool.setToolCursor(cursor);
        cursorTool.showToolCursor();
    }

    @Override
    public void mouseEntered(T t, MouseEvent mouseEvent) {
        this.d_currentTool.mouseEntered(t, mouseEvent);
    }

    @Override
    public void mouseExited(T t, MouseEvent mouseEvent) {
        this.d_currentTool.mouseExited(t, mouseEvent);
    }

    private static class DefaultTool<T extends CursorTool>
    extends AToolFunction<T> {
        @Override
        public Cursor getCursor(T t) {
            return null;
        }

        public boolean areGuidesVisible(CursorTool cursorTool) {
            return false;
        }

        @Override
        public boolean isDrawable(T t) {
            return false;
        }

        @Override
        public boolean showDragGuides(T t) {
            return false;
        }

        @Override
        public void mouseDragged(T t, MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(T t, MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(T t, MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(T t, MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(T t, MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(T t, MouseEvent mouseEvent) {
        }
    }
}

