/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.io.nativexfer.INativeStream;
import thunderheadeng.io.nativexfer.NativeManager;
import thunderheadeng.scene3d.nativebuffered.IConcreteRenderSurface;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.nativebuffered.RenderBuffer;
import thunderheadeng.scene3d.nativebuffered.RenderPanel;
import thunderheadeng.scene3d.nativebuffered.Viewport;
import thunderheadeng.scene3d.nativebuffered.VirtualRenderSurface;

public class nb3dUtil {
    public static void registerTypes() {
        NativeManager.registerWriter(Color.class, nb3dUtil::writeFloats);
        NativeManager.registerReader(Color.class, nb3dUtil::readColor);
        NativeManager.registerWriter(Matrix4d.class, nb3dUtil::write);
        NativeManager.registerReader(Matrix4d.class, nb3dUtil::readMatrix);
        NativeManager.registerWriter(Tuple2d.class, nb3dUtil::write);
        NativeManager.registerReader(Point2d.class, nb3dUtil::readP2d);
        NativeManager.registerReader(Vector2d.class, nb3dUtil::readV2d);
        NativeManager.registerWriter(Tuple3d.class, nb3dUtil::write);
        NativeManager.registerReader(Point3d.class, nb3dUtil::readP3d);
        NativeManager.registerReader(Vector3d.class, nb3dUtil::readV3d);
        NativeManager.registerWriter(Tuple4d.class, nb3dUtil::write);
        NativeManager.registerReader(Point4d.class, nb3dUtil::readP4d);
        NativeManager.registerReader(Vector4d.class, nb3dUtil::readV4d);
        NativeManager.registerWriter(Viewport.class, nb3dUtil::write);
        NativeManager.registerReader(Viewport.class, nb3dUtil::readViewport);
        NativeManager.registerWriter(Dimension.class, nb3dUtil::write);
        NativeManager.registerReader(Dimension.class, nb3dUtil::readDimension);
        NativeManager.registerWriter(AABox.class, nb3dUtil::write);
        NativeManager.registerReader(AABox.class, nb3dUtil::readAABox);
    }

    public static void write(INativeStream iNativeStream, Dimension dimension) {
        iNativeStream.writeInt(dimension.width);
        iNativeStream.writeInt(dimension.height);
    }

    public static Dimension readDimension(INativeStream iNativeStream) {
        return new Dimension(iNativeStream.readInt(), iNativeStream.readInt());
    }

    public static void write(INativeStream iNativeStream, AABox aABox) {
        iNativeStream.writeDouble(aABox.getMinX());
        iNativeStream.writeDouble(aABox.getMinY());
        iNativeStream.writeDouble(aABox.getMinZ());
        iNativeStream.writeDouble(aABox.getMaxX());
        iNativeStream.writeDouble(aABox.getMaxY());
        iNativeStream.writeDouble(aABox.getMaxZ());
    }

    public static AABox readAABox(INativeStream iNativeStream) {
        return new AABox(iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble());
    }

    public static void write(INativeStream iNativeStream, Viewport viewport) {
        iNativeStream.writeInt(viewport.x());
        iNativeStream.writeInt(viewport.y());
        iNativeStream.writeInt(viewport.w());
        iNativeStream.writeInt(viewport.h());
    }

    public static Viewport readViewport(INativeStream iNativeStream) {
        return new Viewport(iNativeStream.readInt(), iNativeStream.readInt(), iNativeStream.readInt(), iNativeStream.readInt());
    }

    public static void write(INativeStream iNativeStream, Matrix4d matrix4d) {
        iNativeStream.writeDoubles(matrix4d.m00, matrix4d.m01, matrix4d.m02, matrix4d.m03, matrix4d.m10, matrix4d.m11, matrix4d.m12, matrix4d.m13, matrix4d.m20, matrix4d.m21, matrix4d.m22, matrix4d.m23, matrix4d.m30, matrix4d.m31, matrix4d.m32, matrix4d.m33);
    }

    public static Matrix4d readMatrix(INativeStream iNativeStream) {
        return new Matrix4d(iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble());
    }

    public static Color readColor(INativeStream iNativeStream) {
        return new Color(iNativeStream.readFloat(), iNativeStream.readFloat(), iNativeStream.readFloat(), iNativeStream.readFloat());
    }

    public static void writeFloats(INativeStream iNativeStream, Color color) {
        nb3dUtil.writeFloats(iNativeStream, color, new float[4]);
    }

    public static void writeFloats(INativeStream iNativeStream, Color color, float[] fArray) {
        color.getComponents(fArray);
        iNativeStream.writeFloats(fArray);
    }

    public static void write(INativeStream iNativeStream, Tuple2d tuple2d) {
        iNativeStream.writeDouble(tuple2d.x);
        iNativeStream.writeDouble(tuple2d.y);
    }

    public static Point2d readP2d(INativeStream iNativeStream) {
        return new Point2d(iNativeStream.readDouble(), iNativeStream.readDouble());
    }

    public static Vector2d readV2d(INativeStream iNativeStream) {
        return new Vector2d(iNativeStream.readDouble(), iNativeStream.readDouble());
    }

    public static void write(INativeStream iNativeStream, Tuple3d tuple3d) {
        iNativeStream.writeDouble(tuple3d.x);
        iNativeStream.writeDouble(tuple3d.y);
        iNativeStream.writeDouble(tuple3d.z);
    }

    public static Point3d readP3d(INativeStream iNativeStream) {
        return new Point3d(iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble());
    }

    public static Vector3d readV3d(INativeStream iNativeStream) {
        return new Vector3d(iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble());
    }

    public static void write(INativeStream iNativeStream, Tuple4d tuple4d) {
        iNativeStream.writeDouble(tuple4d.x);
        iNativeStream.writeDouble(tuple4d.y);
        iNativeStream.writeDouble(tuple4d.z);
        iNativeStream.writeDouble(tuple4d.w);
    }

    public static Point4d readP4d(INativeStream iNativeStream) {
        return new Point4d(iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble());
    }

    public static Vector4d readV4d(INativeStream iNativeStream) {
        return new Vector4d(iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble(), iNativeStream.readDouble());
    }

    public static boolean takeScreenshot(String string, int n, int n2, Color color, IConcreteRenderSurface iConcreteRenderSurface, List<? extends RenderPanel> list, List<Rectangle> list2) throws IOException {
        int n3;
        if (list.size() != list2.size()) {
            return false;
        }
        int n4 = string.lastIndexOf(46);
        if (n4 == -1) {
            return false;
        }
        String string2 = string.substring(n4 + 1);
        Rectangle rectangle = new Rectangle();
        for (n3 = 0; n3 < list.size(); ++n3) {
            Rectangle rectangle2 = list2.get(n3);
            rectangle.add(rectangle2);
        }
        n3 = n * 3;
        int n5 = n3 * n2;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n5).order(ByteOrder.nativeOrder());
        if (color != null) {
            for (int i = 0; i < n5; i += 3) {
                byteBuffer.put((byte)color.getRed());
                byteBuffer.put((byte)color.getGreen());
                byteBuffer.put((byte)color.getBlue());
            }
            byteBuffer.position(0);
        }
        RenderBuffer renderBuffer = new RenderBuffer(iConcreteRenderSurface);
        for (int i = 0; i < list.size(); ++i) {
            RenderPanel renderPanel = list.get(i);
            Rectangle rectangle3 = list2.get(i);
            double d = rectangle3.getWidth() / rectangle.getWidth() * (double)n;
            double d2 = rectangle3.getHeight() / rectangle.getHeight() * (double)n2;
            double d3 = rectangle3.getMinX() / rectangle.getWidth() * (double)n;
            double d4 = (rectangle.getHeight() - rectangle3.getMaxY()) / rectangle.getHeight() * (double)n2;
            renderBuffer.setRootPanel(renderPanel);
            renderBuffer.setSize((int)d, (int)d2);
            byteBuffer.position((int)d4 * n3 + (int)d3 * 3);
            renderBuffer.setBuffer(byteBuffer.slice(), n3);
            renderBuffer.render();
        }
        byteBuffer.position(0);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n6 = byteBuffer.get() & 0xFF;
                int n7 = byteBuffer.get() & 0xFF;
                int n8 = byteBuffer.get() & 0xFF;
                int n9 = 0xFF000000 | n6 << 16 | n7 << 8 | n8;
                bufferedImage.setRGB(j, n2 - i - 1, n9);
            }
        }
        ImageIO.write((RenderedImage)bufferedImage, string2, new File(string));
        return true;
    }

    public static IConcreteRenderSurface findRenderSurface(Collection<? extends IRenderSurface> collection) {
        for (IRenderSurface iRenderSurface : collection) {
            IConcreteRenderSurface iConcreteRenderSurface;
            if (iRenderSurface instanceof IConcreteRenderSurface) {
                return (IConcreteRenderSurface)iRenderSurface;
            }
            if (!(iRenderSurface instanceof VirtualRenderSurface) || (iConcreteRenderSurface = ((VirtualRenderSurface)iRenderSurface).getBackingSurface()) == null) continue;
            return iConcreteRenderSurface;
        }
        return null;
    }
}

