/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Point;
import java.util.function.Supplier;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Box3d;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.IConcreteRenderSurface;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.nativebuffered.Scene;

public class View {
    private final Supplier<Camera> d_scene;
    private final IRenderSurface d_surface;

    public View(IRenderSurface iRenderSurface, Scene scene) {
        this(iRenderSurface, () -> scene.getCamera());
    }

    public View(IRenderSurface iRenderSurface, Supplier<Camera> supplier) {
        this.d_scene = supplier;
        this.d_surface = iRenderSurface;
    }

    public Camera getCamera() {
        return this.d_scene.get();
    }

    public IRenderSurface getSurface() {
        return this.d_surface;
    }

    public void zoomAboutPoint(double d, Point2d point2d) {
        Point3d point3d = this.screenToCamera(new Point3d(point2d.x, point2d.y, 0.0));
        Point2d point2d2 = new Point2d(point3d.x, point3d.y);
        this.updateLayout();
        this.getCamera().zoomAboutPoint(d, point2d2);
    }

    public void zoom(double d, Point2d point2d) {
        Point3d point3d = this.screenToCamera(new Point3d(point2d.x, point2d.y, 0.0));
        Point2d point2d2 = new Point2d(point3d.x, point3d.y);
        this.updateLayout();
        this.getCamera().zoom(d, point2d2);
    }

    public void zoom(double d) {
        double d2 = this.getSurface().getWidth();
        double d3 = this.getSurface().getHeight();
        this.updateLayout();
        this.zoom(d, new Point2d(d2 * 0.5, d3 * 0.5));
    }

    public double calcScreenZValue(double d) {
        this.updateLayout();
        return this.d_scene.get().calcScreenZValue(d);
    }

    public Point3d constrainPointToView(Point3d point3d, Point3d point3d2) {
        this.updateLayout();
        return this.d_scene.get().constrainPointToView(point3d, point3d2);
    }

    public Point3d worldToView(Point3d point3d) {
        this.updateLayout();
        return this.d_scene.get().worldToView(point3d);
    }

    public Point4d worldToView(Point4d point4d) {
        this.updateLayout();
        return this.d_scene.get().worldToView(point4d);
    }

    public Point3d viewToWorld(Point3d point3d) {
        this.updateLayout();
        return this.d_scene.get().viewToWorld(point3d);
    }

    public Point4d viewToWorld(Point4d point4d) {
        this.updateLayout();
        return this.d_scene.get().viewToWorld(point4d);
    }

    public Point3d worldToLocal(Point3d point3d) {
        this.updateLayout();
        return this.d_scene.get().worldToLocal(point3d);
    }

    public Point3d worldToScreen(Point3d point3d) {
        this.updateLayout();
        return this.d_scene.get().worldToScreen(point3d);
    }

    public Point3d worldToScreen(Point4d point4d) {
        this.updateLayout();
        return this.d_scene.get().worldToScreen(point4d);
    }

    public Point3d screenToWorld(Point3d point3d) {
        this.updateLayout();
        return this.d_scene.get().screenToWorld(point3d);
    }

    public Point3d screenToWorld(Point2d point2d, double d) {
        return this.screenToWorld(new Point3d(point2d.x, point2d.y, d));
    }

    public double screenToWorld(double d, Point3d point3d) {
        this.updateLayout();
        return this.d_scene.get().screenToWorld(d, point3d);
    }

    public Point3d viewToScreen(Point4d point4d) {
        this.updateLayout();
        return this.d_scene.get().viewToScreen(point4d);
    }

    public Point3d viewToScreen(Point3d point3d) {
        this.updateLayout();
        return this.d_scene.get().viewToScreen(point3d);
    }

    public Point3d screenToView(Point3d point3d) {
        this.updateLayout();
        return this.d_scene.get().screenToView(point3d);
    }

    public double screenToView(double d) {
        this.updateLayout();
        return this.d_scene.get().screenToView(d);
    }

    public Point3d screenToWorld(Point2d point2d) {
        double d = this.d_surface instanceof IConcreteRenderSurface ? (double)((IConcreteRenderSurface)this.d_surface).getZValue((int)point2d.x, (int)point2d.y) : 0.0;
        Point3d point3d = new Point3d(point2d.x, point2d.y, d);
        return this.screenToWorld(point3d);
    }

    public double screenToWorld(double d) {
        return this.screenToWorld(d, 0.0);
    }

    public double screenToWorld(double d, double d2) {
        Point3d point3d = this.screenToWorld(new Point3d(d, 0.0, d2));
        Point3d point3d2 = this.screenToWorld(new Point3d(0.0, 0.0, d2));
        return point3d.distance(point3d2);
    }

    public Point3d screenToCamera(Point3d point3d) {
        this.updateLayout();
        return this.d_scene.get().screenToCamera(point3d);
    }

    public Point2d windowScreenToViewScreen(Point point) {
        return this.windowScreenToViewScreen(new Point2d(point.x, point.y));
    }

    public Point2d windowScreenToViewScreen(Point2d point2d) {
        double d = point2d.x;
        double d2 = (double)this.d_surface.getHeight() - point2d.y - 1.0;
        return new Point2d(d, d2);
    }

    public Point2d viewScreenToWindowScreen(Point2d point2d) {
        double d = point2d.x;
        double d2 = (double)this.d_surface.getHeight() - point2d.y - 1.0;
        return new Point2d(d, d2);
    }

    public Box3d toFrustum(Point2d point2d, double d) {
        return (Box3d)this.toFrustum(point2d, d, d, false);
    }

    public ConvexHull toInfiniteFrustum(Point2d point2d, double d) {
        return (ConvexHull)this.toFrustum(point2d, d, d, true);
    }

    public Box3d toFrustum(Point2d point2d, Point2d point2d2) {
        Point2d point2d3 = new Point2d((point2d.x + point2d2.x) * 0.5, (point2d.y + point2d2.y) * 0.5);
        double d = Math.abs(point2d3.x - point2d.x);
        double d2 = Math.abs(point2d3.y - point2d.y);
        return (Box3d)this.toFrustum(point2d3, d, d2, false);
    }

    public ConvexHull toInfiniteFrustum(Point2d point2d, Point2d point2d2) {
        Point2d point2d3 = new Point2d((point2d.x + point2d2.x) * 0.5, (point2d.y + point2d2.y) * 0.5);
        double d = Math.abs(point2d3.x - point2d.x);
        double d2 = Math.abs(point2d3.y - point2d.y);
        return (ConvexHull)this.toFrustum(point2d3, d, d2, true);
    }

    private ITest<AABox> toFrustum(Point2d point2d, double d, double d2, boolean bl) {
        Point3d point3d = new Point3d(point2d.x - d, point2d.y - d2, 0.0);
        Point3d point3d2 = new Point3d(point2d.x + d, point2d.y - d2, 0.0);
        Point3d point3d3 = new Point3d(point2d.x + d, point2d.y + d2, 0.0);
        Point3d point3d4 = new Point3d(point2d.x - d, point2d.y + d2, 0.0);
        Point3d point3d5 = new Point3d(point3d.x, point3d.y, 1.0);
        Point3d point3d6 = new Point3d(point3d2.x, point3d2.y, 1.0);
        Point3d point3d7 = new Point3d(point3d3.x, point3d3.y, 1.0);
        Point3d point3d8 = new Point3d(point3d4.x, point3d4.y, 1.0);
        point3d = this.screenToWorld(point3d);
        point3d2 = this.screenToWorld(point3d2);
        point3d3 = this.screenToWorld(point3d3);
        point3d4 = this.screenToWorld(point3d4);
        point3d5 = this.screenToWorld(point3d5);
        point3d6 = this.screenToWorld(point3d6);
        point3d7 = this.screenToWorld(point3d7);
        point3d8 = this.screenToWorld(point3d8);
        if (!bl) {
            return new Box3d(point3d, point3d2, point3d3, point3d4, point3d5, point3d6, point3d7, point3d8);
        }
        return new ConvexHull(new Plane3d(true, point3d, point3d5, point3d6, point3d2), new Plane3d(true, point3d2, point3d6, point3d7, point3d3), new Plane3d(true, point3d4, point3d3, point3d7, point3d8), new Plane3d(true, point3d4, point3d8, point3d5, point3d));
    }

    public Box3d getFrustum() {
        int n = this.getSurface().getWidth();
        int n2 = this.getSurface().getHeight();
        return this.toFrustum(new Point2d(0.0, 0.0), new Point2d(n, n2));
    }

    public void updateLayout() {
        this.d_surface.updateLayout();
    }

    public Matrix4d getMatrix(int n) {
        this.updateLayout();
        return this.getCamera().getMatrix(n);
    }
}

