/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Component;
import java.util.function.Function;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.io.nativexfer.ABufferedNativeStream;
import thunderheadeng.io.nativexfer.ANativeObject;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.io.nativexfer.NativeManager;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.RProp;
import thunderheadeng.util.RWProp;
import thunderheadeng.util.Win32Native;
import thunderheadeng.video.IVideoCompressor;

public class VideoCompressor
extends ANativeObject
implements IVideoCompressor {
    private static final Unit DATARATE_UNIT = SI.BIT.divide(SI.SECOND);
    private static final Unit QUALITY_UNIT = Unit.ONE;

    protected VideoCompressor(Integer n, long l) {
        super(n, l);
    }

    @Override
    public Class resolveNativeClass() {
        return VideoCompressor.class;
    }

    private <T> T exec(Methods methods, Function<NativeManager, T> function, Object ... objectArray) {
        return Native.manager.exec(VideoCompressor.class, (INativeObject)this, (Enum)methods, function, objectArray);
    }

    private void exec(Methods methods, Object ... objectArray) {
        Native.manager.execMethod(VideoCompressor.class, (INativeObject)this, methods, objectArray);
    }

    @Override
    public boolean hasPropsDlg(Component component) {
        long l = Win32Native.findHwnd(component);
        if (l == 0L) {
            return false;
        }
        return this.exec(Methods.hasPropsDlg, ABufferedNativeStream::readBoolean, l);
    }

    @Override
    public void showPropsDlg(Component component) {
        long l = Win32Native.findHwnd(component);
        if (l == 0L) {
            return;
        }
        this.exec(Methods.showPropsDlg, l);
    }

    @Override
    public boolean hasAboutDlg(Component component) {
        long l = Win32Native.findHwnd(component);
        if (l == 0L) {
            return false;
        }
        return this.exec(Methods.hasAboutDlg, ABufferedNativeStream::readBoolean, l);
    }

    @Override
    public void showAboutDlg(Component component) {
        long l = Win32Native.findHwnd(component);
        if (l == 0L) {
            return;
        }
        this.exec(Methods.showAboutDlg, l);
    }

    @Override
    public <T> T get(RProp<T> rProp) {
        if (rProp == DATARATE) {
            Integer n = this.exec(Methods.get, ABufferedNativeStream::readInt, (Integer)rProp.key);
            return (T)new UnitDouble(n.intValue(), DATARATE_UNIT);
        }
        if (rProp == QUALITY) {
            Double d = this.exec(Methods.get, ABufferedNativeStream::readDouble, (Integer)rProp.key);
            return (T)new UnitDouble(d, QUALITY_UNIT);
        }
        return (T)this.exec(Methods.get, (NativeManager nativeManager) -> nativeManager.read(rProp.type), (Integer)rProp.key);
    }

    @Override
    public <T> void set(RWProp<T> rWProp, T t) {
        Object object = rWProp == DATARATE ? (Number)((int)((UnitDouble)t).get(DATARATE_UNIT)) : (Number)(rWProp == QUALITY ? Double.valueOf(((UnitDouble)t).get(QUALITY_UNIT)) : t);
        this.exec(Methods.set, (Integer)rWProp.key, object);
    }

    @Override
    public <T> T getDefault(RWProp<T> rWProp) {
        if (rWProp == DATARATE) {
            Integer n = this.exec(Methods.getDefault, ABufferedNativeStream::readInt, (Integer)rWProp.key);
            return (T)new UnitDouble(n.intValue(), DATARATE_UNIT);
        }
        if (rWProp == QUALITY) {
            Double d = this.exec(Methods.getDefault, ABufferedNativeStream::readDouble, (Integer)rWProp.key);
            return (T)new UnitDouble(d, QUALITY_UNIT);
        }
        return (T)this.exec(Methods.getDefault, (NativeManager nativeManager) -> nativeManager.read(rWProp.type), (Integer)rWProp.key);
    }

    @Override
    public <T> boolean isSupported(RWProp<T> rWProp) {
        return this.exec(Methods.isSupported, ABufferedNativeStream::readBoolean, (Integer)rWProp.key);
    }

    private static enum Methods {
        get,
        set,
        isSupported,
        getDefault,
        hasPropsDlg,
        showPropsDlg,
        hasAboutDlg,
        showAboutDlg;

    }
}

