/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.function.Function;
import javax.vecmath.Matrix4d;
import thunderheadeng.gui.Application;
import thunderheadeng.io.nativexfer.ABufferedNativeStream;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.io.nativexfer.NativeManager;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.nativebuffered.IRenderable;
import thunderheadeng.scene3d.nativebuffered.Object3D;
import thunderheadeng.scene3d.nativebuffered.nb3dUtil;

public class TextRenderer
extends Object3D
implements IRenderable {
    public static final int MODE_2D = 0;
    public static final int MODE_3D = 1;
    public static final int RENDERTYPE_PIXMAP = 0;
    public static final int RENDERTYPE_TEXTURE = 1;
    public static final int RENDERTYPE_BITMAP = 2;
    private static final String DEFAULT_FACE_NAME = "kochi-gothic-subst.ttf";

    public static String getDefaultFont() {
        File file = new File(Application.getApp().getResourceFile(DEFAULT_FACE_NAME));
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        URL uRL = TextRenderer.class.getResource("lib/kochi-gothic-subst.ttf");
        if (uRL == null) {
            return "lib/kochi-gothic-subst.ttf";
        }
        String string = uRL.getFile();
        File file2 = null;
        try {
            file2 = new File(URLDecoder.decode(string, "UTF-8"));
            return file2.getPath();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return "lib/kochi-gothic-subst.ttf";
        }
    }

    public TextRenderer() {
        this.setFace(TextRenderer.getDefaultFont());
        this.setFontColor(Color.BLACK);
        this.setFontSize(12.0f);
        this.setPadding(new int[]{0, 0, 0, 0});
        this.setLeaderEnabled(false);
        this.setMode(0);
        this.setRenderType(1);
    }

    protected TextRenderer(Integer n, long l) {
        super(n, l);
    }

    @Override
    public Class resolveNativeClass() {
        return TextRenderer.class;
    }

    private void exec(Methods methods, Object ... objectArray) {
        Native.manager.execMethod(TextRenderer.class, (INativeObject)this, methods, objectArray);
    }

    private <T> T exec(Methods methods, Class<T> clazz, Object ... objectArray) {
        return Native.manager.execGet(TextRenderer.class, (INativeObject)this, methods, clazz, objectArray);
    }

    private <T> T exec(Methods methods, Function<NativeManager, T> function, Object ... objectArray) {
        return Native.manager.exec(TextRenderer.class, (INativeObject)this, (Enum)methods, function, objectArray);
    }

    public void setGraphicsContext(IRenderSurface iRenderSurface) {
        this.exec(Methods.setRenderSurface, iRenderSurface);
    }

    public void setMode(int n) {
        this.exec(Methods.setMode, n);
    }

    public int getMode(int n) {
        return this.exec(Methods.getMode, ABufferedNativeStream::readInt, new Object[0]);
    }

    public void setRenderType(int n) {
        this.exec(Methods.setRenderType, n);
    }

    public int getRenderType() {
        return this.exec(Methods.getRenderType, ABufferedNativeStream::readInt, new Object[0]);
    }

    public void setTransform(Matrix4d matrix4d) {
        Object[] objectArray;
        if (matrix4d == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = false;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = true;
            objectArray = objectArray3;
            objectArray3[1] = matrix4d;
        }
        Object[] objectArray4 = objectArray;
        this.exec(Methods.setTransform, objectArray4);
    }

    public void setLeaderEnabled(boolean bl) {
        this.exec(Methods.setLeaderEnabled, bl);
    }

    public boolean isLeaderEnabled() {
        return this.exec(Methods.isLeaderEnabled, ABufferedNativeStream::readBoolean, new Object[0]);
    }

    public void setFace(String string) {
        this.exec(Methods.setFace, string);
    }

    public void setFontColor(Color color) {
        this.exec(Methods.setFontColor, color);
    }

    public void setFontSize(float f) {
        this.exec(Methods.setFontSize, Float.valueOf(f));
    }

    public void setCamera(Camera camera) {
        this.exec(Methods.setCamera, camera);
    }

    public void setPadding(int[] nArray) {
        this.exec(Methods.setPadding, new Object[]{nArray});
    }

    static {
        nb3dUtil.registerTypes();
    }

    private static enum Methods {
        setRenderSurface,
        setCamera,
        setFace,
        setFontColor,
        setFontSize,
        setLeaderEnabled,
        isLeaderEnabled,
        setMode,
        getMode,
        setPadding,
        setRenderType,
        getRenderType,
        setTransform;

    }
}

