/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.BoundsCalculator;
import thunderheadeng.scene3d.nativebuffered.IRenderable;
import thunderheadeng.scene3d.nativebuffered.Object3D;
import thunderheadeng.scene3d.nativebuffered.TextRenderer;

public class StringRenderer
extends Object3D
implements IRenderable {
    private static final int method_setRenderer = 0;
    private static final int method_setString = 1;
    private static final int method_setLocation = 2;
    private static final int method_getBounds = 3;
    private static final int method_setColor = 4;
    private static final int method_setOffset = 5;
    private static final int method_setJustification = 6;

    public StringRenderer() {
    }

    protected StringRenderer(Integer n, long l) {
        super(n, l);
    }

    @Override
    public Class resolveNativeClass() {
        return StringRenderer.class;
    }

    public AABox getBounds(boolean bl) {
        return this.getBounds(new BoundsCalculator(), bl).getBounds();
    }

    public BoundsCalculator getBounds(BoundsCalculator boundsCalculator, boolean bl) {
        Native.manager.execMethod(StringRenderer.class, (INativeObject)this, 3, boundsCalculator, bl);
        return boundsCalculator;
    }

    public void setColor(Color color) {
        if (color == null) {
            Native.manager.execMethod(StringRenderer.class, (INativeObject)this, 4, false);
        } else {
            Native.manager.execMethod(StringRenderer.class, (INativeObject)this, 4, true, (byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)color.getAlpha());
        }
    }

    public void setRenderer(TextRenderer textRenderer) {
        Native.manager.execMethod(StringRenderer.class, (INativeObject)this, 0, textRenderer);
    }

    public void setLocation(Point3d point3d, Object3D object3D) {
        Native.manager.execMethod(StringRenderer.class, (INativeObject)this, 2, point3d.x, point3d.y, point3d.z, object3D);
    }

    public void setOffset(Offset offset) {
        Native.manager.execMethod(StringRenderer.class, (INativeObject)this, 5, offset.ordinal());
    }

    public void setString(String string) {
        Native.manager.execMethod(StringRenderer.class, (INativeObject)this, 1, string);
    }

    public void setJustification(Justification justification) {
        Native.manager.execMethod(StringRenderer.class, (INativeObject)this, 6, justification.ordinal());
    }

    public static enum Justification {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum Offset {
        MIN,
        MAX,
        CENTER;

    }
}

