/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.lang.reflect.Array;
import java.util.Observable;
import java.util.Observer;
import thunderheadeng.io.nativexfer.ABufferedNativeStream;
import thunderheadeng.io.nativexfer.ANativeObject;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.ISceneRenderOptions;
import thunderheadeng.util.IPropertySet;

public final class SceneRenderOptions
extends ANativeObject
implements ISceneRenderOptions {
    private ObservableHelper d_observableHelper = new ObservableHelper();

    public SceneRenderOptions() {
    }

    protected SceneRenderOptions(Integer n, long l) {
        super(n, l);
    }

    @Override
    public Class resolveNativeClass() {
        return SceneRenderOptions.class;
    }

    public void addObserver(Observer observer) {
        this.d_observableHelper.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.d_observableHelper.deleteObserver(observer);
    }

    public void deleteObservers() {
        this.d_observableHelper.deleteObservers();
    }

    @Override
    public SceneRenderOptions clone() {
        SceneRenderOptions sceneRenderOptions = (SceneRenderOptions)super.clone();
        sceneRenderOptions.d_observableHelper = new ObservableHelper();
        for (IPropertySet.Prop prop : ALL_PROPS) {
            sceneRenderOptions.set(prop, this.get(prop));
        }
        return sceneRenderOptions;
    }

    protected void markDirty(IPropertySet.Prop<?> prop) {
        this.d_observableHelper.setChanged();
        this.d_observableHelper.notifyObservers(prop);
    }

    private static Integer key(IPropertySet.Prop<?> prop) {
        return (Integer)prop.key;
    }

    @Override
    public <T> T get(IPropertySet.Prop<T> prop) {
        if (prop.defVal.getClass().isArray()) {
            int n = Array.getLength(prop.defVal);
            return (T)Native.manager.exec(SceneRenderOptions.class, (INativeObject)this, (Enum)Methods.getProp, nativeManager -> nativeManager.readArray(prop.defVal.getClass(), n), SceneRenderOptions.key(prop));
        }
        return (T)Native.manager.execGet(SceneRenderOptions.class, (INativeObject)this, Methods.getProp, prop.defVal.getClass(), SceneRenderOptions.key(prop));
    }

    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T t) {
        assert (t != null);
        Native.manager.execMethod(SceneRenderOptions.class, (INativeObject)this, Methods.setProp, SceneRenderOptions.key(prop), t);
        this.markDirty(prop);
    }

    @Override
    public <T> void remove(IPropertySet.Prop<T> prop) {
        Native.manager.execMethod(SceneRenderOptions.class, (INativeObject)this, Methods.removeProp, SceneRenderOptions.key(prop));
        this.markDirty(prop);
    }

    @Override
    public <T> boolean isDefined(IPropertySet.Prop<T> prop) {
        return Native.manager.exec(SceneRenderOptions.class, (INativeObject)this, (Enum)Methods.isDefined, ABufferedNativeStream::readBoolean, SceneRenderOptions.key(prop));
    }

    public void merge(SceneRenderOptions sceneRenderOptions) {
        this.merge((IPropertySet)sceneRenderOptions, ALL_PROPS.stream());
    }

    public void setDepthTestEnabled(boolean bl) {
        this.set(DEPTHTEST_ENABLED, bl);
    }

    public boolean isDepthTestEnabled() {
        return (Boolean)this.get(DEPTHTEST_ENABLED);
    }

    public void setPolygonOffset(float f, float f2) {
        this.set(SOLID_POLYGON_OFFSET, new float[]{f, f2});
    }

    public float[] getPolygonOffset() {
        return (float[])this.get(SOLID_POLYGON_OFFSET);
    }

    public void setLightingEnabled(boolean bl) {
        this.set(LIGHTING_ENABLED, bl);
    }

    public boolean isLightingEnabled() {
        return (Boolean)this.get(LIGHTING_ENABLED);
    }

    public void setSmoothLightingEnabled(boolean bl) {
        this.set(SMOOTH_LIGHTING, bl);
    }

    public boolean useSmoothLighting() {
        return (Boolean)this.get(SMOOTH_LIGHTING);
    }

    public void setDrawOutlines(boolean bl) {
        this.set(DRAW_OUTLINES, bl);
    }

    public boolean drawOutlines() {
        return (Boolean)this.get(DRAW_OUTLINES);
    }

    public void setShowTextures(boolean bl) {
        this.set(DRAW_TEXTURES, bl);
    }

    public boolean showTextures() {
        return (Boolean)this.get(DRAW_TEXTURES);
    }

    public void setShowMaterials(boolean bl) {
        this.set(DRAW_MATERIALS, bl);
    }

    public boolean showMaterials() {
        return (Boolean)this.get(DRAW_MATERIALS);
    }

    public void setDrawWireframe(boolean bl) {
        this.set(DRAW_WIREFRAME, bl);
    }

    public boolean drawWireframe() {
        return (Boolean)this.get(DRAW_WIREFRAME);
    }

    public boolean drawSelectedFaceOutlines() {
        return (Boolean)this.get(DRAW_SELECTED_FACES_OUTLINE);
    }

    public void setDrawSelectedFaceOutlines(boolean bl) {
        this.set(DRAW_SELECTED_FACES_OUTLINE, bl);
    }

    public boolean getAutoClip() {
        return (Boolean)this.get(AUTO_CLIP);
    }

    public void setAutoClip(boolean bl) {
        this.set(AUTO_CLIP, bl);
    }

    private static class ObservableHelper
    extends Observable {
        private ObservableHelper() {
        }

        @Override
        public void setChanged() {
            super.setChanged();
        }
    }

    private static enum Methods {
        setProp,
        getProp,
        removeProp,
        isDefined;

    }
}

