/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.io.Serializable;
import java.util.function.Function;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.io.nativexfer.ABufferedNativeStream;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.util.theUtil;

public class PerspectiveCamera
extends Camera {
    private static final double s_maxFOVRad = 2.9845130209103035;
    private static final double s_minFarClip = 10000.0;
    private static final double s_maxNearClip = 0.1;
    private double d_resetFovRad;

    private PerspectiveCamera() {
    }

    public PerspectiveCamera(Point3d point3d, Point3d point3d2, Vector3d vector3d, double d, double d2, double d3) {
        super(point3d, point3d2, vector3d, d, d2);
        this.d_resetFovRad = Math.toRadians(d3);
        this.setFOV(this.d_resetFovRad);
    }

    protected PerspectiveCamera(Integer n, long l) {
        super(n, l);
    }

    @Override
    public Class resolveNativeClass() {
        return PerspectiveCamera.class;
    }

    @Override
    public Camera createCopyCam() {
        PerspectiveCamera perspectiveCamera = new PerspectiveCamera();
        perspectiveCamera.setCopyCam(this);
        return perspectiveCamera;
    }

    public void setFOV(double d) {
        this.d_resetFovRad = d;
        Native.manager.execMethod(PerspectiveCamera.class, (INativeObject)this, Methods.setFOV, d);
    }

    public double getFOV() {
        return Native.manager.exec(PerspectiveCamera.class, (INativeObject)this, (Enum)Methods.getFOV, ABufferedNativeStream::readDouble, new Object[0]);
    }

    protected double getMinZoom() {
        return 0.25;
    }

    @Override
    protected Point3d constrainPointToView(Point3d point3d, Point3d point3d2) {
        Point3d point3d3 = this.worldToView(point3d);
        Point3d point3d4 = this.worldToView(point3d2);
        point3d4.z = point3d3.z;
        return this.viewToWorld(point3d4);
    }

    @Override
    protected double calcScreenZValue(double d) {
        double d2 = d - this.getNearClip();
        double d3 = 1.0 / (this.getFarClip() - this.getNearClip());
        double d4 = -(this.getFarClip() + this.getNearClip()) * d3;
        double d5 = -2.0 * this.getNearClip() * this.getFarClip() * d3;
        double d6 = -d4 - d5 / -d2;
        return d6 * 0.5 + 0.5;
    }

    @Override
    public AABox ensureValidForReset(AABox aABox, double d) {
        return aABox.ensureValidSize(d, 1.0E-6);
    }

    @Override
    public double getSubjectSize() {
        return this.getFOV() * this.getDistance();
    }

    @Override
    protected void reset(Vector3d vector3d, Vector3d vector3d2, AABox aABox, int n, int n2, boolean bl) {
        super.reset(vector3d, vector3d2, aABox, n, n2, bl);
        assert (Math.abs(vector3d.angle(vector3d2) - 1.5707963267948966) <= 1.0E-4);
        this.setFOV(this.d_resetFovRad);
        double d = aABox.getMin().distance(aABox.getMax());
        double d2 = d * 0.5;
        Point3d point3d = new Point3d();
        point3d.add(aABox.getMin(), aABox.getMax());
        point3d.scale(0.5);
        double d3 = d2 / Math.sin(this.getFOV() * 0.5);
        Vector3d vector3d3 = new Vector3d(vector3d);
        vector3d3.normalize();
        vector3d3.scale(d3);
        Point3d point3d2 = new Point3d();
        point3d2.sub(point3d, vector3d3);
        this.setPosition(point3d2);
        this.setReference(point3d);
        this.setUpVector(vector3d2);
        this.fitClipping(aABox);
        this.markDirty();
    }

    @Override
    public Vector3d getViewVector(Point3d point3d) {
        Vector3d vector3d = new Vector3d();
        vector3d.sub(point3d, this.getPosition());
        return vector3d;
    }

    @Override
    public Function<Point3d, Vector3d> getViewVectorFunction() {
        Point3d point3d = this.getPosition();
        return point3d2 -> Util3D.vector(point3d, point3d2);
    }

    @Override
    public CameraRecord capture() {
        return new CameraRecord(this.getPosition(), this.getReference(), this.getUpVector(), this.getZoom(), this.getZoomLoc(), this.getNearClip(), this.getFarClip(), new FrustumRecord(this.getFOV()));
    }

    @Override
    public void apply(CameraRecord cameraRecord) {
        super.apply(cameraRecord);
        if (cameraRecord.frustum instanceof FrustumRecord) {
            this.setFOV(((FrustumRecord)cameraRecord.frustum).fov);
        }
    }

    public static class FrustumRecord
    implements CameraRecord.IFrustumRecord,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final double fov;

        public FrustumRecord(double d) {
            this.fov = d;
        }

        @Override
        public boolean equals(Object object) {
            return object == this || object instanceof FrustumRecord && ((FrustumRecord)object).fov == this.fov;
        }

        @Override
        public boolean tolEquals(CameraRecord.IFrustumRecord iFrustumRecord, double d) {
            return iFrustumRecord == this || iFrustumRecord instanceof FrustumRecord && theUtil.eq(this.fov, ((FrustumRecord)iFrustumRecord).fov, d);
        }

        @Override
        public CameraRecord.IFrustumRecord slerp(CameraRecord.IFrustumRecord iFrustumRecord, double d) {
            if (!(iFrustumRecord instanceof FrustumRecord)) {
                return this;
            }
            FrustumRecord frustumRecord = (FrustumRecord)iFrustumRecord;
            return new FrustumRecord(theUtil.lerp(this.fov, frustumRecord.fov, d));
        }
    }

    private static enum Methods {
        setFOV,
        getFOV;

    }
}

