/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.io.Serializable;
import java.util.function.Function;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.io.nativexfer.ABufferedNativeStream;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.util.theUtil;

public class OrthoCamera
extends Camera {
    private OrthoCamera() {
    }

    public OrthoCamera(Point3d point3d, Point3d point3d2, Vector3d vector3d, double d, double d2, double d3) {
        super(point3d, point3d2, vector3d, d, d2);
        this.setWorldHeight(d3);
    }

    protected OrthoCamera(Integer n, long l) {
        super(n, l);
    }

    @Override
    public Class resolveNativeClass() {
        return OrthoCamera.class;
    }

    @Override
    public Camera createCopyCam() {
        OrthoCamera orthoCamera = new OrthoCamera();
        orthoCamera.setCopyCam(this);
        return orthoCamera;
    }

    public void setWorldHeight(double d) {
        Native.manager.execMethod(OrthoCamera.class, (INativeObject)this, Methods.setHeight, d);
    }

    public double getWorldHeight() {
        return Native.manager.exec(OrthoCamera.class, (INativeObject)this, (Enum)Methods.getHeight, ABufferedNativeStream::readDouble, new Object[0]);
    }

    @Override
    protected Point3d constrainPointToView(Point3d point3d, Point3d point3d2) {
        Point3d point3d3 = this.getPosition();
        Vector3d vector3d = this.getViewVector();
        vector3d.normalize();
        Vector3d vector3d2 = new Vector3d();
        vector3d2.sub(point3d, point3d3);
        double d = vector3d.dot(vector3d2);
        Vector3d vector3d3 = new Vector3d();
        vector3d3.sub(point3d2, point3d3);
        double d2 = vector3d.dot(vector3d3);
        double d3 = d - d2;
        Point3d point3d4 = new Point3d(vector3d);
        point3d4.scale(d3);
        point3d4.add(point3d2);
        return point3d4;
    }

    @Override
    protected double calcScreenZValue(double d) {
        double d2 = 1.0 / (this.getFarClip() - this.getNearClip());
        double d3 = -2.0 * d2;
        double d4 = -(this.getFarClip() - this.getNearClip()) * d2;
        double d5 = d3 * d + d4;
        return d5 * 0.5 + 0.5;
    }

    @Override
    public double getSubjectSize() {
        return this.getWorldHeight();
    }

    @Override
    protected void reset(Vector3d vector3d, Vector3d vector3d2, AABox aABox, int n, int n2, boolean bl) {
        AABox aABox2;
        double d;
        super.reset(vector3d, vector3d2, aABox, n, n2, bl);
        Point3d point3d = aABox.getMin();
        Point3d point3d2 = aABox.getMax();
        Point3d point3d3 = Util3D.getMidPoint(point3d, point3d2);
        Vector3d vector3d3 = Util3D.normalize(vector3d);
        Vector3d vector3d4 = Util3D.vector(point3d, point3d2);
        if (n == 0 || n2 == 0 || bl) {
            d = vector3d4.length() * 1.05;
        } else {
            Plane3d plane3d = new Plane3d(vector3d3, point3d3);
            Matrix4d matrix4d = Util.getWorldToLocalXform(plane3d);
            for (Object object : aABox2 = aABox.getVerts(false)) {
                matrix4d.transform((Point3d)object);
            }
            AABox aABox3 = new AABox((Point3d[])aABox2);
            Vector3d vector3d5 = Util3D.vector(aABox3.getMin(), aABox3.getMax());
            double d2 = vector3d5.y / vector3d5.x;
            double d3 = (double)n2 / (double)n;
            d = d2 >= d3 ? vector3d5.y : vector3d5.x * d3;
            d *= 1.1;
        }
        double d4 = vector3d4.length() * 0.5 * 1.1;
        aABox2 = new Point3d();
        ((Tuple3d)((Object)aABox2)).scale(d4, vector3d3);
        ((Tuple3d)((Object)aABox2)).sub(point3d3, (Tuple3d)((Object)aABox2));
        this.setWorldHeight(d);
        this.setPosition((Point3d)((Object)aABox2));
        this.setUpVector(vector3d2);
        this.setReference(point3d3);
        this.fitClipping(aABox);
        this.markDirty();
    }

    @Override
    public Vector3d getViewVector(Point3d point3d) {
        return this.getViewVector();
    }

    @Override
    public Function<Point3d, Vector3d> getViewVectorFunction() {
        Vector3d vector3d = this.getViewVector();
        return point3d -> vector3d;
    }

    @Override
    public CameraRecord capture() {
        return new CameraRecord(this.getPosition(), this.getReference(), this.getUpVector(), this.getZoom(), this.getZoomLoc(), this.getNearClip(), this.getFarClip(), new FrustumRecord(this.getWorldHeight()));
    }

    @Override
    public void apply(CameraRecord cameraRecord) {
        super.apply(cameraRecord);
        if (cameraRecord.frustum instanceof FrustumRecord) {
            this.setWorldHeight(((FrustumRecord)cameraRecord.frustum).worldHeight);
        }
    }

    public static class FrustumRecord
    implements CameraRecord.IFrustumRecord,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final double worldHeight;

        public FrustumRecord(double d) {
            this.worldHeight = d;
        }

        @Override
        public boolean equals(Object object) {
            return object == this || object instanceof FrustumRecord && ((FrustumRecord)object).worldHeight == this.worldHeight;
        }

        @Override
        public boolean tolEquals(CameraRecord.IFrustumRecord iFrustumRecord, double d) {
            return iFrustumRecord == this || iFrustumRecord instanceof FrustumRecord && theUtil.eq(this.worldHeight, ((FrustumRecord)iFrustumRecord).worldHeight, d);
        }

        @Override
        public CameraRecord.IFrustumRecord slerp(CameraRecord.IFrustumRecord iFrustumRecord, double d) {
            if (!(iFrustumRecord instanceof FrustumRecord)) {
                return this;
            }
            FrustumRecord frustumRecord = (FrustumRecord)iFrustumRecord;
            return new FrustumRecord(theUtil.lerp(this.worldHeight, frustumRecord.worldHeight, d));
        }
    }

    private static enum Methods {
        setHeight,
        getHeight;

    }
}

