/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.io.IOException;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.function.Function;
import thunderheadeng.image.IImage;
import thunderheadeng.io.nativexfer.ANativelyMirrored;
import thunderheadeng.io.nativexfer.INativeStream;
import thunderheadeng.scene3d.GeomWriter;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.scene3d.nativebuffered.NativeGeomWriterOutput;
import thunderheadeng.scene3d.nativebuffered.NativeImage;
import thunderheadeng.scene3d.nativebuffered.NativeImageMgr;
import thunderheadeng.util.ListMap;

public class NativeMaterial
extends ANativelyMirrored {
    private IMatAttrs d_material;
    private Map<IImage, NativeImage> d_nimageMap;

    public NativeMaterial(IMatAttrs iMatAttrs) {
        this.d_material = iMatAttrs;
        this.d_nimageMap = new ListMap<IImage, NativeImage>();
        this.updateNativeImages();
        this.nativeConstructed(NativeMaterial.class);
    }

    protected NativeMaterial(Integer n, long l) {
        super(n, l);
    }

    @Override
    public Class resolveNativeClass() {
        return NativeMaterial.class;
    }

    public IMatAttrs getObject() {
        return this.d_material;
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof NativeMaterial && ((NativeMaterial)object).d_material.equals(this.d_material);
    }

    @Override
    public int hashCode() {
        return 0x33F8FFA ^ this.d_material.hashCode();
    }

    @Override
    public void writeNativeData(INativeStream iNativeStream) {
        block2: {
            NativeGeomWriterOutput nativeGeomWriterOutput = new NativeGeomWriterOutput(iNativeStream){

                @Override
                public void writeObject(Object object) throws IOException {
                    if (object instanceof Texture) {
                        GeomWriter.write((ObjectOutput)this, (Texture)object);
                        return;
                    }
                    if (object instanceof IImage) {
                        object = NativeMaterial.this.d_nimageMap.get(object);
                    }
                    super.writeObject(object);
                }
            };
            try {
                GeomWriter.write((ObjectOutput)nativeGeomWriterOutput, this.d_material);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private void updateNativeImages() {
        this.d_nimageMap.clear();
        Function<IImage, NativeImage> function = iImage -> NativeImageMgr.getImage(iImage);
        for (MatChannel matChannel : MatChannel.values()) {
            Texture texture = this.d_material.getTexture(matChannel);
            if (texture == null || texture.image == null) continue;
            this.d_nimageMap.computeIfAbsent(texture.image, function);
        }
    }

    public void update() {
        this.updateNativeImages();
        this.markNativeDirty();
    }
}

