/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import thunderheadeng.image.IImage;
import thunderheadeng.io.FileSystem;
import thunderheadeng.io.IOUtil;
import thunderheadeng.io.nativexfer.ANativeObject;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.io.streamsrc.DecryptStreamSrc;
import thunderheadeng.io.streamsrc.IFileSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;
import thunderheadeng.util.Pair;

public class NativeImage
extends ANativeObject {
    static final long serialVersionUID = 1L;
    private final IImage d_baseImage;
    private static final int method_setFilename = 1;

    protected NativeImage(final IImage iImage) {
        this.d_baseImage = iImage;
        Native.manager.flush();
        Native.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                NativeImage.this.setData(iImage);
            }
        });
        Native.manager.execMethod(NativeImage.class, (INativeObject)this, 1, iImage.getFilename());
    }

    protected NativeImage(Integer n, long l) {
        super(n, l);
        this.d_baseImage = null;
    }

    @Override
    public Class resolveNativeClass() {
        return NativeImage.class;
    }

    public IImage getBaseImage() {
        return this.d_baseImage;
    }

    protected void setData(IImage iImage) {
        IStreamSrc iStreamSrc = iImage.getSource();
        boolean bl = false;
        if (iStreamSrc instanceof DecryptStreamSrc) {
            bl = true;
            iStreamSrc = ((DecryptStreamSrc)iStreamSrc).getBaseSource();
        }
        if (iStreamSrc instanceof IFileSrc && ((IFileSrc)iStreamSrc).getFileSystem() instanceof FileSystem) {
            IFileSrc iFileSrc = (IFileSrc)iStreamSrc;
            this.associateFilename(this.getKey(), iFileSrc.getFilename(), bl);
        } else {
            Pair<ByteBuffer, Boolean> pair = null;
            try {
                pair = IOUtil.loadData(this.d_baseImage.getSource(), 0, true, ByteOrder.nativeOrder());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (pair != null) {
                this.associateBuffer(this.getKey(), (ByteBuffer)pair.v1, bl, (Boolean)pair.v2);
            }
        }
    }

    private native void associateBuffer(int var1, ByteBuffer var2, boolean var3, boolean var4);

    private native void associateFilename(int var1, String var2, boolean var3);
}

