/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.vecmath.Matrix4d;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.io.nativexfer.NativeManager;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.IRenderable;
import thunderheadeng.scene3d.nativebuffered.ISceneObject;
import thunderheadeng.scene3d.nativebuffered.Scene;
import thunderheadeng.scene3d.nativebuffered.SceneRenderOptions;
import thunderheadeng.scene3d.nativebuffered.nb3dUtil;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Keyable;
import thunderheadeng.util.theUtil;

public class ModelScene
extends Scene {
    private static final int MAX_ARR_SIZE = 10000;

    public ModelScene() {
        this.setDrawProps(new SceneRenderOptions());
    }

    protected ModelScene(Integer n, long l) {
        super(n, l);
    }

    private void exec(Methods methods, Object ... objectArray) {
        Native.manager.execMethod(ModelScene.class, (INativeObject)this, methods, objectArray);
    }

    public void setTransform(Matrix4d matrix4d) {
        Object[] objectArray;
        if (matrix4d == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = false;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = true;
            objectArray3[1] = matrix4d;
            objectArray = objectArray3;
            objectArray3[2] = ModelScene.invert(matrix4d);
        }
        Object[] objectArray4 = objectArray;
        this.exec(Methods.setTransform, objectArray4);
    }

    private static Matrix4d invert(Matrix4d matrix4d) {
        Matrix4d matrix4d2 = new Matrix4d(matrix4d);
        matrix4d2.invert();
        return matrix4d2;
    }

    public Matrix4d getTransform() {
        return Native.manager.exec(ModelScene.class, (INativeObject)this, (Enum)Methods.getTransform, (NativeManager nativeManager) -> {
            if (!nativeManager.readBoolean()) {
                return null;
            }
            return nb3dUtil.readMatrix(nativeManager);
        }, new Object[0]);
    }

    @Override
    public Class resolveNativeClass() {
        return ModelScene.class;
    }

    public void setDrawProps(SceneRenderOptions sceneRenderOptions) {
        this.exec(Methods.setRenderProps, sceneRenderOptions);
    }

    public SceneRenderOptions getDrawProps() {
        return Native.manager.execGet(ModelScene.class, (INativeObject)this, Methods.getRenderProps, SceneRenderOptions.class, new Object[0]);
    }

    public void forceImmediate(boolean bl) {
        Native.manager.execMethod(ModelScene.class, (INativeObject)this, Methods.forceImmediate, bl);
        Native.manager.flush();
    }

    public void addObjects(IDisplayable ... iDisplayableArray) {
        this.addObjects(Arrays.asList(iDisplayableArray));
    }

    public void addObjects(Collection<? extends IDisplayable> collection) {
        this.addRenderableObjects(theUtil.filter(collection, IRenderable.class));
        this.addSceneObjects(theUtil.filter(collection, ISceneObject.class));
    }

    public void removeObjects(IDisplayable ... iDisplayableArray) {
        this.removeObjects(Arrays.asList(iDisplayableArray));
    }

    public void removeObjects(Collection<? extends IDisplayable> collection) {
        this.removeRenderableObjects(theUtil.filter(collection, IRenderable.class));
        this.removeSceneObjects(theUtil.filter(collection, ISceneObject.class));
    }

    public void addRenderableObjects(IRenderable ... iRenderableArray) {
        this.addRenderableObjects(Arrays.asList(iRenderableArray));
    }

    public void addRenderableObjects(Collection<? extends IRenderable> collection) {
        this.execArrayMethod(Methods.addRenderableObjects, collection);
    }

    public void removeRenderableObjects(IRenderable ... iRenderableArray) {
        this.removeRenderableObjects(Arrays.asList(iRenderableArray));
    }

    public void removeRenderableObjects(Collection<? extends IRenderable> collection) {
        this.execArrayMethod(Methods.removeRenderableObjects, collection);
    }

    public void addSceneObjects(ISceneObject ... iSceneObjectArray) {
        this.addSceneObjects(Arrays.asList(iSceneObjectArray));
    }

    public void addSceneObjects(Collection<? extends ISceneObject> collection) {
        this.execArrayMethod(Methods.addSceneObjects, collection);
    }

    public void removeSceneObjects(ISceneObject ... iSceneObjectArray) {
        this.removeSceneObjects(Arrays.asList(iSceneObjectArray));
    }

    public void removeSceneObjects(Collection<? extends ISceneObject> collection) {
        this.execArrayMethod(Methods.removeSceneObjects, collection);
    }

    public void removeAllObjects() {
        Native.manager.execMethod(ModelScene.class, (INativeObject)this, Methods.removeAllObjects, new Object[0]);
    }

    private final void execArrayMethod(Methods methods, Collection<? extends Keyable> collection) {
        int n = collection.size() / 10000;
        if (collection.size() % 10000 != 0) {
            ++n;
        }
        Iterator<? extends Keyable> iterator = collection.iterator();
        int n2 = collection.size();
        Object[] objectArray = new Object[Math.min(10000, n2)];
        for (int i = 0; i < n; ++i) {
            int n3 = Math.min(n2, 10000);
            if (i == n - 1 && i > 0) {
                objectArray = new Object[n3];
            }
            for (int j = 0; j < n3; ++j) {
                objectArray[j] = iterator.next();
            }
            n2 -= n3;
            Native.manager.execMethod(ModelScene.class, (INativeObject)this, methods, n3, objectArray);
        }
    }

    private final Object[] getKeyableArray(Collection<?> collection) {
        IFilteredCollection<Keyable> iFilteredCollection = theUtil.filter(collection, Keyable.class);
        Object[] objectArray = iFilteredCollection.toArray((Keyable[])new Keyable[iFilteredCollection.size()]);
        return objectArray;
    }

    private static Object[] extractCHParams(ConvexHull convexHull) {
        Object[] objectArray = new Object[1 + convexHull.getPlanes().length * 4];
        objectArray[0] = convexHull.getPlanes().length;
        for (int i = 0; i < convexHull.getPlanes().length; ++i) {
            Plane3d plane3d = convexHull.getPlanes()[i];
            int n = (i << 2) + 1;
            objectArray[n + 0] = plane3d.x;
            objectArray[n + 1] = plane3d.y;
            objectArray[n + 2] = plane3d.z;
            objectArray[n + 3] = plane3d.w;
        }
        return objectArray;
    }

    public void addCullBox(ConvexHull convexHull) {
        Object[] objectArray = ModelScene.extractCHParams(convexHull);
        Native.manager.execMethod(ModelScene.class, (INativeObject)this, Methods.addCullBox, objectArray);
    }

    public void removeCullBox(ConvexHull convexHull) {
        Object[] objectArray = ModelScene.extractCHParams(convexHull);
        Native.manager.execMethod(ModelScene.class, (INativeObject)this, Methods.removeCullBox, objectArray);
    }

    public void removeAllCullBoxes() {
        Native.manager.execMethod(ModelScene.class, (INativeObject)this, Methods.removeAllCullBoxes, new Object[0]);
    }

    static {
        nb3dUtil.registerTypes();
    }

    private static enum Methods {
        addRenderableObjects,
        removeRenderableObjects,
        addSceneObjects,
        removeSceneObjects,
        removeAllObjects,
        forceImmediate,
        addCullBox,
        removeCullBox,
        removeAllCullBoxes,
        setRenderProps,
        getRenderProps,
        setTransform,
        getTransform;

    }
}

