/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import thunderheadeng.scene3d.nativebuffered.RenderPanel;
import thunderheadeng.scene3d.nativebuffered.Viewport;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Keyable;

public interface IRenderSurface
extends Keyable {
    public static final int CAP_FAST_DEPTH_READS = 1;
    public static final int CAP_FAST_COLOR_READS = 2;
    public static final int CAP_FAST_VERTEX_BUFFERS = 4;
    public static final int CAP_FAST_SHADERS = 8;
    public static final int CAP_CONTEXT_SHARING = 16;
    public static final int ALL_CAPS = 31;
    public static final IPropertySet.Prop<YesNoAuto> PROP_COMPRESS_SIZE4 = new IPropertySet.Prop<YesNoAuto>(633075, YesNoAuto.AUTO);

    public void setSize(int var1, int var2);

    public int getWidth();

    public int getHeight();

    public void setRootPanel(RenderPanel var1);

    public RenderPanel getRootPanel();

    public void updateLayout();

    public void repaint();

    public void pauseRender();

    public void render();

    public void render(Viewport var1);

    public void resumeRender();

    public void resumeRender(boolean var1);

    public <T> void setProp(IPropertySet.Prop<T> var1, T var2);

    public OpenGLInfo getOpenGLInfo();

    default public String getRenderID() {
        OpenGLInfo openGLInfo = this.getOpenGLInfo();
        return openGLInfo.vendor + " " + openGLInfo.renderer;
    }

    public Adapter getAdapter();

    public int testRenderCapabilities(int var1);

    public static class OpenGLInfo {
        public final String vendor;
        public final String renderer;
        public final VersionInfo version;
        public final VersionInfo glslVersion;
        public final int build;

        public OpenGLInfo(String string, String string2, VersionInfo versionInfo, VersionInfo versionInfo2, int n) {
            this.vendor = string;
            this.renderer = string2;
            this.version = versionInfo;
            this.glslVersion = versionInfo2;
            this.build = n;
        }

        public OpenGLInfo() {
            this("", "", new VersionInfo(), new VersionInfo(), -1);
        }
    }

    public static class VersionInfo {
        public final String versionStr;
        public final Version version;
        public final String vendorVer;

        public VersionInfo(String string, Version version, String string2) {
            this.versionStr = string;
            this.version = version;
            this.vendorVer = string2;
        }

        public VersionInfo() {
            this("", new Version(), "");
        }
    }

    public static class Version {
        public final int major;
        public final int minor;
        public final int release;

        public Version(int n, int n2, int n3) {
            this.major = n;
            this.minor = n2;
            this.release = n3;
        }

        public Version() {
            this(1, 1, 0);
        }
    }

    public static enum Adapter {
        AMD,
        NVIDIA,
        INTEL,
        UNKNOWN;

    }

    public static enum YesNoAuto {
        NO,
        YES,
        AUTO;

    }
}

