/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.io.IOException;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.INativeStream;
import thunderheadeng.io.nativexfer.INativelyMirrored;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.GeomWriter;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import thunderheadeng.scene3d.nativebuffered.ISceneObject;
import thunderheadeng.scene3d.nativebuffered.NativeGeomWriterOutput;

public class GeomDisplay
extends ISceneObject
implements INativelyMirrored {
    private static final int method_setSelected = 0;
    private boolean d_selected = false;
    private INativeDisplayProps d_dispProps;
    private IDisplayableGeomSrc d_source;

    public GeomDisplay(INativeDisplayProps iNativeDisplayProps, IDisplayableGeomSrc iDisplayableGeomSrc) {
        this.d_dispProps = iNativeDisplayProps;
        this.d_source = iDisplayableGeomSrc;
        this.nativeConstructed(GeomDisplay.class);
    }

    @Override
    public Class resolveNativeClass() {
        return GeomDisplay.class;
    }

    @Override
    public void markNativeClean() {
    }

    public IDisplayable[] getDisplayObjs() {
        return new IDisplayable[]{this};
    }

    public INativeDisplayProps getDisplayProps() {
        return this.d_dispProps;
    }

    public void setSelected(boolean bl) {
        if (this.d_selected == bl) {
            return;
        }
        this.d_selected = bl;
        Native.manager.execMethod(GeomDisplay.class, (INativeObject)this, 0, bl);
    }

    public boolean isSelected() {
        return this.d_selected;
    }

    public IDisplayableGeomSrc getSource() {
        return this.d_source;
    }

    public void setSource(IDisplayableGeomSrc iDisplayableGeomSrc) {
        this.d_source = iDisplayableGeomSrc;
        this.update();
    }

    public void update() {
        this.markNativeDirty();
    }

    @Override
    public void writeNativeData(INativeStream iNativeStream) {
        DisplayGeom displayGeom = this.d_source.getDisplayGeom(this.d_dispProps);
        try {
            NativeGeomWriterOutput nativeGeomWriterOutput = new NativeGeomWriterOutput(iNativeStream){

                @Override
                public void writeObject(Object object) throws IOException {
                    if (object instanceof IMaterial) {
                        object = GeomDisplay.this.d_dispProps.getNativeMat((IMaterial)object);
                    }
                    super.writeObject(object);
                }
            };
            GeomWriter.write(nativeGeomWriterOutput, displayGeom.node, displayGeom.props, this.d_dispProps.getCurveError(), this.d_dispProps.getFaceError());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

