/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.util.Map;
import java.util.WeakHashMap;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import thunderheadeng.scene3d.nativebuffered.NativeMaterial;

public class DefNativeDisplayProps
implements INativeDisplayProps {
    private final Map<IMaterial, NativeMaterial> d_materials = new WeakHashMap<IMaterial, NativeMaterial>();
    private final Map<IMatAttrs, NativeMaterial> d_attrMats = new WeakHashMap<IMatAttrs, NativeMaterial>();
    private double d_curveError;
    private double d_faceError;

    public DefNativeDisplayProps() {
        this(0.01, 0.1);
    }

    public DefNativeDisplayProps(double d, double d2) {
        this.d_curveError = d;
        this.d_faceError = d2;
    }

    @Override
    public double getCurveError() {
        return this.d_curveError;
    }

    public void setCurveError(double d) {
        this.d_curveError = d;
    }

    @Override
    public double getFaceError() {
        return this.d_faceError;
    }

    public void setFaceError(double d) {
        this.d_faceError = d;
    }

    public NativeMaterial registerMat(IMaterial iMaterial) {
        return this.updateMat(iMaterial, false);
    }

    public NativeMaterial updateMat(IMaterial iMaterial) {
        return this.updateMat(iMaterial, true);
    }

    private NativeMaterial updateMat(IMaterial iMaterial, boolean bl) {
        NativeMaterial nativeMaterial = this.d_materials.get(iMaterial);
        if (nativeMaterial == null || bl) {
            IMatAttrs iMatAttrs = iMaterial.getAttributes();
            nativeMaterial = this.d_attrMats.get(iMatAttrs);
            if (nativeMaterial == null) {
                nativeMaterial = new NativeMaterial(iMatAttrs);
                this.d_attrMats.put(iMatAttrs, nativeMaterial);
            }
            this.d_materials.put(iMaterial, nativeMaterial);
        }
        return nativeMaterial;
    }

    public void removeMat(IMaterial iMaterial) {
        this.d_materials.remove(iMaterial);
    }

    public void clearMaterials() {
        this.d_materials.clear();
    }

    @Override
    public NativeMaterial getNativeMat(IMaterial iMaterial) {
        return this.d_materials.get(iMaterial);
    }
}

