/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.ARenderComponent;
import thunderheadeng.scene3d.nativebuffered.IRenderComponent;

public class ClearableBackground
extends ARenderComponent
implements IRenderComponent {
    public ClearableBackground(boolean bl, boolean bl2) {
        this.setColorClearEnabled(bl);
        this.setClearColor(Color.WHITE);
        this.setDepthClearEnabled(bl2);
        this.setClearDepth(1.0);
    }

    protected ClearableBackground(Integer n, long l) {
        super(n, l);
    }

    @Override
    public Class resolveNativeClass() {
        return ClearableBackground.class;
    }

    public void setColorClearEnabled(boolean bl) {
        this.exec(Methods.setColorClearEnabled, bl);
    }

    public void setDepthClearEnabled(boolean bl) {
        this.exec(Methods.setDepthClearEnabled, bl);
    }

    public void setStencilClearEnabled(boolean bl) {
        this.exec(Methods.setStencilClearEnabled, bl);
    }

    public void setColor(Color color) {
        this.setClearColor(color);
    }

    public void setClearColor(Color color) {
        float[] fArray = new float[4];
        color.getComponents(fArray);
        this.exec(Methods.setClearColor, Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]), Float.valueOf(fArray[3]));
    }

    public void setClearDepth(double d) {
        this.exec(Methods.setClearDepth, d);
    }

    public void setClearStencil(int n) {
        this.exec(Methods.setClearStencil, n);
    }

    private void exec(Methods methods, Object ... objectArray) {
        Native.manager.execMethod(ClearableBackground.class, (INativeObject)this, methods, objectArray);
    }

    private static enum Methods {
        setColorClearEnabled,
        setDepthClearEnabled,
        setStencilClearEnabled,
        setClearColor,
        setClearDepth,
        setClearStencil;

    }
}

