/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.io.Serializable;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.theUtil;

public class CameraRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Point3d loc;
    public final Point3d ref;
    public final Vector3d up;
    public final double zoom;
    public final Point2d zoomLoc;
    public final double near;
    public final double far;
    public final IFrustumRecord frustum;

    public CameraRecord(Point3d point3d, Point3d point3d2, Vector3d vector3d, double d, Point2d point2d, double d2, double d3, IFrustumRecord iFrustumRecord) {
        this.loc = new Point3d(point3d);
        this.ref = new Point3d(point3d2);
        this.up = new Vector3d(vector3d);
        this.zoom = d;
        this.zoomLoc = new Point2d(point2d);
        this.near = d2;
        this.far = d3;
        this.frustum = iFrustumRecord;
    }

    public CameraRecord slerp(CameraRecord cameraRecord, double d) {
        Point3d point3d;
        Point3d point3d2;
        Vector3d vector3d;
        Vector3d vector3d2;
        if (this.ref.epsilonEquals(cameraRecord.ref, 1.0E-9)) {
            vector3d2 = Util3D.vector(this.loc, this.ref);
            vector3d = Util3D.vector(cameraRecord.loc, cameraRecord.ref);
            double d2 = vector3d2.length();
            double d3 = vector3d.length();
            point3d2 = cameraRecord.ref;
            Vector3d vector3d3 = Util3D.slerp(vector3d2, vector3d, d);
            vector3d3.normalize();
            vector3d3.scale(theUtil.lerp(d2, d3, d));
            point3d = Util3D.sub(point3d2, (Tuple3d)vector3d3);
        } else {
            point3d = Util3D.lerp(this.loc, cameraRecord.loc, d);
            point3d2 = Util3D.lerp(this.ref, cameraRecord.ref, d);
        }
        vector3d2 = Util3D.slerp(this.up, cameraRecord.up, d);
        vector3d = Util3D.vectorN(point3d, point3d2);
        Vector3d vector3d4 = Util3D.cross(vector3d, vector3d2);
        vector3d2 = Util3D.cross(vector3d4, vector3d);
        vector3d2.normalize();
        return new CameraRecord(point3d, point3d2, vector3d2, theUtil.lerp(this.zoom, cameraRecord.zoom, d), Util2D.lerp(this.zoomLoc, cameraRecord.zoomLoc, d), theUtil.lerp(this.near, cameraRecord.near, d), theUtil.lerp(this.far, cameraRecord.far, d), this.frustum.slerp(cameraRecord.frustum, d));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CameraRecord)) {
            return false;
        }
        CameraRecord cameraRecord = (CameraRecord)object;
        return this.zoom == cameraRecord.zoom && this.near == cameraRecord.near && this.far == cameraRecord.far && this.frustum.equals(cameraRecord.frustum) && this.zoomLoc.equals(cameraRecord.zoomLoc) && this.loc.equals(cameraRecord.loc) && this.ref.equals(cameraRecord.ref) && this.up.equals(cameraRecord.up);
    }

    public boolean tolEquals(CameraRecord cameraRecord, double d) {
        return theUtil.eq(this.zoom, cameraRecord.zoom, d) && theUtil.eq(this.near, cameraRecord.near, d) && theUtil.eq(this.far, cameraRecord.far, d) && this.frustum.tolEquals(cameraRecord.frustum, d) && this.zoomLoc.epsilonEquals(cameraRecord.zoomLoc, d) && this.loc.epsilonEquals(cameraRecord.loc, d) && this.ref.epsilonEquals(cameraRecord.ref, d) && this.up.epsilonEquals(cameraRecord.up, d);
    }

    public static interface IFrustumRecord {
        public boolean equals(Object var1);

        public boolean tolEquals(IFrustumRecord var1, double var2);

        public IFrustumRecord slerp(IFrustumRecord var1, double var2);
    }
}

