/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.util.Observer;
import java.util.function.Function;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.io.nativexfer.ANativeObject;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.INativeStream;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.io.nativexfer.NativeManager;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.nb3dUtil;
import thunderheadeng.util.ObservableMediator;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public abstract class Camera
extends ANativeObject {
    public static final int LOCALAXIS_FORWARD = 0;
    public static final int LOCALAXIS_RIGHT = 1;
    public static final int LOCALAXIS_UP = 2;
    private final ObservableMediator d_observable = new ObservableMediator();
    public static final int MAT_TRANSFORM = 0;
    public static final int MAT_INV_TRANSFORM = 1;
    public static final int MAT_VIEW = 2;
    public static final int MAT_INV_VIEW = 3;
    public static final int MAT_PROJECTION = 4;
    public static final int MAT_INV_PROJECTION = 5;
    public static final int MAT_WORLD_TO_SCREEN = 6;
    public static final int MAT_SCREEN_TO_WORLD = 7;

    protected abstract double calcScreenZValue(double var1);

    protected abstract Point3d constrainPointToView(Point3d var1, Point3d var2);

    public abstract double getSubjectSize();

    public abstract Vector3d getViewVector(Point3d var1);

    public abstract Function<Point3d, Vector3d> getViewVectorFunction();

    private static Position readPosition(INativeStream iNativeStream) {
        return new Position(nb3dUtil.readP3d(iNativeStream), nb3dUtil.readP3d(iNativeStream), nb3dUtil.readV3d(iNativeStream));
    }

    protected Camera() {
    }

    public Camera(Point3d point3d, Point3d point3d2, Vector3d vector3d, double d, double d2) {
        this.setPosition(point3d);
        this.setReference(point3d2);
        this.setUpVector(vector3d);
        this.setClip(d, d2);
    }

    protected Camera(Integer n, long l) {
        super(n, l);
    }

    @Override
    public Class resolveNativeClass() {
        return Camera.class;
    }

    private void exec(Methods methods, Object ... objectArray) {
        Native.manager.execMethod(Camera.class, (INativeObject)this, methods, objectArray);
    }

    private <T> T exec(Methods methods, Class<T> clazz, Object ... objectArray) {
        return Native.manager.execGet(Camera.class, (INativeObject)this, methods, clazz, objectArray);
    }

    private <T> T exec(Methods methods, Function<NativeManager, T> function, Object ... objectArray) {
        return Native.manager.exec(Camera.class, (INativeObject)this, (Enum)methods, function, objectArray);
    }

    public void setCustomTransform(Matrix4d matrix4d) {
        Object[] objectArray;
        if (matrix4d == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = false;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = true;
            objectArray3[1] = matrix4d;
            objectArray = objectArray3;
            objectArray3[2] = Camera.invert(matrix4d);
        }
        Object[] objectArray4 = objectArray;
        this.exec(Methods.setCustomTransform, objectArray4);
    }

    private static Matrix4d invert(Matrix4d matrix4d) {
        Matrix4d matrix4d2 = new Matrix4d(matrix4d);
        matrix4d2.invert();
        return matrix4d2;
    }

    public Matrix4d getCustomTransform() {
        return this.exec(Methods.getCustomTransform, (NativeManager nativeManager) -> nativeManager.readBoolean() ? nb3dUtil.readMatrix(nativeManager) : null, new Object[0]);
    }

    public Matrix4d getInverseCustomTransform() {
        Matrix4d matrix4d = this.getCustomTransform();
        return matrix4d == null ? null : Camera.invert(matrix4d);
    }

    protected AABox toView(AABox aABox) {
        Matrix4d matrix4d = this.getCustomTransform();
        if (matrix4d == null) {
            return aABox;
        }
        aABox = new AABox(aABox);
        aABox.transformEq(matrix4d);
        return aABox;
    }

    protected Vector3d toView(Vector3d vector3d) {
        Matrix4d matrix4d = this.getCustomTransform();
        return matrix4d != null ? Util3D.xform(matrix4d, vector3d) : vector3d;
    }

    protected Point3d toView(Point3d point3d) {
        Matrix4d matrix4d = this.getCustomTransform();
        return matrix4d != null ? Util3D.xform(matrix4d, point3d) : point3d;
    }

    public void setCopyCam(Camera camera) {
        this.exec(Methods.setCopyCam, camera);
    }

    public abstract Camera createCopyCam();

    public void addObserver(Observer observer) {
        this.d_observable.addObserver(observer);
    }

    public void removeObserver(Observer observer) {
        this.d_observable.deleteObserver(observer);
    }

    public void resetRotation() {
        Position position = this.getPositionInfo();
        Point3d point3d = new Point3d(position.pos);
        position.up.set(0.0, 0.0, 1.0);
        position.ref.set(0.0, 1.0, 0.0);
        position.pos.set(0.0, 0.0, 0.0);
        position.ref.add(point3d);
        position.pos.add(point3d);
        this.setPositionInfo(position);
    }

    public Position getPositionInfo() {
        return this.exec(Methods.getPositionInfo, Camera::readPosition, new Object[0]);
    }

    public void setPositionInfo(Position position) {
        this.exec(Methods.setPositionInfo, position);
        this.markDirty();
    }

    public AABox ensureValidForReset(AABox aABox, double d) {
        return aABox.ensureValidSize(d, d);
    }

    public void reset(AABox aABox, int n, int n2) {
        this.reset(new Vector3d(0.0, 0.0, -1.0), new Vector3d(0.0, 1.0, 0.0), aABox, n, n2);
    }

    public void reset(Vector3d vector3d, Vector3d vector3d2, AABox aABox, int n, int n2) {
        this.reset(vector3d, vector3d2, aABox, n, n2, false);
    }

    public void reset(Vector3d vector3d, Vector3d vector3d2, AABox aABox) {
        this.reset(vector3d, vector3d2, aABox, 0, 0, true);
    }

    protected void reset(Vector3d vector3d, Vector3d vector3d2, AABox aABox, int n, int n2, boolean bl) {
        this.setZoom(new Point2d(0.0, 0.0), 1.0);
    }

    public void fillView(AABox aABox) {
        this.fillView(aABox, 0, 0, true);
    }

    public void fillView(AABox aABox, int n, int n2) {
        this.fillView(aABox, n, n2, false);
    }

    protected void fillView(AABox aABox, int n, int n2, boolean bl) {
        this.reset(Util3D.normalize(this.getViewVector()), Util3D.normalize(this.getUpVector()), aABox, n, n2, bl);
    }

    public void orbit(double d, double d2, double d3, double d4) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Position position = this.getPositionInfo();
        vector3d3.sub(position.pos, position.ref);
        vector3d2.set(position.up);
        vector3d.cross(vector3d2, vector3d3);
        vector3d.normalize();
        vector3d2.normalize();
        vector3d3.normalize();
        vector3d.scale(d2);
        vector3d2.scale(d3);
        vector3d3.scale(d4);
        Vector3d vector3d4 = new Vector3d(vector3d);
        vector3d4.add(vector3d2);
        vector3d4.add(vector3d3);
        double d5 = d * Math.PI / 180.0;
        AxisAngle4d axisAngle4d = new AxisAngle4d(vector3d4, d5);
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.set(axisAngle4d);
        Vector3d vector3d5 = new Vector3d();
        vector3d5.sub(position.pos, position.ref);
        matrix3d.transform(vector3d5);
        position.pos.add(position.ref, vector3d5);
        matrix3d.transform(position.up);
        this.setPositionInfo(position);
    }

    public void orbit(double d, Vector3d vector3d) {
        this.orbit(d, vector3d.x, vector3d.y, vector3d.z);
    }

    public void rotate(double d, Vector3d vector3d) {
        double d2 = d * Math.PI / 180.0;
        AxisAngle4d axisAngle4d = new AxisAngle4d(vector3d, d2);
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.set(axisAngle4d);
        Position position = this.getPositionInfo();
        Vector3d vector3d2 = new Vector3d();
        vector3d2.sub(position.ref, position.pos);
        matrix3d.transform(vector3d2);
        position.ref.add(position.pos, vector3d2);
        matrix3d.transform(position.up);
        this.setPositionInfo(position);
    }

    public void rotate(double d, double d2, double d3, double d4) {
        this.rotate(d, new Vector3d(d2, d3, d4));
    }

    public void translateWorld(Vector3d vector3d, boolean bl) {
        Position position = this.getPositionInfo();
        position.pos.add(vector3d);
        if (bl) {
            position.ref.add(vector3d);
        }
        this.setPositionInfo(position);
    }

    public void translateWorld(double d, double d2, double d3, boolean bl) {
        this.translateWorld(new Vector3d(d, d2, d3), bl);
    }

    public void translateEye(Point3d point3d, Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Position position = this.getPositionInfo();
        vector3d4.sub(position.pos, position.ref);
        vector3d3.set(position.up);
        vector3d2.cross(vector3d3, vector3d4);
        vector3d2.normalize();
        vector3d3.normalize();
        vector3d4.normalize();
        vector3d2.scale(vector3d.x);
        vector3d3.scale(vector3d.y);
        vector3d4.scale(vector3d.z);
        Vector3d vector3d5 = new Vector3d(0.0, 0.0, 0.0);
        vector3d5.add(vector3d2);
        vector3d5.add(vector3d3);
        vector3d5.add(vector3d4);
        point3d.add(vector3d5);
    }

    public void translateEye(Vector3d vector3d, boolean bl) {
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        Position position = this.getPositionInfo();
        vector3d4.sub(position.pos, position.ref);
        vector3d3.set(position.up);
        vector3d2.cross(vector3d3, vector3d4);
        vector3d2.normalize();
        vector3d3.normalize();
        vector3d4.normalize();
        vector3d2.scale(vector3d.x);
        vector3d3.scale(vector3d.y);
        vector3d4.scale(vector3d.z);
        Vector3d vector3d5 = new Vector3d(0.0, 0.0, 0.0);
        vector3d5.add(vector3d2);
        vector3d5.add(vector3d3);
        vector3d5.add(vector3d4);
        position.pos.add(vector3d5);
        if (bl) {
            position.ref.add(vector3d5);
        }
        this.setPositionInfo(position);
    }

    public void translateEye(double d, double d2, double d3, boolean bl) {
        Vector3d vector3d = new Vector3d(d, d2, d3);
        this.translateEye(vector3d, bl);
    }

    public void zoomAboutPoint(double d, Point2d point2d) {
        this.exec(Methods.zoomAboutPoint, d, point2d);
        this.markDirty();
    }

    public void zoom(double d, Point2d point2d) {
        this.exec(Methods.zoom, d, point2d);
        this.markDirty();
    }

    public void setZoom(Point2d point2d, double d) {
        this.exec(Methods.setZoom, d, point2d);
        this.markDirty();
    }

    protected Pair<Double, Point2d> getFullZoom() {
        return this.exec(Methods.getZoom, (NativeManager nativeManager) -> {
            double d = Native.manager.readDouble();
            Point2d point2d = nb3dUtil.readP2d(nativeManager);
            return new Pair<Double, Point2d>(d, point2d);
        }, new Object[0]);
    }

    public double getZoom() {
        return (Double)this.getFullZoom().v1;
    }

    public Point2d getZoomLoc() {
        return (Point2d)this.getFullZoom().v2;
    }

    public void setPosition(Point3d point3d) {
        this.exec(Methods.setPosition, point3d);
        this.markDirty();
    }

    public void setPosition(double d, double d2, double d3) {
        this.exec(Methods.setPosition, d, d2, d3);
        this.markDirty();
    }

    public Point3d getPosition() {
        return this.getPositionInfo().pos;
    }

    public void setReference(Point3d point3d) {
        this.exec(Methods.setReference, point3d);
        this.markDirty();
    }

    public void setReference(double d, double d2, double d3) {
        this.exec(Methods.setReference, d, d2, d3);
        this.markDirty();
    }

    public Point3d getReference() {
        return this.getPositionInfo().ref;
    }

    public void setUpVector(Vector3d vector3d) {
        this.exec(Methods.setUp, vector3d);
        this.markDirty();
    }

    public void setUpVector(double d, double d2, double d3) {
        this.exec(Methods.setUp, d, d2, d3);
        this.markDirty();
    }

    public Vector3d getUpVector() {
        return this.getPositionInfo().up;
    }

    public void setClip(double d, double d2) {
        this.exec(Methods.setClip, d, d2);
    }

    public double[] getClip() {
        return this.exec(Methods.getClip, (NativeManager nativeManager) -> nativeManager.readDoubles(2), new Object[0]);
    }

    public double getNearClip() {
        return this.getClip()[0];
    }

    public double getFarClip() {
        return this.getClip()[1];
    }

    public void fitClipping(AABox aABox) {
        this.fitClipping(aABox, 0.005);
    }

    public void fitClipping(AABox aABox, double d) {
        this.exec(Methods.fitClipping, aABox.getMinX(), aABox.getMinY(), aABox.getMinZ(), aABox.getMaxX(), aABox.getMaxY(), aABox.getMaxZ(), d);
    }

    public Vector3d getViewVector() {
        Position position = this.getPositionInfo();
        Vector3d vector3d = new Vector3d();
        vector3d.sub(position.ref, position.pos);
        return vector3d;
    }

    public Vector3d getRightVector() {
        Vector3d vector3d = this.getUpVector();
        Vector3d vector3d2 = this.getViewVector();
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d2, vector3d);
        return vector3d3;
    }

    public double getDistance() {
        return this.getViewVector().length();
    }

    public Plane3d getViewPlane() {
        Vector3d vector3d = this.getViewVector();
        vector3d.normalize();
        Point3d point3d = this.getPosition();
        double d = -point3d.x * vector3d.x - point3d.y * vector3d.y - point3d.z * vector3d.z;
        return new Plane3d(vector3d.x, vector3d.y, vector3d.z, d);
    }

    public Plane3d getRefPlane() {
        Vector3d vector3d = this.getViewVector();
        vector3d.normalize();
        Point3d point3d = this.getReference();
        return new Plane3d(vector3d, point3d);
    }

    public Vector3d vecToPointAlongLocalAxis(Point3d point3d, int n) {
        Vector3d vector3d = new Vector3d();
        switch (n) {
            case 0: {
                vector3d.normalize(this.getViewVector());
                break;
            }
            case 2: {
                vector3d.normalize(this.getUpVector());
                break;
            }
            case 1: {
                vector3d.normalize(this.getRightVector());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        Vector3d vector3d2 = new Vector3d();
        vector3d2.sub(point3d, this.getPosition());
        double d = vector3d2.dot(vector3d);
        vector3d.scale(d);
        return vector3d;
    }

    public Matrix3d getLocalTransformLHR() {
        Vector3d vector3d = this.getUpVector();
        vector3d.normalize();
        Vector3d vector3d2 = this.getRightVector();
        vector3d2.normalize();
        Vector3d vector3d3 = this.getViewVector();
        vector3d3.normalize();
        return new Matrix3d(vector3d2.x, vector3d2.y, vector3d2.z, vector3d.x, vector3d.y, vector3d.z, vector3d3.x, vector3d3.y, vector3d3.z);
    }

    public Matrix3d getLocalTransformRHR() {
        Matrix3d matrix3d = this.getLocalTransformLHR();
        matrix3d.m20 = -matrix3d.m20;
        matrix3d.m21 = -matrix3d.m21;
        matrix3d.m22 = -matrix3d.m22;
        return matrix3d;
    }

    protected void markDirty() {
        this.d_observable.setChanged();
        this.d_observable.notifyObservers();
    }

    protected Point3d worldToLocal(Point3d point3d) {
        Matrix3d matrix3d = this.getLocalTransformRHR();
        Point3d point3d2 = new Point3d(point3d);
        matrix3d.transform(point3d2);
        return point3d2;
    }

    protected Point3d worldToView(Point3d point3d) {
        Point4d point4d = this.worldToView(new Point4d(point3d.x, point3d.y, point3d.z, 1.0));
        return theUtil.p4dTo3d(point4d);
    }

    protected Point4d worldToView(Point4d point4d) {
        return this.exec(Methods.worldToView, nb3dUtil::readP4d, point4d.x, point4d.y, point4d.z, point4d.w);
    }

    protected Point3d viewToWorld(Point3d point3d) {
        Point4d point4d = this.viewToWorld(new Point4d(point3d.x, point3d.y, point3d.z, 1.0));
        return theUtil.p4dTo3d(point4d);
    }

    protected Point4d viewToWorld(Point4d point4d) {
        return this.exec(Methods.viewToWorld, nb3dUtil::readP4d, point4d);
    }

    protected Point3d worldToScreen(Point3d point3d) {
        return this.worldToScreen(new Point4d(point3d.x, point3d.y, point3d.z, 1.0));
    }

    protected Point3d worldToScreen(Point4d point4d) {
        return this.exec(Methods.worldToScreen, nb3dUtil::readP3d, point4d);
    }

    protected Point3d screenToWorld(Point3d point3d) {
        return this.exec(Methods.screenToWorld, nb3dUtil::readP3d, point3d);
    }

    protected double screenToWorld(double d, Point3d point3d) {
        Point3d point3d2 = this.worldToScreen(point3d);
        return this.screenToWorld(d, point3d2.z);
    }

    protected double screenToWorld(double d, double d2) {
        Point3d point3d = this.screenToWorld(new Point3d(d, 0.0, d2));
        Point3d point3d2 = this.screenToWorld(new Point3d(0.0, 0.0, d2));
        return point3d.distance(point3d2);
    }

    protected Point3d viewToScreen(Point4d point4d) {
        return this.exec(Methods.viewToScreen, nb3dUtil::readP3d, point4d);
    }

    protected Point3d viewToScreen(Point3d point3d) {
        return this.viewToScreen(new Point4d(point3d.x, point3d.y, point3d.z, 1.0));
    }

    protected Point3d screenToView(Point3d point3d) {
        return this.exec(Methods.screenToView, nb3dUtil::readP3d, point3d);
    }

    protected double screenToView(double d) {
        Point3d point3d = this.screenToView(new Point3d(d, 0.0, 0.0));
        Point3d point3d2 = this.screenToView(new Point3d(0.0, 0.0, 0.0));
        return point3d.distance(point3d2);
    }

    protected Point3d worldToCamera(Point3d point3d) {
        Point4d point4d = this.worldToCamera(new Point4d(point3d.x, point3d.y, point3d.z, 1.0));
        return theUtil.p4dTo3d(point4d);
    }

    protected Point4d worldToCamera(Point4d point4d) {
        return this.exec(Methods.screenToView, nb3dUtil::readP4d, point4d);
    }

    protected Point3d screenToCamera(Point3d point3d) {
        return this.exec(Methods.screenToCamera, nb3dUtil::readP3d, point3d);
    }

    public Matrix4d getMatrix(int n) {
        return this.exec(Methods.getMatrix, nb3dUtil::readMatrix, n);
    }

    public abstract CameraRecord capture();

    public void apply(CameraRecord cameraRecord) {
        this.setPosition(cameraRecord.loc);
        this.setReference(cameraRecord.ref);
        this.setUpVector(cameraRecord.up);
        this.setZoom(cameraRecord.zoomLoc, cameraRecord.zoom);
        this.setClip(cameraRecord.near, cameraRecord.far);
    }

    static {
        nb3dUtil.registerTypes();
        NativeManager.registerWriter(Position.class, (aBufferedNativeStream, position) -> {
            nb3dUtil.write((INativeStream)aBufferedNativeStream, position.pos);
            nb3dUtil.write((INativeStream)aBufferedNativeStream, position.ref);
            nb3dUtil.write((INativeStream)aBufferedNativeStream, position.up);
        });
        NativeManager.registerReader(Position.class, Camera::readPosition);
    }

    public static class Position {
        public final Point3d pos;
        public final Point3d ref;
        public final Vector3d up;

        public Position(Point3d point3d, Point3d point3d2, Vector3d vector3d) {
            this.pos = point3d;
            this.ref = point3d2;
            this.up = vector3d;
        }
    }

    private static enum Methods {
        setPositionInfo,
        getPositionInfo,
        setPosition,
        setReference,
        setUp,
        setCustomTransform,
        getCustomTransform,
        worldToView,
        viewToWorld,
        worldToScreen,
        screenToWorld,
        viewToScreen,
        screenToView,
        worldToCamera,
        screenToCamera,
        reset,
        getMatrix,
        setCopyCam,
        setClip,
        getClip,
        zoom,
        zoomAboutPoint,
        setZoom,
        getZoom,
        fitClipping;

    }
}

