/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.ARenderComponent;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.IRenderComponent;
import thunderheadeng.scene3d.nativebuffered.IRenderable;
import thunderheadeng.scene3d.nativebuffered.Scene;

public class BasicRenderer
extends ARenderComponent
implements IRenderComponent {
    public BasicRenderer() {
        this((Camera)null, new IRenderable[0]);
    }

    public BasicRenderer(Scene scene) {
        this(scene.getCamera(), scene);
    }

    public BasicRenderer(Camera camera, IRenderable ... iRenderableArray) {
        this.setCamera(camera);
        this.setMode(Mode.RENDER);
        for (IRenderable iRenderable : iRenderableArray) {
            this.add(iRenderable);
        }
    }

    protected BasicRenderer(Integer n, long l) {
        super(n, l);
    }

    @Override
    public Class resolveNativeClass() {
        return BasicRenderer.class;
    }

    public void add(IRenderable iRenderable) {
        Native.manager.execMethod(BasicRenderer.class, (INativeObject)this, Methods.add.ordinal(), iRenderable);
    }

    public void remove(IRenderable iRenderable) {
        Native.manager.execMethod(BasicRenderer.class, (INativeObject)this, Methods.remove.ordinal(), iRenderable);
    }

    public void clear() {
        Native.manager.execMethod(BasicRenderer.class, (INativeObject)this, Methods.clear.ordinal(), new Object[0]);
    }

    public void setAutoZFit(boolean bl) {
        Native.manager.execMethod(BasicRenderer.class, (INativeObject)this, Methods.setAutoZFit.ordinal(), bl);
    }

    public void setCamera(Camera camera) {
        Native.manager.execMethod(BasicRenderer.class, (INativeObject)this, Methods.setCamera.ordinal(), camera);
    }

    public void setMode(Mode mode) {
        Native.manager.execMethod(BasicRenderer.class, (INativeObject)this, Methods.setMode.ordinal(), mode.ordinal());
    }

    private static enum Methods {
        add,
        remove,
        clear,
        setAutoZFit,
        setCamera,
        setMode;

    }

    public static enum Mode {
        RENDER,
        Z_FIT_ONLY;

    }
}

