/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Dimension;
import java.util.function.Supplier;
import thunderheadeng.io.nativexfer.ANativeObject;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.FPSTimer;
import thunderheadeng.scene3d.nativebuffered.ARenderCounter;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.nativebuffered.RenderPanel;
import thunderheadeng.scene3d.nativebuffered.Viewport;
import thunderheadeng.scene3d.nativebuffered.nb3dUtil;
import thunderheadeng.util.IPropertySet;

public abstract class ARenderSurface
extends ANativeObject
implements IRenderSurface {
    private FPSTimer d_fpsTimer = new FPSTimer();
    private Thread d_animatingThread = null;
    private ARenderCounter d_renderCounter = new ARenderCounter(){

        @Override
        protected void forceRender(Viewport viewport) {
            ARenderSurface.this.forceRender(viewport);
        }

        @Override
        protected Viewport getFullVP() {
            return new Viewport(0, 0, ARenderSurface.this.getWidth(), ARenderSurface.this.getHeight());
        }
    };

    protected abstract void forceRender(Viewport var1);

    public ARenderSurface() {
        this.setRootPanel(new RenderPanel());
    }

    protected ARenderSurface(Integer n, long l) {
        super(n, l);
    }

    @Override
    public Class resolveNativeClass() {
        return ARenderSurface.class;
    }

    private void exec(Methods methods, Object ... objectArray) {
        Native.manager.execMethod(ARenderSurface.class, (INativeObject)this, methods, objectArray);
    }

    @Override
    public void setRootPanel(RenderPanel renderPanel) {
        this.exec(Methods.setRootPanel, renderPanel);
    }

    @Override
    public RenderPanel getRootPanel() {
        return Native.manager.execGet(ARenderSurface.class, (INativeObject)this, Methods.getRootPanel, RenderPanel.class, new Object[0]);
    }

    @Override
    public void updateLayout() {
        this.exec(Methods.updateLayout, new Object[0]);
    }

    @Override
    public void setSize(int n, int n2) {
        this.exec(Methods.setSize, n, n2);
    }

    @Override
    public int getWidth() {
        return this.getSize().width;
    }

    @Override
    public int getHeight() {
        return this.getSize().height;
    }

    public Dimension getSize() {
        return Native.manager.exec(ARenderSurface.class, (INativeObject)this, (Enum)Methods.getSize, nb3dUtil::readDimension, new Object[0]);
    }

    public FPSTimer getFPSTimer() {
        return this.d_fpsTimer;
    }

    @Override
    public void pauseRender() {
        this.d_renderCounter.pauseRender();
    }

    @Override
    public void render() {
        this.d_renderCounter.render();
    }

    @Override
    public void render(Viewport viewport) {
        this.d_renderCounter.render(viewport);
    }

    @Override
    public void resumeRender() {
        this.d_renderCounter.resumeRender();
    }

    @Override
    public void resumeRender(boolean bl) {
        this.d_renderCounter.resumeRender(bl);
    }

    @Override
    public <T> void setProp(IPropertySet.Prop<T> prop, T t) {
        if (!(prop.key instanceof Integer)) {
            return;
        }
        Object object = t;
        if (prop == PROP_COMPRESS_SIZE4) {
            object = ((IRenderSurface.YesNoAuto)((Object)t)).ordinal();
        }
        this.exec(Methods.setProp, prop.key, object);
    }

    @Override
    public IRenderSurface.OpenGLInfo getOpenGLInfo() {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(ARenderSurface.class, (INativeObject)this, Methods.getOpenGLInfo, new Object[0]);
        Native.manager.flush();
        String string = Native.manager.readString();
        String string2 = Native.manager.readString();
        Supplier<IRenderSurface.VersionInfo> supplier = () -> {
            String string = Native.manager.readString();
            int n = Native.manager.readInt();
            int n2 = Native.manager.readInt();
            int n3 = Native.manager.readInt();
            String string2 = Native.manager.readString();
            return new IRenderSurface.VersionInfo(string, new IRenderSurface.Version(n, n2, n3), string2);
        };
        IRenderSurface.VersionInfo versionInfo = supplier.get();
        IRenderSurface.VersionInfo versionInfo2 = supplier.get();
        int n = Native.manager.readInt();
        IRenderSurface.OpenGLInfo openGLInfo = new IRenderSurface.OpenGLInfo(string, string2, versionInfo, versionInfo2, n);
        Native.manager.unlockWriteBuffer();
        return openGLInfo;
    }

    @Override
    public IRenderSurface.Adapter getAdapter() {
        int n = Native.manager.execGet(ARenderSurface.class, (INativeObject)this, Methods.getAdapter, Integer.class, new Object[0]);
        return IRenderSurface.Adapter.values()[n];
    }

    @Override
    public int testRenderCapabilities(int n) {
        return Native.manager.execGet(ARenderSurface.class, (INativeObject)this, Methods.testCapabilities, Integer.class, n);
    }

    private static enum Methods {
        updateLayout,
        setRootPanel,
        getRootPanel,
        setSize,
        getSize,
        setProp,
        getOpenGLInfo,
        getAdapter,
        testCapabilities;

    }
}

