/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.manip;

import java.awt.geom.NoninvertibleTransformException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.IMutableGeomSrc;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.IDisplayMgr;
import thunderheadeng.scene3d.manip.IManipListener;
import thunderheadeng.scene3d.manip.ManipEvent;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.Pair;

public class ManipMgr {
    private final IDisplayMgr<Object> d_dispMgr;
    private IMutableGeomSrc d_source;
    private IMutableGeomSrc d_sourceClone;
    private Collection<IHandle> d_handles;
    private IHandle d_currHandle;
    private ManipInfo d_manipInfo;
    private boolean d_modified;
    private final List<WeakReference<IManipListener>> d_listeners;

    public ManipMgr(IDisplayMgr<Object> iDisplayMgr) {
        this.d_dispMgr = iDisplayMgr;
        this.d_source = null;
        this.d_handles = Collections.EMPTY_LIST;
        this.d_currHandle = null;
        this.d_manipInfo = null;
        this.d_modified = false;
        this.d_listeners = new ArrayList<WeakReference<IManipListener>>();
    }

    public void addListener(IManipListener iManipListener) {
        Iterator<WeakReference<IManipListener>> iterator = this.d_listeners.iterator();
        while (iterator.hasNext()) {
            IManipListener iManipListener2 = (IManipListener)iterator.next().get();
            if (iManipListener2 == null) {
                iterator.remove();
                continue;
            }
            if (iManipListener2 != iManipListener) continue;
            return;
        }
        this.d_listeners.add(new WeakReference<IManipListener>(iManipListener));
    }

    public void removeListener(IManipListener iManipListener) {
        Iterator<WeakReference<IManipListener>> iterator = this.d_listeners.iterator();
        while (iterator.hasNext()) {
            IManipListener iManipListener2 = (IManipListener)iterator.next().get();
            if (iManipListener2 == null) {
                iterator.remove();
                continue;
            }
            if (iManipListener2 != iManipListener) continue;
            iterator.remove();
            break;
        }
    }

    public IManipListener[] getListeners() {
        ArrayList<IManipListener> arrayList = new ArrayList<IManipListener>(this.d_listeners.size());
        for (WeakReference<IManipListener> weakReference : this.d_listeners) {
            IManipListener iManipListener = (IManipListener)weakReference.get();
            if (iManipListener == null) continue;
            arrayList.add(iManipListener);
        }
        return arrayList.toArray(new IManipListener[arrayList.size()]);
    }

    protected void fireEvent(ManipEvent manipEvent) {
        for (IManipListener iManipListener : this.getListeners()) {
            iManipListener.manipChanged(manipEvent);
        }
    }

    public IDisplayMgr<Object> getDisplayMgr() {
        return this.d_dispMgr;
    }

    public IMutableGeomSrc getCurrentManipObj() {
        return this.d_source;
    }

    public IHandle getSelectedHandle() {
        return this.d_currHandle;
    }

    public void setSource(IMutableGeomSrc iMutableGeomSrc) {
        if (this.d_source == iMutableGeomSrc) {
            return;
        }
        IMutableGeomSrc iMutableGeomSrc2 = this.d_source;
        this.d_source = iMutableGeomSrc;
        this.updateSource(iMutableGeomSrc);
        this.fireEvent(ManipEvent.sourceChanged(this, iMutableGeomSrc2));
    }

    /*
     * WARNING - void declaration
     */
    public void updateSource(IMutableGeomSrc iMutableGeomSrc) {
        boolean bl = this.isManipulating();
        this.d_handles = Collections.EMPTY_LIST;
        IHandle iHandle = null;
        if (iMutableGeomSrc != null) {
            IHandle iHandle2 = this.d_currHandle;
            Collection<? extends IHandle> collection = ManipMgr.generateHandles(iMutableGeomSrc);
            this.d_handles = new ArrayList<IHandle>(collection.size());
            for (IHandle iHandle3 : collection) {
                void iHandle32;
                if (iHandle3.equals(iHandle2)) {
                    if (bl) {
                        IHandle iHandle4 = iHandle2;
                    }
                    iHandle = iHandle32;
                    iHandle2 = null;
                }
                this.d_handles.add((IHandle)iHandle32);
            }
        }
        this.fireEvent(ManipEvent.handlesModified(this));
        if (this.d_currHandle != iHandle) {
            if (bl && iHandle == null) {
                System.err.println("Lost current manip handle");
                this.end(false);
            }
            this.setSelectedHandle(iHandle);
        }
    }

    public Collection<IHandle> getCurrentHandles() {
        return this.d_handles;
    }

    public boolean canManipulate() {
        return this.d_source != null;
    }

    public boolean isManipulating() {
        return this.d_manipInfo != null;
    }

    public boolean isManipulating(Object object) {
        return this.isManipulating() && (this.d_source == object || this.d_sourceClone == object);
    }

    public Point3d getManipBegin() {
        return this.d_manipInfo != null ? this.d_manipInfo.origLoc : null;
    }

    public Point3d getManipLast() {
        return this.d_manipInfo != null ? this.d_manipInfo.lastLoc : null;
    }

    public ISnapConstraint getManipConstraint() {
        return this.d_manipInfo != null ? this.d_manipInfo.constraint : null;
    }

    public boolean isModified() {
        return this.d_modified;
    }

    public void setSelectedHandle(IHandle iHandle) {
        assert (iHandle == null || this.d_source != null && this.d_handles.contains(iHandle));
        if (this.d_currHandle == iHandle) {
            return;
        }
        IHandle iHandle2 = this.d_currHandle;
        this.d_currHandle = iHandle;
        this.fireEvent(ManipEvent.activeHandleChanged(this, iHandle2));
    }

    public void begin(Point3d point3d) {
        assert (this.d_source != null && this.d_currHandle != null);
        this.d_sourceClone = (IMutableGeomSrc)this.d_source.clone();
        this.d_dispMgr.addDisplays(Arrays.asList(this.d_sourceClone));
        this.d_dispMgr.removeFromScene(Arrays.asList(this.d_source));
        Point3d point3d2 = point3d;
        IGeomNode iGeomNode = this.d_sourceClone.getGeom();
        ISnapConstraint iSnapConstraint = this.d_currHandle.getConstraint(point3d2);
        this.d_currHandle.begin(point3d2, iSnapConstraint);
        this.d_manipInfo = new ManipInfo(iGeomNode, point3d2, iSnapConstraint);
        this.fireEvent(ManipEvent.manipStarted(this));
    }

    public void modify(Point3d point3d) throws ManipException {
        assert (this.isManipulating());
        this.d_manipInfo.lastLoc = point3d;
        Object object = this.d_currHandle.modify(point3d);
        if (object instanceof IGeomNode) {
            this.d_modified = true;
            IGeomNode iGeomNode = (IGeomNode)object;
            this.d_sourceClone.setGeom(iGeomNode);
            this.d_dispMgr.updateDisplays(Arrays.asList(this.d_sourceClone));
            this.updateSource(this.d_sourceClone);
        }
    }

    public void end(boolean bl) {
        assert (this.isManipulating());
        bl &= this.d_modified;
        this.d_modified = false;
        this.d_manipInfo = null;
        IGeomNode iGeomNode = null;
        Object object = this.d_currHandle.end();
        if (object instanceof IGeomNode) {
            iGeomNode = (IGeomNode)object;
        } else {
            bl = false;
        }
        this.d_dispMgr.removeDisplays(Arrays.asList(this.d_sourceClone));
        this.d_sourceClone = null;
        this.d_dispMgr.addToScene(Arrays.asList(this.d_source));
        this.fireEvent(ManipEvent.manipEnded(this, bl, iGeomNode));
        if (!bl) {
            this.updateSource(this.d_source);
        }
    }

    public static boolean canManipulate(IMutableGeomSrc iMutableGeomSrc) {
        return !ManipMgr.generateHandles(iMutableGeomSrc).isEmpty();
    }

    private static Collection<? extends IHandle> generateHandles(IMutableGeomSrc iMutableGeomSrc) {
        return ManipMgr.generateManipHandles(iMutableGeomSrc.getGeom());
    }

    private static Collection<? extends IHandle> generateManipHandles(IGeomNode iGeomNode) {
        IGeom iGeom = iGeomNode.getLocalGeom();
        if (!(iGeom instanceof IManipulatable)) {
            return Collections.EMPTY_LIST;
        }
        Collection<? extends IHandle> collection = ((IManipulatable)((Object)iGeom)).generateManipHandles();
        ArrayList<Handle> arrayList = new ArrayList<Handle>(collection.size());
        for (IHandle iHandle : collection) {
            arrayList.add(new Handle(iGeomNode, iHandle));
        }
        return arrayList;
    }

    protected static class ManipInfo {
        public final IGeomNode oldGeom;
        public final Point3d origLoc;
        public final ISnapConstraint constraint;
        public Point3d lastLoc;

        public ManipInfo(IGeomNode iGeomNode, Point3d point3d, ISnapConstraint iSnapConstraint) {
            this.oldGeom = iGeomNode;
            this.origLoc = point3d;
            this.constraint = iSnapConstraint;
            this.lastLoc = point3d;
        }
    }

    private static class Handle
    implements IHandle {
        private IGeomNode d_node;
        private final IHandle d_handle;
        private Matrix4d t_xform;
        private Matrix4d t_invXform;

        public Handle(IGeomNode iGeomNode, IHandle iHandle) {
            this.d_node = iGeomNode;
            this.d_handle = iHandle;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Handle && ((Handle)object).d_handle.equals(this.d_handle);
        }

        @Override
        public IGeomNode getGeom() {
            return this.d_handle.getGeom().quickTransform(this.d_node.getLocalTransform().getInfo());
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return this.d_handle.getPickFilter();
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            try {
                this.t_invXform = this.d_node.getLocalTransform().invert().toMatrix(false);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
                this.t_invXform = GeomConstants.IDENTITY4d;
            }
            this.t_xform = this.d_node.getLocalTransform().toMatrix(false);
            point3d = Util3D.xform(this.t_invXform, point3d);
            ISnapConstraint iSnapConstraint = this.d_handle.getConstraint(point3d);
            return iSnapConstraint == null ? iSnapConstraint : iSnapConstraint.transform(this.t_xform);
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
            assert (this.t_invXform != null && this.t_xform != null);
            point3d = Util3D.xform(this.t_invXform, point3d);
            iSnapConstraint = iSnapConstraint == null ? iSnapConstraint : iSnapConstraint.transform(this.t_invXform);
            this.d_handle.begin(point3d, iSnapConstraint);
        }

        @Override
        public Object modify(Point3d point3d) throws ManipException {
            point3d = Util3D.xform(this.t_invXform, point3d);
            Object object = this.d_handle.modify(point3d);
            this.d_node = this.modify(object);
            return this.d_node;
        }

        @Override
        public Object end() {
            this.d_node = this.modify(this.d_handle.end());
            this.t_invXform = null;
            this.t_xform = null;
            return this.d_node;
        }

        private IGeomNode modify(Object object) {
            if (object instanceof IGeom) {
                return this.d_node.applyLocalGeom((IGeom)object);
            }
            return this.d_node;
        }
    }
}

