/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.manip;

import thunderheadeng.geometry.IMutableGeomSrc;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.manip.ManipMgr;

public class ManipEvent {
    private final ManipMgr d_mgr;
    private final Type d_type;
    private final boolean d_committed;
    private final IGeomNode d_newNode;
    private final IHandle d_oldHandle;
    private final IMutableGeomSrc d_oldSource;

    public static ManipEvent manipStarted(ManipMgr manipMgr) {
        return new ManipEvent(manipMgr, Type.MANIP_STARTED, false, null, null, null);
    }

    public static ManipEvent handlesModified(ManipMgr manipMgr) {
        return new ManipEvent(manipMgr, Type.HANDLES_MODIFIED, false, null, null, null);
    }

    public static ManipEvent manipEnded(ManipMgr manipMgr, boolean bl, IGeomNode iGeomNode) {
        return new ManipEvent(manipMgr, Type.MANIP_ENDED, bl, iGeomNode, null, null);
    }

    public static ManipEvent sourceChanged(ManipMgr manipMgr, IMutableGeomSrc iMutableGeomSrc) {
        return new ManipEvent(manipMgr, Type.SOURCE_CHANGED, false, null, null, iMutableGeomSrc);
    }

    public static ManipEvent activeHandleChanged(ManipMgr manipMgr, IHandle iHandle) {
        return new ManipEvent(manipMgr, Type.ACTIVE_HANDLE_CHANGED, false, null, iHandle, null);
    }

    private ManipEvent(ManipMgr manipMgr, Type type, boolean bl, IGeomNode iGeomNode, IHandle iHandle, IMutableGeomSrc iMutableGeomSrc) {
        this.d_mgr = manipMgr;
        this.d_type = type;
        this.d_committed = bl;
        this.d_newNode = iGeomNode;
        this.d_oldHandle = iHandle;
        this.d_oldSource = iMutableGeomSrc;
    }

    public ManipMgr getSource() {
        return this.d_mgr;
    }

    public Type getType() {
        return this.d_type;
    }

    public boolean isCommitted() {
        return this.d_committed;
    }

    public IHandle getOldHandle() {
        return this.d_oldHandle;
    }

    public IMutableGeomSrc getOldSource() {
        return this.d_oldSource;
    }

    public IGeomNode getNewNode() {
        return this.d_newNode;
    }

    public static enum Type {
        MANIP_STARTED,
        MANIP_ENDED,
        HANDLES_MODIFIED,
        SOURCE_CHANGED,
        ACTIVE_HANDLE_CHANGED;

    }
}

