/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.gui;

import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import thunderheadeng.Intl;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.format.UDListFormat;
import thunderheadeng.gui.guiFormattedFld;
import thunderheadeng.scene3d.gui.IOffset;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.theUtil;

public class ValueEditorUtil {
    public static final String LOCATION = "LOCATION";
    public static final String OFFSET = "OFFSET";
    public static final int OFFSET_DISTANCE = 0;
    public static final int OFFSET_RELATIVE = 1;
    public static final int OFFSET_ABSOLUTE = 2;

    public static void configureLocation(ValueEditor valueEditor, IUnitSrc iUnitSrc, String string) {
        valueEditor.addChoice(LOCATION, new ValueEditor.Choice(0, string, new guiFormattedFld<Object>(new UDListFormat(iUnitSrc, 3, 3), null)));
    }

    public static void configureOffset(ValueEditor valueEditor, IUnitSrc iUnitSrc, String string, String string2, String string3) {
        if (string != null) {
            valueEditor.addChoice(OFFSET, new ValueEditor.Choice(0, string, ValueFields.udFld(iUnitSrc)));
        }
        if (string2 != null) {
            valueEditor.addChoice(OFFSET, new ValueEditor.Choice(1, string2, new guiFormattedFld<Object>(new UDListFormat(iUnitSrc, 3, 3), null)));
        }
        if (string3 != null) {
            valueEditor.addChoice(OFFSET, new ValueEditor.Choice(2, string3, new guiFormattedFld<Object>(new UDListFormat(iUnitSrc, 3, 3), null)));
        }
    }

    public static void configure(ValueEditor valueEditor, IUnitSrc iUnitSrc, String ... stringArray) {
        if (ValueEditorUtil.contains(stringArray, LOCATION)) {
            ValueEditorUtil.configureLocation(valueEditor, iUnitSrc, Intl.intl("First Point (x,y,z)"));
        }
        if (ValueEditorUtil.contains(stringArray, OFFSET)) {
            ValueEditorUtil.configureOffset(valueEditor, iUnitSrc, Intl.intl("Distance"), Intl.intl("Relative Offset (x,y,z)"), Intl.intl("Absolute Position (x,y,z)"));
        }
    }

    private static boolean contains(Object[] objectArray, Object object) {
        for (Object object2 : objectArray) {
            if (!theUtil.equal(object2, object)) continue;
            return true;
        }
        return false;
    }

    public static Point3d getLocation(ValueEditor valueEditor, Unit unit) {
        String string = valueEditor.getCurrentValueType();
        if (LOCATION.equals(string)) {
            UnitDouble[] unitDoubleArray = (UnitDouble[])valueEditor.getValue();
            if (unitDoubleArray == null) {
                return null;
            }
            return new UnitPoint3D(unitDoubleArray).getPoint3dValue(unit);
        }
        return null;
    }

    public static void setLocation(ValueEditor valueEditor, Point3d point3d, Unit unit) {
        UnitDouble[] unitDoubleArray = new UnitDouble[]{new UnitDouble(point3d.x, unit), new UnitDouble(point3d.y, unit), new UnitDouble(point3d.z, unit)};
        valueEditor.setValue(unitDoubleArray);
    }

    public static IOffset getOffset(ValueEditor valueEditor) {
        String string = valueEditor.getCurrentValueType();
        if (OFFSET.equals(string)) {
            if (valueEditor.getCurrentChoiceId() == 0) {
                UnitDouble unitDouble = (UnitDouble)valueEditor.getValue();
                return unitDouble == null ? null : new IOffset.Distance(unitDouble);
            }
            boolean bl = valueEditor.getCurrentChoiceId() == 1;
            UnitDouble[] unitDoubleArray = (UnitDouble[])valueEditor.getValue();
            if (unitDoubleArray == null || unitDoubleArray.length < 3) {
                return null;
            }
            UnitPoint3D unitPoint3D = new UnitPoint3D(unitDoubleArray[0], unitDoubleArray[1], unitDoubleArray[2]);
            return new IOffset.DirOffset(unitPoint3D, bl);
        }
        return null;
    }

    public static void setOffset(ValueEditor valueEditor, IOffset iOffset, boolean bl) {
        valueEditor.setValueType(OFFSET);
        if (iOffset instanceof IOffset.Distance) {
            valueEditor.setValue(((IOffset.Distance)iOffset).dist, 0, bl);
        } else if (iOffset instanceof IOffset.DirOffset) {
            IOffset.DirOffset dirOffset = (IOffset.DirOffset)iOffset;
            int n = dirOffset.relative ? 1 : 2;
            UnitDouble[] unitDoubleArray = new UnitDouble[]{dirOffset.offset.xu(), dirOffset.offset.yu(), dirOffset.offset.zu()};
            valueEditor.setValue(unitDoubleArray, n, bl);
        }
    }
}

