/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.gui;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.function.Supplier;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;

public class GPUInfoPnl
extends guiPanel {
    public GPUInfoPnl(Supplier<IRenderSurface.OpenGLInfo> supplier, boolean bl) {
        Color color = new Color(0, 0, 0, 0);
        this.setBackground(color);
        IRenderSurface.OpenGLInfo openGLInfo = supplier.get();
        JButton jButton = new JButton(Intl.intl("Copy"), guiUtil.loadTeciIcon("Copy16.gif"));
        jButton.setMaximumSize(jButton.getSize());
        jButton.setToolTipText(Intl.intl("Copies the GPU information."));
        guiPanel guiPanel2 = new guiPanel();
        guiPanel2.setBackground(color);
        GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2);
        gridBagHelper.addRow(Intl.intl("Vendor:"), openGLInfo.vendor);
        gridBagHelper.addRow(Intl.intl("Renderer:"), openGLInfo.renderer);
        gridBagHelper.addRow(Intl.intl("OpenGL Version:"), openGLInfo.version.versionStr);
        gridBagHelper.addRow(Intl.intl("GLSL Version:"), openGLInfo.glslVersion.versionStr);
        if (!bl) {
            gridBagHelper.addRow(jButton, 0);
        }
        gridBagHelper.finalizeRows();
        if (bl) {
            gridBagHelper = new GridBagHelper(this, false, 18, 0);
            gridBagHelper.add(new Object[]{guiPanel2, jButton, GridBagHelper.Anchor.RIGHT});
            gridBagHelper.finalizeRows();
        } else {
            this.add(guiPanel2);
        }
        jButton.addActionListener(actionEvent -> {
            try {
                String string = String.format("Vendor: %s\nRenderer: %s\nOpenGL Version: %s\nGLSL Version: %s", openGLInfo.vendor, openGLInfo.renderer, openGLInfo.version.versionStr, openGLInfo.glslVersion.versionStr);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, stringSelection);
            }
            catch (IllegalStateException illegalStateException) {
                guiUtil.showError(SwingUtilities.getWindowAncestor(jButton), Intl.intl("Cannot Copy"), Intl.intl("Cannot copy"), (Throwable)illegalStateException);
                return;
            }
        });
    }
}

