/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import thunderheadeng.image.IImage;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.theUtil;

public class Texture
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final IPropertySet.Prop<Boolean> PROP_CACHE_IN_STREAM = new IPropertySet.Prop<Boolean>("Texture.CACHE_IN_STREAM", false);
    public static final String DEFAULT_UVSET_NAME = "uvset";
    public final IImage image;
    public final Mode mode;
    public final Wrap wrap;
    public final Color borderColor;
    public final String uvSet;

    public Texture(IImage iImage, Mode mode, Wrap wrap, Color color, String string) {
        assert (!wrap.requiresBorderColor || color != null);
        assert (!Objects.equals(string, "teciuv0x193fa"));
        this.mode = mode;
        this.image = iImage;
        this.wrap = wrap;
        this.borderColor = color;
        this.uvSet = string;
    }

    public static Texture clampedToEdge(IImage iImage, Mode mode, String string) {
        return new Texture(iImage, mode, Wrap.CLAMP_TO_EDGE, null, string);
    }

    public static Texture clampedToEdge(IImage iImage, String string) {
        return Texture.clampedToEdge(iImage, Mode.MODULATE, string);
    }

    public static Texture clampedToBorder(IImage iImage, Mode mode, Color color, String string) {
        return new Texture(iImage, mode, Wrap.CLAMP, color, string);
    }

    public static Texture clampedToBorder(IImage iImage, Color color, String string) {
        return Texture.clampedToBorder(iImage, Mode.MODULATE, color, string);
    }

    public static Texture repeated(IImage iImage, Mode mode, String string) {
        return new Texture(iImage, mode, Wrap.REPEAT, null, string);
    }

    public static Texture repeated(IImage iImage, String string) {
        return Texture.repeated(iImage, Mode.MODULATE, string);
    }

    public Texture apply(IImage iImage) {
        if (iImage == this.image) {
            return this;
        }
        return new Texture(iImage, this.mode, this.wrap, this.borderColor, this.uvSet);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Texture && this.mode == ((Texture)object).mode && this.wrap == ((Texture)object).wrap && Texture.borderColorsEqual(this, (Texture)object) && this.image.equals(((Texture)object).image) && Objects.equals(this.uvSet, ((Texture)object).uvSet);
    }

    public int hashCode() {
        return 107099379 + this.image.hashCode() + this.mode.hashCode() + this.wrap.hashCode() + Texture.borderColorHash(this) + this.uvSet.hashCode();
    }

    private static boolean borderColorsEqual(Texture texture, Texture texture2) {
        return !texture.wrap.requiresBorderColor || theUtil.equal(texture.borderColor, texture2.borderColor);
    }

    private static int borderColorHash(Texture texture) {
        return !texture.wrap.requiresBorderColor ? 0 : theUtil.hashCode(texture.borderColor);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(1);
        objectOutputStream.writeObject((Object)this.mode);
        objectOutputStream.writeObject((Object)this.wrap);
        objectOutputStream.writeObject(this.borderColor);
        boolean bl = objectOutputStream instanceof IPropertySet && ((IPropertySet)((Object)objectOutputStream)).get(PROP_CACHE_IN_STREAM) != false;
        IImage iImage = bl ? this.image.cacheImage() : this.image;
        objectOutputStream.writeObject(iImage);
        objectOutputStream.writeObject(this.uvSet);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        try {
            Object object;
            theUtil.assignFinalField(this, Texture.class, "mode", objectInputStream.readObject());
            theUtil.assignFinalField(this, Texture.class, "wrap", objectInputStream.readObject());
            theUtil.assignFinalField(this, Texture.class, "borderColor", objectInputStream.readObject());
            theUtil.assignFinalField(this, Texture.class, "image", objectInputStream.readObject());
            Object object2 = object = n >= 1 ? objectInputStream.readObject() : DEFAULT_UVSET_NAME;
            if (Objects.equals(object, "teciuv0x193fa")) {
                object = DEFAULT_UVSET_NAME;
            }
            theUtil.assignFinalField(this, Texture.class, "uvSet", object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException(illegalAccessException.getCause());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IOException(noSuchFieldException.getCause());
        }
    }

    public static enum Wrap {
        CLAMP(true),
        CLAMP_TO_EDGE(false),
        REPEAT(false);

        public boolean requiresBorderColor;

        private Wrap(boolean bl) {
            this.requiresBorderColor = bl;
        }
    }

    public static enum Mode {
        MODULATE,
        REPLACE,
        DECAL,
        BLEND;

    }
}

