/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import thunderheadeng.scene3d.geom.FlattenedProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsSubList;
import thunderheadeng.scene3d.geom.UniformProps;

public class PropsBuilder
implements IPropsSrc {
    static final long serialVersionUID = 1L;
    private final ArrayList<Object> d_props = new ArrayList();
    private final ArrayList<RangeEntry> d_ranges = new ArrayList();

    @Override
    public IPropsSrc subset(int n, int n2) {
        if (n == 0 && n2 == this.size()) {
            return this;
        }
        if (n2 == 1) {
            return new UniformProps(this.get(n));
        }
        int n3 = n + n2 - 1;
        RangeEntry rangeEntry = this.getPreviousRangeEntry(n);
        if (rangeEntry != null && n <= rangeEntry.gmax && n3 <= rangeEntry.gmax) {
            return new UniformProps(rangeEntry.props);
        }
        return new PropsSubList(this, n, n2);
    }

    public void add(IPropsSrc iPropsSrc, int n) {
        if (iPropsSrc instanceof UniformProps) {
            this.add(iPropsSrc.get(0), n);
        } else if (iPropsSrc instanceof PropsBuilder) {
            PropsBuilder propsBuilder = (PropsBuilder)iPropsSrc;
            int n2 = n;
            for (Object object : propsBuilder.d_props) {
                if (n2 != 0) {
                    if (object instanceof IPrimProps) {
                        this.add((IPrimProps)object);
                        --n2;
                        continue;
                    }
                    RangeEntry rangeEntry = (RangeEntry)object;
                    int n3 = Math.min(n2, rangeEntry.gmax - rangeEntry.gmin + 1);
                    this.add(rangeEntry.props, n3);
                    n2 -= n3;
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.add(iPropsSrc.get(i));
            }
        }
    }

    public void add(IPrimProps iPrimProps) {
        this.add(iPrimProps, 1);
    }

    public void add(IPrimProps iPrimProps, int n) {
        if (n <= 0) {
            return;
        }
        if (!this.d_props.isEmpty()) {
            Object object = this.d_props.get(this.d_props.size() - 1);
            if (object instanceof RangeEntry) {
                if (((RangeEntry)object).props.equals(iPrimProps)) {
                    RangeEntry rangeEntry = (RangeEntry)object;
                    rangeEntry.gmax += n;
                    return;
                }
            } else if (object.equals(iPrimProps)) {
                int n2 = this.size();
                RangeEntry rangeEntry = new RangeEntry(iPrimProps, n2 - 1, n2 + n - 1, this.d_props.size() - 1);
                this.d_props.set(rangeEntry.lix, rangeEntry);
                this.d_ranges.add(rangeEntry);
                return;
            }
        }
        if (n == 1) {
            this.d_props.add(iPrimProps);
        } else {
            int n3 = this.d_props.size();
            int n4 = this.size();
            int n5 = n4 + n - 1;
            RangeEntry rangeEntry = new RangeEntry(iPrimProps, n4, n5, n3);
            this.d_ranges.add(rangeEntry);
            this.d_props.add(rangeEntry);
        }
    }

    @Override
    public IPrimProps[] flatten(int n) {
        IPrimProps[] iPrimPropsArray = new IPrimProps[n];
        int n2 = 0;
        for (Object object : this.d_props) {
            if (n2 >= n) break;
            if (object instanceof IPrimProps) {
                iPrimPropsArray[n2++] = (IPrimProps)object;
                continue;
            }
            RangeEntry rangeEntry = (RangeEntry)object;
            int n3 = Math.min(rangeEntry.gmax, n - 1);
            while (n2 <= n3) {
                iPrimPropsArray[n2] = rangeEntry.props;
                ++n2;
            }
        }
        return iPrimPropsArray;
    }

    public int size() {
        if (this.d_ranges.isEmpty()) {
            return this.d_props.size();
        }
        RangeEntry rangeEntry = this.d_ranges.get(this.d_ranges.size() - 1);
        int n = this.d_props.size() - rangeEntry.lix;
        return rangeEntry.gmax + n;
    }

    protected int getLocalIx(int n) {
        int n2 = this.getPreviousRangeEntryIx(n);
        if (n2 == -1) {
            return n;
        }
        RangeEntry rangeEntry = this.d_ranges.get(n2);
        if (n <= rangeEntry.gmax) {
            return rangeEntry.lix;
        }
        return n - rangeEntry.gmax + rangeEntry.lix;
    }

    @Override
    public IPrimProps get(int n) {
        int n2 = this.getLocalIx(n);
        Object object = this.d_props.get(n2);
        return object instanceof RangeEntry ? ((RangeEntry)object).props : (IPrimProps)object;
    }

    @Override
    public int getUniformCount(int n, int n2) {
        return Math.min(this.getUniformCount(n), n2);
    }

    public int getUniformCount(int n) {
        RangeEntry rangeEntry = this.getPreviousRangeEntry(n);
        if (rangeEntry != null && n < rangeEntry.gmax) {
            return rangeEntry.gmax - n + 1;
        }
        return 1;
    }

    private RangeEntry getPreviousRangeEntry(int n) {
        int n2 = this.getPreviousRangeEntryIx(n);
        return n2 < 0 ? null : this.d_ranges.get(n2);
    }

    private int getPreviousRangeEntryIx(int n) {
        if (this.d_ranges.isEmpty()) {
            return -1;
        }
        int n2 = Collections.binarySearch(this.d_ranges, n);
        if (n2 < 0) {
            if ((n2 = -n2 - 1) == 0) {
                return -1;
            }
            --n2;
        }
        return n2;
    }

    public IPropsSrc finalizeProps() {
        if (this.d_props.size() == 1) {
            Object object = this.d_props.get(0);
            IPrimProps iPrimProps = object instanceof RangeEntry ? ((RangeEntry)object).props : (IPrimProps)object;
            return new UniformProps(iPrimProps);
        }
        if (this.d_ranges.isEmpty()) {
            IPrimProps[] iPrimPropsArray = new IPrimProps[this.d_props.size()];
            for (int i = 0; i < iPrimPropsArray.length; ++i) {
                iPrimPropsArray[i] = (IPrimProps)this.d_props.get(i);
            }
            return new FlattenedProps(iPrimPropsArray);
        }
        this.d_props.trimToSize();
        this.d_ranges.trimToSize();
        return this;
    }

    @Override
    public Iterator<IPrimProps> iterator() {
        final int n = this.size();
        return new Iterator<IPrimProps>(){
            private int d_ix = 0;
            private int d_entryIx = 0;

            @Override
            public boolean hasNext() {
                return this.d_ix < n;
            }

            @Override
            public IPrimProps next() {
                ++this.d_ix;
                Object e = PropsBuilder.this.d_props.get(this.d_entryIx);
                if (e instanceof RangeEntry) {
                    RangeEntry rangeEntry = (RangeEntry)e;
                    if (this.d_ix > rangeEntry.gmax) {
                        ++this.d_entryIx;
                    }
                    return rangeEntry.props;
                }
                ++this.d_entryIx;
                return (IPrimProps)e;
            }
        };
    }

    private static class RangeEntry
    implements Comparable<Integer>,
    Serializable {
        static final long serialVersionUID = 1L;
        public final IPrimProps props;
        public final int gmin;
        public int gmax;
        public final int lix;

        public RangeEntry(IPrimProps iPrimProps, int n, int n2, int n3) {
            this.props = iPrimProps;
            this.gmin = n;
            this.gmax = n2;
            this.lix = n3;
        }

        @Override
        public int compareTo(Integer n) {
            return this.gmin - n;
        }
    }
}

