/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.elem.AInfiniteElems;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;

public class PlanarCoordMapper
extends AInfiniteElems<Point2d>
implements Serializable {
    static final long serialVersionUID = 1L;
    private final Function<IMaterial, Point2d> d_matSize;
    private final Point3d d_texOrigin;

    public PlanarCoordMapper(Function<IMaterial, Point2d> function, Point3d point3d) {
        this.d_matSize = function;
        this.d_texOrigin = point3d;
    }

    @Override
    protected Point2d getDefVal() {
        return new Point2d();
    }

    @Override
    public void generate(Class<Point2d> clazz, List<? extends IPrimitive> list, IElemSource<Elements.Orient> iElemSource, IPropsSrc iPropsSrc, Consumer<Point2d> consumer) {
        int n = list.size();
        int n2 = iPropsSrc.getUniformCount(0, n);
        if (n2 == n) {
            Point2d point2d = this.d_matSize.apply(iPropsSrc.get(0).getMaterial());
            double d = 1.0 / point2d.x;
            double d2 = 1.0 / point2d.y;
            for (int i = 0; i < list.size(); ++i) {
                IPrimitive iPrimitive = list.get(i);
                if (!(iPrimitive instanceof IPolygon)) continue;
                this.generate((IPolygon)iPrimitive, iElemSource.getPrimElement(i), d, d2, consumer);
            }
        } else {
            Iterator<IPrimProps> iterator = iPropsSrc.iterator();
            for (int i = 0; i < list.size(); ++i) {
                IPrimitive iPrimitive = list.get(i);
                if (!(iPrimitive instanceof IPolygon)) continue;
                this.generate((IPolygon)iPrimitive, iElemSource.getPrimElement(i), iterator.next(), consumer);
            }
        }
    }

    private void generate(IPolygon iPolygon, Elements.Orient orient, IPrimProps iPrimProps, Consumer<Point2d> consumer) {
        Point2d point2d = this.d_matSize.apply(iPrimProps.getMaterial());
        double d = 1.0 / point2d.x;
        double d2 = 1.0 / point2d.y;
        this.generate(iPolygon, orient, d, d2, consumer);
    }

    private void generate(IPolygon iPolygon, Elements.Orient orient, double d, double d2, Consumer<Point2d> consumer) {
        Vector3d[] vector3dArray = PlanarCoordMapper.generateLocalVecs(iPolygon.getNormal(orient == Elements.Orient.CCW));
        int n = iPolygon.getNumLoops();
        for (int i = 0; i < n; ++i) {
            int n2 = iPolygon.getNumPoints(i);
            for (int j = 0; j < n2; ++j) {
                Point3d point3d = iPolygon.getPoint(i, j);
                consumer.accept(PlanarCoordMapper.generateTexUV(this.d_texOrigin, d, d2, vector3dArray[0], vector3dArray[1], point3d));
            }
        }
    }

    @Override
    public ElementMesh<Point2d> generate(Class<Point2d> clazz, IPrimitive iPrimitive, Elements.Orient orient, Mesh mesh, IPrimProps iPrimProps) {
        if (mesh.primtype != 2 && mesh.primtype != 3) {
            return null;
        }
        Point3d[] point3dArray = new Point3d[3];
        List<Point3d> list = Arrays.asList(point3dArray);
        boolean bl = orient == Elements.Orient.CCW;
        Vector3d vector3d = new Vector3d(0.0, 0.0, 0.0);
        int n = 0;
        while (n < mesh.indices.length) {
            point3dArray[0] = mesh.vertices[mesh.indices[n++]];
            point3dArray[1] = mesh.vertices[mesh.indices[n++]];
            point3dArray[2] = mesh.vertices[mesh.indices[n++]];
            Vector3d vector3d2 = Util3D.simplePolygonNormal(list, bl);
            if (vector3d2 == null) continue;
            vector3d.add(vector3d2);
        }
        double d = vector3d.length();
        if (d > 0.0) {
            int n2 = mesh.getNumPrims(1);
            vector3d.scale(1 / n2);
            vector3d.normalize();
        } else {
            vector3d = GeomConstants.VEC3D_ZPOS;
        }
        Vector3d[] vector3dArray = PlanarCoordMapper.generateLocalVecs(vector3d);
        Point2d point2d = this.d_matSize.apply(iPrimProps.getMaterial());
        double d2 = 1.0 / point2d.x;
        double d3 = 1.0 / point2d.y;
        Point2d[] point2dArray = new Point2d[mesh.vertices.length];
        for (int i = 0; i < mesh.vertices.length; ++i) {
            Point3d point3d = mesh.vertices[i];
            point2dArray[i] = PlanarCoordMapper.generateTexUV(this.d_texOrigin, d2, d3, vector3dArray[0], vector3dArray[1], point3d);
        }
        return new ElementMesh<Point2d>(ElementMesh.Mapping.PER_PRIM_VERTEX, point2dArray, mesh.indices, mesh.getNumVertsPerPrim());
    }

    private static Point2d generateTexUV(Point3d point3d, double d, double d2, Vector3d vector3d, Vector3d vector3d2, Point3d point3d2) {
        double d3 = point3d2.x - point3d.x;
        double d4 = point3d2.y - point3d.y;
        double d5 = point3d2.z - point3d.z;
        double d6 = vector3d.x * d3 + vector3d.y * d4 + vector3d.z * d5;
        double d7 = vector3d2.x * d3 + vector3d2.y * d4 + vector3d2.z * d5;
        return new Point2d(d6 * d, d7 * d2);
    }

    private static Vector3d[] generateLocalVecs(Vector3d vector3d) {
        Vector3d vector3d2;
        if (vector3d.x == 0.0 && vector3d.y == 0.0) {
            vector3d2 = new Vector3d(1.0, 0.0, 0.0);
        } else {
            vector3d2 = new Vector3d(-vector3d.y, vector3d.x, 0.0);
            vector3d2.normalize();
        }
        Vector3d vector3d3 = Util3D.cross(vector3d, vector3d2);
        vector3d3.normalize();
        return new Vector3d[]{vector3d2, vector3d3};
    }
}

