/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import thunderheadeng.image.HashableImage;
import thunderheadeng.image.IImage;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;

public class MatUtil {
    public static boolean isSupported(IMatAttrs iMatAttrs, MatChannel matChannel) {
        return iMatAttrs.getColor(matChannel) != null || iMatAttrs.getTexture(matChannel) != null;
    }

    public static MatChannel[] getSupportedChannels(IMatAttrs iMatAttrs) {
        ArrayList<MatChannel> arrayList = new ArrayList<MatChannel>(MatChannel.values().length);
        for (MatChannel matChannel : MatChannel.values()) {
            if (!MatUtil.isSupported(iMatAttrs, matChannel)) continue;
            arrayList.add(matChannel);
        }
        return arrayList.toArray(new MatChannel[arrayList.size()]);
    }

    public static Pair<Color, Texture> getChannel(IMatAttrs iMatAttrs, MatChannel matChannel) {
        return new Pair<Color, Texture>(iMatAttrs.getColor(matChannel), iMatAttrs.getTexture(matChannel));
    }

    public static Set<String> getUVSets(IMatAttrs iMatAttrs) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (MatChannel matChannel : MatChannel.values()) {
            Texture texture = iMatAttrs.getTexture(matChannel);
            if (texture == null) continue;
            linkedHashSet.add(texture.uvSet);
        }
        return linkedHashSet;
    }

    public static IMatAttrs makeImagesHashable(IMatAttrs iMatAttrs) {
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        for (IPropertySet.Prop prop : IMatAttrs.ALL) {
            arrayList.add(prop);
            Object object = iMatAttrs.get(prop);
            if (object instanceof Texture) {
                object = MatUtil.makeImageHashable((Texture)object);
                bl = true;
            }
            arrayList.add(object);
        }
        if (!bl) {
            return iMatAttrs;
        }
        return new MatAttrs(theUtil.toArray(arrayList, Object.class));
    }

    public static Texture makeImageHashable(Texture texture) {
        if (texture.image instanceof HashableImage) {
            return texture;
        }
        return texture.apply(new HashableImage(texture.image));
    }

    public static IMatAttrs.MatProp<Texture> newTexProp(Object object, String string) {
        TypedProp<String> typedProp = new TypedProp<String>((Object)string, String.class);
        TypedProp<String> typedProp2 = new TypedProp<String>((Object)(string + ".uvSet"), "uvset");
        return new IMatAttrs.MatProp<Texture>(object, null, (teciProps, function, texture) -> {
            String string;
            if (texture != null && texture.image != null && (string = (String)function.apply(texture.image)) != null) {
                teciProps.set(typedProp, string);
                teciProps.set(typedProp2, texture.uvSet);
            }
        }, (teciProps, function) -> {
            String string = (String)teciProps.get(typedProp);
            String string2 = (String)teciProps.get(typedProp2);
            if (string2.equals("teciuv0x193fa")) {
                string2 = "uvset";
            }
            if (string == null || string.isEmpty()) {
                return null;
            }
            IImage iImage = (IImage)function.apply(string);
            if (iImage == null) {
                return null;
            }
            return Texture.repeated(iImage, string2);
        });
    }

    public static IMatAttrs.MatProp<Color> newColorProp(Object object, String string, Color color2) {
        TypedProp<Integer> typedProp = new TypedProp<Integer>((Object)string, Integer.class);
        return new IMatAttrs.MatProp<Color>(object, color2, (teciProps, function, color) -> {
            if (color != null) {
                teciProps.set(typedProp, Integer.valueOf(MatUtil.encodeARGB(color)));
            }
        }, (teciProps, function) -> {
            Integer n = (Integer)teciProps.get(typedProp);
            if (n == null) {
                return color2;
            }
            return new Color(n, true);
        });
    }

    public static <T> IMatAttrs.MatProp<T> newProp(Object object, String string, T t) {
        return MatUtil.newProp(object, new TypedProp<T>((Object)string, t));
    }

    public static <T> IMatAttrs.MatProp<T> newProp(Object object, String string, Class<T> clazz) {
        return MatUtil.newProp(object, new TypedProp<T>((Object)string, clazz));
    }

    private static <T> IMatAttrs.MatProp<T> newProp(Object object2, TypedProp<T> typedProp) {
        return new IMatAttrs.MatProp<Object>(object2, typedProp.defVal, (teciProps, function, object) -> teciProps.set(typedProp, object), (teciProps, function) -> teciProps.get(typedProp));
    }

    private static int encodeARGB(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        return n4 << 24 & 0xFF000000 | n << 16 & 0xFF0000 | n2 << 8 & 0xFF00 | n3 << 0 & 0xFF;
    }
}

