/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.theUtil;

public class MatAttrs
implements IMatAttrs,
Serializable {
    static final long serialVersionUID = 1L;
    private final PropertySet d_props;

    public MatAttrs() {
        this(Collections.emptyList());
    }

    public MatAttrs(Color color, Texture texture, double d) {
        this(color, texture, d, (Texture)IMatAttrs.NORMAL.defVal);
    }

    public MatAttrs(Color color, Texture texture, double d, Texture texture2) {
        this(color, texture, d, (Color)IMatAttrs.SPECULAR_COLOR.defVal, (Texture)IMatAttrs.SPECULAR_TEXTURE.defVal, (Double)IMatAttrs.SPECULAR_FADE.defVal, texture2, (Integer)IMatAttrs.OPTIONS.defVal);
    }

    public MatAttrs(Color color, Texture texture, double d, Color color2, Texture texture2, double d2, Texture texture3, int n) {
        this(DIFFUSE_COLOR, color, DIFFUSE_TEXTURE, texture, DIFFUSE_FADE, d, SPECULAR_COLOR, color2, SPECULAR_TEXTURE, texture2, SPECULAR_FADE, d2, NORMAL, texture3, OPTIONS, n);
    }

    public MatAttrs(Object ... objectArray) {
        this(Arrays.asList(objectArray));
    }

    public MatAttrs(List<Object> list) {
        assert (list.size() % 2 == 0);
        this.d_props = new PropertySet();
        for (int i = 0; i < list.size(); i += 2) {
            this.d_props.setIfNotDefault((IPropertySet.Prop)list.get(i + 0), list.get(i + 1));
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IMatAttrs)) {
            return false;
        }
        IMatAttrs iMatAttrs = (IMatAttrs)object;
        return this.compare((IPropertySet)iMatAttrs, ALL);
    }

    public int hashCode() {
        return this.hash(ALL);
    }

    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void remove(IPropertySet.Prop<T> prop) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    @Override
    public <T> boolean isDefined(IPropertySet.Prop<T> prop) {
        return this.d_props.isDefined(prop);
    }

    public <T> MatAttrs apply(IPropertySet.Prop<T> prop, T t) {
        MatAttrs matAttrs = new MatAttrs();
        matAttrs.d_props.merge((IPropertySet)this.d_props, ALL);
        matAttrs.d_props.setIfNotDefault(prop, t);
        return matAttrs;
    }

    public <T> MatAttrs apply(Object ... objectArray) {
        assert (objectArray.length % 2 == 0);
        MatAttrs matAttrs = new MatAttrs();
        matAttrs.d_props.merge((IPropertySet)this.d_props, ALL);
        for (int i = 0; i < objectArray.length; i += 2) {
            matAttrs.d_props.setIfNotDefault((IPropertySet.Prop)objectArray[i + 0], objectArray[i + 1]);
        }
        return matAttrs;
    }

    public <T> MatAttrs applyColor(MatChannel matChannel, Color color) {
        MatAttrs matAttrs = new MatAttrs();
        matAttrs.d_props.merge((IPropertySet)this.d_props, ALL);
        switch (matChannel) {
            case DIFFUSE: {
                matAttrs.d_props.setIfNotDefault(DIFFUSE_COLOR, color);
                break;
            }
            case EMISSIVE: {
                matAttrs.d_props.setIfNotDefault(EMISSIVE_COLOR, color);
                break;
            }
            case OPACITY: {
                matAttrs.d_props.setIfNotDefault(OPACITY_COLOR, color);
                break;
            }
            case REFLECTION: {
                matAttrs.d_props.setIfNotDefault(REFLECTION_COLOR, color);
                break;
            }
            case SPECULAR: {
                matAttrs.d_props.setIfNotDefault(SPECULAR_COLOR, color);
            }
        }
        return matAttrs;
    }

    public <T> MatAttrs applyFade(MatChannel matChannel, double d) {
        MatAttrs matAttrs = new MatAttrs();
        matAttrs.d_props.merge((IPropertySet)this.d_props, ALL);
        switch (matChannel) {
            case DIFFUSE: {
                matAttrs.d_props.setIfNotDefault(DIFFUSE_FADE, d);
                break;
            }
            case EMISSIVE: {
                matAttrs.d_props.setIfNotDefault(EMISSIVE_FADE, d);
                break;
            }
            case OPACITY: {
                matAttrs.d_props.setIfNotDefault(OPACITY_FADE, d);
                break;
            }
            case REFLECTION: {
                matAttrs.d_props.setIfNotDefault(REFLECTION_FADE, d);
                break;
            }
            case SPECULAR: {
                matAttrs.d_props.setIfNotDefault(SPECULAR_FADE, d);
            }
        }
        return matAttrs;
    }

    public <T> MatAttrs applyTexture(MatChannel matChannel, Texture texture) {
        MatAttrs matAttrs = new MatAttrs();
        matAttrs.d_props.merge((IPropertySet)this.d_props, ALL);
        switch (matChannel) {
            case BUMP: {
                matAttrs.d_props.setIfNotDefault(BUMP, texture);
                break;
            }
            case DIFFUSE: {
                matAttrs.d_props.setIfNotDefault(DIFFUSE_TEXTURE, texture);
                break;
            }
            case EMISSIVE: {
                matAttrs.d_props.setIfNotDefault(EMISSIVE_TEXTURE, texture);
                break;
            }
            case NORMAL: {
                matAttrs.d_props.setIfNotDefault(NORMAL, texture);
                break;
            }
            case OPACITY: {
                matAttrs.d_props.setIfNotDefault(OPACITY_TEXTURE, texture);
                break;
            }
            case REFLECTION: {
                matAttrs.d_props.setIfNotDefault(REFLECTION_TEXTURE, texture);
                break;
            }
            case SPECULAR: {
                matAttrs.d_props.setIfNotDefault(SPECULAR_TEXTURE, texture);
            }
        }
        return matAttrs;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_props == null) {
            try {
                theUtil.assignFinalField(this, MatAttrs.class, "d_props", new PropertySet());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public MatAttrs applyColorToDiffuseAndOpacity(Color color) {
        int n = 255;
        if (color != null && color.getAlpha() != 255) {
            n = color.getAlpha();
            color = new Color(color.getRed(), color.getGreen(), color.getBlue());
        }
        return this.apply(IMatAttrs.DIFFUSE_COLOR, color, IMatAttrs.OPACITY_COLOR, new Color(n, n, n));
    }
}

