/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.util.theUtil;

public interface IPrimProps
extends Serializable {
    public static final int DEF_STIPPLE = Edge.makeStipple(1, (short)-1);
    public static final IPrimProps DEF = new GenericProps(Color.BLACK, null, 1.0, DEF_STIPPLE, 1.0, 0);
    public static final int OPT_SELECTED = 1;
    public static final int OPT_CULLFACE = 2;
    public static final int FACE_OPTIONS = 3;
    public static final int EDGE_OPTIONS = 1;
    public static final int VERT_OPTIONS = 1;

    public int getOptions();

    public boolean testOptions(int var1);

    public IPrimProps setOptions(int var1);

    public Color getColor();

    public IPrimProps setColor(Color var1);

    public IMaterial getMaterial();

    public IPrimProps setMaterial(IMaterial var1);

    public double getEdgeWidth();

    public IPrimProps setEdgeWidth(double var1);

    public int getEdgeStipple();

    public IPrimProps setEdgeStipple(int var1);

    public double getPointSize();

    public IPrimProps setPointSize(double var1);

    public int hashCode();

    public boolean equals(Object var1);

    public static class Vertex
    extends AProps {
        static final long serialVersionUID = 1L;
        public final double pointSize;

        public Vertex(Color color, double d) {
            this(color, d, 0);
        }

        public Vertex(Color color, double d, int n) {
            super(color, n);
            this.pointSize = d;
        }

        @Override
        public double getPointSize() {
            return this.pointSize;
        }

        @Override
        public Vertex setPointSize(double d) {
            return new Vertex(this.color, d, this.options);
        }

        @Override
        public Vertex setColor(Color color) {
            return new Vertex(color, this.pointSize, this.options);
        }

        @Override
        public Vertex setOptions(int n) {
            return new Vertex(this.color, this.pointSize, n);
        }
    }

    public static class Edge
    extends AProps {
        static final long serialVersionUID = 1L;
        public final double edgeWidth;
        public final int stipple;

        public Edge(Color color, double d, int n, int n2) {
            super(color, n2);
            assert (n != 0);
            this.stipple = n;
            this.edgeWidth = d;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.stipple == 0) {
                try {
                    theUtil.assignFinalField(this, Edge.class, "stipple", DEF_STIPPLE);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        @Override
        public int getEdgeStipple() {
            return this.stipple;
        }

        @Override
        public double getEdgeWidth() {
            return this.edgeWidth;
        }

        @Override
        public Edge setEdgeWidth(double d) {
            return new Edge(this.color, d, this.stipple, this.options);
        }

        @Override
        public IPrimProps setEdgeStipple(int n) {
            return new Edge(this.color, this.edgeWidth, n, this.options);
        }

        @Override
        public Edge setColor(Color color) {
            return new Edge(color, this.edgeWidth, this.stipple, this.options);
        }

        @Override
        public Edge setOptions(int n) {
            return new Edge(this.color, this.edgeWidth, this.stipple, n);
        }

        public static int makeStipple(int n, short s) {
            return n << 16 | s & 0xFFFF;
        }
    }

    public static class Face
    extends AProps {
        static final long serialVersionUID = 1L;
        public final IMaterial material;

        public Face(Color color, IMaterial iMaterial, int n) {
            super(color, n);
            this.material = iMaterial;
        }

        @Override
        public IMaterial getMaterial() {
            return this.material;
        }

        @Override
        public Face setMaterial(IMaterial iMaterial) {
            return new Face(this.color, iMaterial, this.options);
        }

        @Override
        public Face setColor(Color color) {
            return new Face(color, this.material, this.options);
        }

        @Override
        public Face setOptions(int n) {
            return new Face(this.color, this.material, n);
        }
    }

    public static class GenericProps
    extends AProps {
        static final long serialVersionUID = 1L;
        public final IMaterial material;
        public final double edgeWidth;
        public final double pointSize;
        public final int edgeStipple;

        public GenericProps(Color color, IMaterial iMaterial, double d, int n, double d2, int n2) {
            super(color, n2);
            assert (n != 0);
            this.material = iMaterial;
            this.edgeWidth = d;
            this.edgeStipple = n;
            this.pointSize = d2;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.edgeStipple == 0) {
                try {
                    theUtil.assignFinalField(this, GenericProps.class, "edgeStipple", DEF_STIPPLE);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        @Override
        public IMaterial getMaterial() {
            return this.material;
        }

        @Override
        public double getEdgeWidth() {
            return this.edgeWidth;
        }

        @Override
        public int getEdgeStipple() {
            return this.edgeStipple;
        }

        @Override
        public double getPointSize() {
            return this.pointSize;
        }

        @Override
        public GenericProps setColor(Color color) {
            return new GenericProps(color, this.material, this.edgeWidth, this.edgeStipple, this.pointSize, this.options);
        }

        @Override
        public GenericProps setOptions(int n) {
            return new GenericProps(this.color, this.material, this.edgeWidth, this.edgeStipple, this.pointSize, n);
        }

        public IPrimProps optimize(int n) {
            return GenericProps.optimize(this, n);
        }

        public static IPrimProps optimize(IPrimProps iPrimProps, int n) {
            switch (n) {
                case 1: {
                    return iPrimProps instanceof Face ? iPrimProps : new Face(iPrimProps.getColor(), iPrimProps.getMaterial(), iPrimProps.getOptions() & 3);
                }
                case 2: {
                    return iPrimProps instanceof Edge ? iPrimProps : new Edge(iPrimProps.getColor(), iPrimProps.getEdgeWidth(), iPrimProps.getEdgeStipple(), iPrimProps.getOptions() & 1);
                }
                case 4: {
                    return iPrimProps instanceof Vertex ? iPrimProps : new Vertex(iPrimProps.getColor(), iPrimProps.getPointSize(), iPrimProps.getOptions() & 1);
                }
            }
            return iPrimProps;
        }
    }

    public static abstract class AProps
    implements IPrimProps {
        static final long serialVersionUID = 1L;
        public final Color color;
        public final byte options;

        public AProps(Color color, int n) {
            this.color = color;
            this.options = (byte)n;
        }

        @Override
        public int hashCode() {
            return 5387087 + theUtil.hashCode(this.getOptions()) + theUtil.hashCode(this.getEdgeWidth()) + theUtil.hashCode(this.getPointSize()) + theUtil.hashCode(this.getColor()) + theUtil.hashCode(this.getMaterial()) + theUtil.hashCode(this.getEdgeStipple());
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof IPrimProps)) {
                return false;
            }
            IPrimProps iPrimProps = (IPrimProps)object;
            return this.getOptions() == iPrimProps.getOptions() && this.getEdgeWidth() == iPrimProps.getEdgeWidth() && this.getEdgeStipple() == iPrimProps.getEdgeStipple() && this.getPointSize() == iPrimProps.getPointSize() && theUtil.equal(this.getColor(), iPrimProps.getColor()) && theUtil.equal(this.getMaterial(), iPrimProps.getMaterial());
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        @Override
        public boolean testOptions(int n) {
            return (this.options & n) == n;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        @Override
        public IMaterial getMaterial() {
            return null;
        }

        @Override
        public double getEdgeWidth() {
            return 1.0;
        }

        @Override
        public int getEdgeStipple() {
            return DEF_STIPPLE;
        }

        @Override
        public double getPointSize() {
            return 1.0;
        }

        @Override
        public IPrimProps setMaterial(IMaterial iMaterial) {
            return new GenericProps(this.color, iMaterial, this.getEdgeWidth(), this.getEdgeStipple(), this.getPointSize(), this.options);
        }

        @Override
        public IPrimProps setEdgeWidth(double d) {
            return new GenericProps(this.color, this.getMaterial(), d, this.getEdgeStipple(), this.getPointSize(), this.options);
        }

        @Override
        public IPrimProps setEdgeStipple(int n) {
            return new GenericProps(this.color, this.getMaterial(), this.getEdgeWidth(), n, this.getPointSize(), this.options);
        }

        @Override
        public IPrimProps setPointSize(double d) {
            return new GenericProps(this.color, this.getMaterial(), this.getEdgeWidth(), this.getEdgeStipple(), d, this.options);
        }
    }
}

