/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import java.util.ArrayList;
import java.util.Collection;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.ElementsBuilder;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.FlattenedProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.util.IPropertySet;

public class DisplayGeomBuilder {
    public static final Rep EMPTY_REP = new Rep(EmptyGeom.INSTANCE, Elements.NONE, new FlattenedProps(new IPrimProps[0]));
    private final ArrayList<IGeom> d_geoms = new ArrayList();
    private final PropsBuilder d_props = new PropsBuilder();
    private final ElementsBuilder d_elements = new ElementsBuilder();

    public void add(Rep rep) {
        this.add(rep.geom, rep.props, rep.elements);
    }

    public void add(IGeom iGeom, IPrimProps iPrimProps, IPropertySet iPropertySet) {
        this.add(iGeom, new UniformProps(iPrimProps), iPropertySet);
    }

    public void add(IGeom iGeom, IPropsSrc iPropsSrc, IPropertySet iPropertySet) {
        if (iGeom == EmptyGeom.INSTANCE) {
            return;
        }
        int n = iGeom.getNumPrims(7);
        if (n == 0) {
            return;
        }
        this.d_geoms.add(iGeom);
        this.d_props.add(iPropsSrc, n);
        this.d_elements.add(iPropertySet, n);
    }

    public Rep finish() {
        IGeom iGeom = GeomUtil.group(this.d_geoms);
        if (iGeom == EmptyGeom.INSTANCE) {
            return EMPTY_REP;
        }
        IPropsSrc iPropsSrc = this.d_props.finalizeProps();
        IPropertySet iPropertySet = this.d_elements.finish();
        return new Rep(iGeom, iPropertySet, iPropsSrc);
    }

    public static Rep merge(Collection<Rep> collection) {
        if (collection.isEmpty()) {
            return EMPTY_REP;
        }
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        Rep rep = null;
        DisplayGeomBuilder displayGeomBuilder = null;
        for (Rep rep2 : collection) {
            if (rep2 == EMPTY_REP) continue;
            if (rep == null) {
                rep = rep2;
                continue;
            }
            if (displayGeomBuilder == null) {
                displayGeomBuilder = new DisplayGeomBuilder();
                displayGeomBuilder.add(rep);
            }
            displayGeomBuilder.add(rep2);
        }
        if (displayGeomBuilder == null && rep == null) {
            return EMPTY_REP;
        }
        if (displayGeomBuilder == null) {
            return rep;
        }
        return displayGeomBuilder.finish();
    }

    public static class Rep {
        public final IGeom geom;
        public final IPropsSrc props;
        public final IPropertySet elements;

        public Rep(IGeom iGeom, IPropertySet iPropertySet, IPropsSrc iPropsSrc) {
            this.geom = iGeom;
            this.props = iPropsSrc;
            this.elements = iPropertySet;
        }

        public DisplayGeom toDisplay() {
            if (this.geom == EmptyGeom.INSTANCE) {
                return DisplayGeom.EMPTY;
            }
            return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(this.geom, this.elements), this.props);
        }
    }
}

