/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.geom.FlattenedProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.UniformProps;

public class DisplayGeom {
    public static final DisplayGeom EMPTY = new DisplayGeom(GeomNodeUtil.EMPTY_NODE, new FlattenedProps(new IPrimProps[0]));
    public final IGeomNode node;
    public final IPropsSrc props;

    public DisplayGeom(IGeomNode iGeomNode, IPropsSrc iPropsSrc) {
        this.node = iGeomNode;
        this.props = iPropsSrc;
    }

    public DisplayGeom(IGeomNode iGeomNode, IPrimProps iPrimProps) {
        this(iGeomNode, new UniformProps(iPrimProps));
    }

    public DisplayGeom(IGeomNode iGeomNode, IPrimProps ... iPrimPropsArray) {
        this(iGeomNode, new FlattenedProps(iPrimPropsArray));
    }

    public DisplayGeom transform(TransformInfo transformInfo) {
        IGeomNode iGeomNode = this.node.transform(transformInfo);
        if (iGeomNode == this.node) {
            return this;
        }
        return new DisplayGeom(iGeomNode, this.props);
    }

    public DisplayGeom quickTransform(TransformInfo transformInfo) {
        IGeomNode iGeomNode = this.node.quickTransform(transformInfo);
        if (iGeomNode == this.node) {
            return this;
        }
        return new DisplayGeom(iGeomNode, this.props);
    }
}

