/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d;

import java.awt.Color;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPlanarFace;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.legacy.v1.util.LinkedIdentityHashMap;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ListMap;

public class GeomWriter {
    public static boolean ADVANCED_PARAMS_ENABLED = false;
    public static int CURR_VERSION = Version.curr().ordinal();
    private static final IMatAttrs s_defAttrs = new MatAttrs();

    public static void write(ObjectOutput objectOutput, IGeomNode iGeomNode, IPropsSrc iPropsSrc, double d, double d2) throws IOException {
        objectOutput.writeInt(0);
        objectOutput.writeInt(0);
        objectOutput.writeInt(0);
        objectOutput.writeInt(0);
        GeomWriter.writeNode(objectOutput, TransformUtil.IDENTITY, iGeomNode, iPropsSrc, 0, d, d2);
        objectOutput.writeInt(GeomType.GT_END.ordinal());
    }

    private static int writeNode(ObjectOutput objectOutput, ITransform iTransform, IGeomNode iGeomNode, IPropsSrc iPropsSrc, int n, double d, double d2) throws IOException {
        TransformInfo transformInfo = iTransform.concatenate(iGeomNode.getLocalTransform()).getInfo();
        IGeom iGeom = iGeomNode.getLocalGeom();
        IPropertySet iPropertySet = iGeomNode.getLocalElements();
        n = GeomWriter.writeGeom(objectOutput, iGeom, transformInfo, iPropsSrc, n, iPropertySet, d, d2);
        for (IGeomNode iGeomNode2 : iGeomNode.getChildren()) {
            n = GeomWriter.writeNode(objectOutput, transformInfo.xform, iGeomNode2, iPropsSrc, n, d, d2);
        }
        return n;
    }

    private static int writeGeom(ObjectOutput objectOutput, IGeom iGeom, TransformInfo transformInfo, IPropsSrc iPropsSrc, int n, IPropertySet iPropertySet, double d, double d2) throws IOException {
        iGeom = iGeom.transform(transformInfo, 0);
        iPropertySet = Elements.transform(iPropertySet, transformInfo);
        ElementSources elementSources = new ElementSources(iPropertySet, iGeom.getNumPrims(7));
        return GeomWriter.writeGeom(objectOutput, iGeom, iPropsSrc, n, elementSources, d, d2);
    }

    private static int writeGeom(ObjectOutput objectOutput, IGeom iGeom, IPropsSrc iPropsSrc, int n, ElementSources elementSources, double d, double d2) throws IOException {
        if (iGeom instanceof Point) {
            GeomWriter.writePoint(objectOutput, (Point)iGeom, iPropsSrc.get(n++));
        } else if (iGeom instanceof LineSeg) {
            GeomWriter.writeLineSeg(objectOutput, (LineSeg)iGeom, iPropsSrc.get(n++));
        } else if (iGeom instanceof PolyLine) {
            GeomWriter.writeLineStrip(objectOutput, (PolyLine)iGeom, iPropsSrc.get(n++));
        } else if (iGeom instanceof Triangle) {
            GeomWriter.writeTriangle(objectOutput, (Triangle)iGeom, iPropsSrc.get(n), elementSources);
            ++n;
        } else if (iGeom instanceof Quad) {
            GeomWriter.writeQuad(objectOutput, (Quad)iGeom, iPropsSrc.get(n), elementSources);
            ++n;
        } else if (iGeom instanceof IPlanarFace) {
            GeomWriter.writePoly(objectOutput, ((IPlanarFace)iGeom).toPoly(d), iPropsSrc.get(n), elementSources);
            ++n;
        } else if (iGeom instanceof Mesh) {
            n = GeomWriter.writeMesh(objectOutput, (Mesh)iGeom, iPropsSrc, n, elementSources, null);
        } else if (iGeom instanceof ICurve) {
            Mesh mesh = ((ICurve)iGeom).getSegments(d);
            n = GeomWriter.writeMesh(objectOutput, mesh, iPropsSrc, n, elementSources, (ICurve)iGeom);
        } else if (iGeom instanceof IFace) {
            Mesh mesh = ((IFace)iGeom).triangulate(d2);
            n = GeomWriter.writeMesh(objectOutput, mesh, iPropsSrc, n, elementSources, (IFace)iGeom);
        } else if (iGeom.canExplode()) {
            int n2 = 0;
            for (IGeom iGeom2 : iGeom.explode(new ArrayList<IGeom>())) {
                int n3 = iGeom2.getNumPrims(7);
                ElementSources elementSources2 = elementSources.sublist(n2, n3);
                n = GeomWriter.writeGeom(objectOutput, iGeom2, iPropsSrc, n, elementSources2, d, d2);
                n2 += n3;
            }
        } else {
            assert (iGeom.getNumPrims(7) == 0);
            n += iGeom.getNumPrims(7);
        }
        return n;
    }

    private static List<Point2d> generateUVDiffuse(IPolygon iPolygon, IPrimProps iPrimProps, ElementSources elementSources) {
        Texture texture;
        Texture texture2 = texture = iPrimProps.getMaterial() != null ? iPrimProps.getMaterial().getAttributes().get(IMatAttrs.DIFFUSE_TEXTURE) : null;
        if (texture != null) {
            IElemSource<Point2d> iElemSource = elementSources.getUV(texture.uvSet);
            return GeomWriter.generateElements(iPolygon, iPrimProps, elementSources, Point2d.class, iElemSource, Elements.NO_UV);
        }
        return Collections.emptyList();
    }

    private static List<Vector3d> generateNormals(IPolygon iPolygon, IPrimProps iPrimProps, ElementSources elementSources) {
        return GeomWriter.generateElements(GeomWriter.needsNormals(true), iPolygon, iPrimProps, elementSources, Elements.NORMAL, Elements.NO_NORMAL);
    }

    private static List<Boolean> generateCreases(IPolygon iPolygon, IPrimProps iPrimProps, ElementSources elementSources) {
        return GeomWriter.generateElements(GeomWriter.needsCreases(true), iPolygon, iPrimProps, elementSources, Elements.CREASE, null);
    }

    private static List<Elements.Orient> generateOrients(IPolygon iPolygon, IPrimProps iPrimProps, ElementSources elementSources) {
        return GeomWriter.generateElements(GeomWriter.needsOrients(true), iPolygon, iPrimProps, elementSources, Elements.ORIENT, null);
    }

    private static <ElemT> List<ElemT> generateElements(boolean bl, IPolygon iPolygon, IPrimProps iPrimProps, ElementSources elementSources, Elements.ElemProp<ElemT> elemProp, IElemSource<ElemT> iElemSource) {
        if (bl) {
            IElemSource<ElemT> iElemSource2 = elementSources.get(elemProp);
            return GeomWriter.generateElements(iPolygon, iPrimProps, elementSources, elemProp.type, iElemSource2, iElemSource);
        }
        return Collections.EMPTY_LIST;
    }

    private static <ElemT> List<ElemT> generateElements(IPolygon iPolygon, IPrimProps iPrimProps, ElementSources elementSources, Class<ElemT> clazz, IElemSource<ElemT> iElemSource, IElemSource<ElemT> iElemSource2) {
        if (iElemSource == iElemSource2) {
            return Collections.emptyList();
        }
        ElementMesh<ElemT> elementMesh = iElemSource.generate(clazz, Collections.singletonList(iPolygon), elementSources.get(Elements.ORIENT), new UniformProps(iPrimProps), PolyUtil.getNumVerts(iPolygon), false);
        if (elementMesh.mapping == ElementMesh.Mapping.ALL_SAME) {
            return Collections.singletonList(elementMesh.getPrimVertElement(0, 0));
        }
        return elementMesh;
    }

    private static void writePoint(ObjectOutput objectOutput, Point point, IPrimProps iPrimProps) throws IOException {
        GeomWriter.beginGeom(objectOutput, point, GeomType.GT_POINT.ordinal(), iPrimProps);
        GeomWriter.writeTuple3d(objectOutput, point.loc);
    }

    private static void writeLineSeg(ObjectOutput objectOutput, LineSeg lineSeg, IPrimProps iPrimProps) throws IOException {
        GeomWriter.beginGeom(objectOutput, lineSeg, GeomType.GT_LINESEG.ordinal(), iPrimProps);
        GeomWriter.write((DataOutput)objectOutput, lineSeg.p1, lineSeg.p2);
    }

    private static void writeLineStrip(ObjectOutput objectOutput, PolyLine polyLine, IPrimProps iPrimProps) throws IOException {
        GeomWriter.beginGeom(objectOutput, polyLine, GeomType.GT_LINE_STRIP.ordinal(), iPrimProps);
        GeomWriter.writeArray((DataOutput)objectOutput, polyLine.verts);
    }

    private static void beginPoly(ObjectOutput objectOutput, GeomType geomType, IPolygon iPolygon, IPrimProps iPrimProps, ElementSources elementSources) throws IOException {
        objectOutput.writeInt(geomType.ordinal());
        GeomWriter.writeTuple2dList(objectOutput, GeomWriter.generateUVDiffuse(iPolygon, iPrimProps, elementSources));
        GeomWriter.writeTuple3dList(objectOutput, GeomWriter.generateNormals(iPolygon, iPrimProps, elementSources));
        GeomWriter.writeBooleanList(objectOutput, GeomWriter.generateCreases(iPolygon, iPrimProps, elementSources));
        List<Elements.Orient> list = GeomWriter.generateOrients(iPolygon, iPrimProps, elementSources);
        Elements.Orient orient = list.isEmpty() ? Elements.Orient.CCW : list.get(0);
        GeomWriter.writeOrient(objectOutput, orient);
        GeomWriter.writeMeta(objectOutput, iPolygon, iPrimProps);
    }

    private static void writeTriangle(ObjectOutput objectOutput, Triangle triangle, IPrimProps iPrimProps, ElementSources elementSources) throws IOException {
        GeomWriter.beginPoly(objectOutput, GeomType.GT_TRIANGLE, triangle, iPrimProps, elementSources);
        GeomWriter.write((DataOutput)objectOutput, triangle.p1, triangle.p2, triangle.p3);
    }

    private static void writeQuad(ObjectOutput objectOutput, Quad quad, IPrimProps iPrimProps, ElementSources elementSources) throws IOException {
        GeomWriter.beginPoly(objectOutput, GeomType.GT_QUAD, quad, iPrimProps, elementSources);
        GeomWriter.write((DataOutput)objectOutput, quad.p1, quad.p2, quad.p3, quad.p4);
    }

    private static void writePoly(ObjectOutput objectOutput, IPolygon iPolygon, IPrimProps iPrimProps, ElementSources elementSources) throws IOException {
        GeomWriter.beginPoly(objectOutput, GeomType.GT_POLYGON, iPolygon, iPrimProps, elementSources);
        objectOutput.writeInt(iPolygon.getNumLoops());
        for (int i = 0; i < iPolygon.getNumLoops(); ++i) {
            objectOutput.writeInt(iPolygon.getNumPoints(i));
            for (int j = 0; j < iPolygon.getNumPoints(i); ++j) {
                Point3d point3d = iPolygon.getPoint(i, j);
                GeomWriter.writeTuple3d(objectOutput, point3d);
            }
        }
    }

    private static int writeMesh(ObjectOutput objectOutput, Mesh mesh, IPropsSrc iPropsSrc, int n, ElementSources elementSources, IPrimitive iPrimitive) throws IOException {
        Serializable serializable;
        Serializable serializable2;
        int n2;
        objectOutput.writeInt(GeomType.GT_MESH.ordinal());
        boolean bl = GeomWriter.isFaceType(mesh);
        boolean bl2 = mesh.testFlag(2);
        objectOutput.writeBoolean(bl2);
        switch (mesh.primtype) {
            case 0: {
                objectOutput.writeInt(GeomType.GT_POINT.ordinal());
                break;
            }
            case 1: {
                objectOutput.writeInt(GeomType.GT_LINESEG.ordinal());
                break;
            }
            case 2: {
                objectOutput.writeInt(GeomType.GT_TRIANGLE.ordinal());
                break;
            }
            case 3: {
                objectOutput.writeInt(GeomType.GT_QUAD.ordinal());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        boolean bl3 = false;
        int n3 = mesh.getNumPrims(7);
        int n4 = iPrimitive != null ? 1 : n3;
        LinkedIdentityHashMap<IPrimProps, Integer> linkedIdentityHashMap = new LinkedIdentityHashMap<IPrimProps, Integer>();
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int n5 = n4 + n;
        for (int i = n; i < n5; i += n2) {
            serializable2 = iPropsSrc.get(i);
            n2 = iPropsSrc.getUniformCount(i, n5 - i);
            assert (n2 > 0);
            serializable = (Integer)linkedIdentityHashMap.get(serializable2);
            if (serializable == null) {
                serializable = linkedIdentityHashMap.size();
                linkedIdentityHashMap.put((IPrimProps)serializable2, (Integer)serializable);
            }
            arrayList.add(new int[]{n2, serializable});
            bl3 = bl3 || bl && GeomWriter.needsTexUV(serializable2);
        }
        GeomWriter.writeArray((DataOutput)objectOutput, mesh.vertices);
        GeomWriter.writeArray((DataOutput)objectOutput, mesh.indices);
        IPropsSrc iPropsSrc2 = iPropsSrc.subset(n, n4);
        if (n4 != n3 && !(iPropsSrc2 instanceof UniformProps)) {
            iPropsSrc2 = new UniformProps(iPropsSrc2.get(0));
        }
        serializable2 = GeomWriter.getUVElements(bl3, elementSources, iPrimitive, mesh, iPropsSrc2, n3);
        ElementMesh<Vector3d> elementMesh = GeomWriter.getElements(GeomWriter.needsNormals(bl), elementSources, Elements.NORMAL, Elements.NO_NORMAL, iPrimitive, mesh, iPropsSrc2, n3);
        serializable = GeomWriter.getElements(GeomWriter.needsCreases(bl), elementSources, Elements.CREASE, null, iPrimitive, mesh, iPropsSrc2, n3);
        ElementMesh<Elements.Orient> elementMesh2 = GeomWriter.getElements(GeomWriter.needsOrients(bl), elementSources, Elements.ORIENT, null, iPrimitive, mesh, iPropsSrc2, n3);
        GeomWriter.writeElements(objectOutput, mesh.indices, serializable2, (dataOutput, point2dArray) -> GeomWriter.writeArray(dataOutput, point2dArray));
        GeomWriter.writeElements(objectOutput, mesh.indices, elementMesh, (dataOutput, vector3dArray) -> GeomWriter.writeArray(dataOutput, vector3dArray));
        GeomWriter.writeElements(objectOutput, mesh.indices, serializable, (dataOutput, booleanArray) -> GeomWriter.writeArray(dataOutput, booleanArray));
        GeomWriter.writeElements(objectOutput, mesh.indices, elementMesh2, (dataOutput, orientArray) -> GeomWriter.writeArray(dataOutput, orientArray));
        objectOutput.writeInt(linkedIdentityHashMap.size());
        for (Object object : linkedIdentityHashMap.keySet()) {
            GeomWriter.writeMeta(objectOutput, mesh, (IPrimProps)object);
        }
        objectOutput.writeInt(n4);
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object object;
            for (Object object2 : object = (Object)((int[])iterator.next())) {
                objectOutput.writeInt((int)object2);
            }
        }
        return n + n4;
    }

    private static <ElemT> ElementMesh<ElemT> getElements(boolean bl, ElementSources elementSources, Elements.ElemProp<ElemT> elemProp, IElemSource<ElemT> iElemSource, IPrimitive iPrimitive, Mesh mesh, IPropsSrc iPropsSrc, int n) {
        return GeomWriter.getElements(bl, elementSources, elemProp.type, () -> elementSources.get(elemProp), iElemSource, iPrimitive, mesh, iPropsSrc, n);
    }

    private static <ElemT> ElementMesh<ElemT> getElements(boolean bl, ElementSources elementSources, Class<ElemT> clazz, Supplier<IElemSource<ElemT>> supplier, IElemSource<ElemT> iElemSource, IPrimitive iPrimitive, Mesh mesh, IPropsSrc iPropsSrc, int n) {
        if (!bl) {
            return null;
        }
        IElemSource<Elements.Orient> iElemSource2 = elementSources.get(Elements.ORIENT);
        IElemSource<ElemT> iElemSource3 = supplier.get();
        if (iElemSource3 == iElemSource) {
            return null;
        }
        if (iPrimitive != null) {
            return iElemSource3.generate(clazz, iPrimitive, iElemSource2.getPrimElement(0), mesh, iPropsSrc.get(0));
        }
        assert (GeomWriter.isFaceType(mesh));
        return iElemSource3.generate(clazz, mesh.getPrimitives(), iElemSource2, iPropsSrc, mesh.getNumVertsPerPrim(), false);
    }

    private static ElementMesh<Point2d> getUVElements(boolean bl, ElementSources elementSources, IPrimitive iPrimitive, Mesh mesh, IPropsSrc iPropsSrc, int n) {
        if (!bl) {
            return null;
        }
        if (elementSources.isUniformUV() || iPrimitive != null) {
            Supplier supplier = elementSources.isUniformUV() ? () -> elementSources.getUniformUV() : () -> {
                Texture texture;
                IPrimProps iPrimProps = iPropsSrc.get(0);
                Texture texture2 = texture = iPrimProps.getMaterial() != null ? iPrimProps.getMaterial().getAttributes().get(IMatAttrs.DIFFUSE_TEXTURE) : null;
                if (texture == null) {
                    return Elements.NO_UV;
                }
                return elementSources.getUV(texture.uvSet);
            };
            return GeomWriter.getElements(bl, elementSources, Point2d.class, supplier, Elements.NO_UV, iPrimitive, mesh, iPropsSrc, n);
        }
        ListMap<String, ElementMesh> listMap = new ListMap<String, ElementMesh>();
        Function<String, ElementMesh> function = string -> GeomWriter.getElements(bl, elementSources, Point2d.class, () -> {
            IElemSource<Point2d> iElemSource = elementSources.uvsublists.get(string);
            if (iElemSource == null) {
                return Elements.NO_UV;
            }
            return iElemSource;
        }, Elements.NO_UV, iPrimitive, mesh, iPropsSrc, n);
        Point2d point2d = new Point2d(0.0, 0.0);
        Point2d[] point2dArray = new Point2d[mesh.indices.length];
        Iterator<IPrimProps> iterator = iPropsSrc.iterator();
        int n2 = mesh.getNumVertsPerPrim();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Texture texture;
            IPrimProps iPrimProps = iterator.next();
            Texture texture2 = texture = iPrimProps.getMaterial() != null ? iPrimProps.getMaterial().getAttributes().get(IMatAttrs.DIFFUSE_TEXTURE) : null;
            if (texture != null) {
                ElementMesh elementMesh = listMap.computeIfAbsent(texture.uvSet, function);
                if (elementMesh == null && (elementMesh = listMap.computeIfAbsent("teciuv0x193fa", function)) == null && !elementSources.uvsublists.isEmpty()) {
                    elementMesh = listMap.computeIfAbsent(elementSources.uvsublists.keySet().iterator().next(), function);
                }
                if (elementMesh != null) {
                    for (int j = 0; j < n2; ++j) {
                        point2dArray[n3] = (Point2d)elementMesh.get(n3);
                        ++n3;
                    }
                    continue;
                }
            }
            for (int j = 0; j < n2; ++j) {
                point2dArray[n3++] = point2d;
            }
        }
        return new ElementMesh<Point2d>(ElementMesh.Mapping.PER_PRIM_VERTEX, point2dArray, n2);
    }

    private static boolean isFaceType(Mesh mesh) {
        return mesh.primtype == 3 || mesh.primtype == 2;
    }

    private static boolean needsNormals(boolean bl) {
        return bl;
    }

    private static boolean needsCreases(boolean bl) {
        return bl;
    }

    private static boolean needsOrients(boolean bl) {
        return bl;
    }

    private static boolean needsTexUV(IPrimProps iPrimProps) {
        IMaterial iMaterial = iPrimProps.getMaterial();
        if (iMaterial == null) {
            return false;
        }
        IMatAttrs iMatAttrs = iMaterial.getAttributes();
        for (MatChannel matChannel : MatChannel.values()) {
            if (iMatAttrs.getTexture(matChannel) == null) continue;
            return true;
        }
        return false;
    }

    private static <T> void writeElements(ObjectOutput objectOutput, int[] nArray, ElementMesh<T> elementMesh, ThrowableBiConsumer<DataOutput, T[]> throwableBiConsumer) throws IOException {
        ElemMapping elemMapping;
        objectOutput.writeBoolean(elementMesh != null);
        if (elementMesh == null) {
            return;
        }
        switch (elementMesh.mapping) {
            case ALL_SAME: {
                elemMapping = ElemMapping.EM_ALL_SAME;
                break;
            }
            case PER_PRIM: {
                elemMapping = ElemMapping.EM_PER_FACE;
                break;
            }
            case PER_PRIM_VERTEX: {
                elemMapping = ElemMapping.EM_PER_INDEX;
                break;
            }
            default: {
                elemMapping = ElemMapping.EM_NONE;
            }
        }
        objectOutput.writeInt(elemMapping.ordinal());
        throwableBiConsumer.accept(objectOutput, elementMesh.elements);
        boolean bl = nArray != elementMesh.indices;
        objectOutput.writeBoolean(bl);
        if (bl) {
            GeomWriter.writeArray((DataOutput)objectOutput, elementMesh.indices);
        }
    }

    private static void beginGeom(ObjectOutput objectOutput, IGeom iGeom, int n, IPrimProps iPrimProps) throws IOException {
        objectOutput.writeInt(n);
        GeomWriter.writeMeta(objectOutput, iGeom, iPrimProps);
    }

    private static void writeMeta(ObjectOutput objectOutput, IGeom iGeom, IPrimProps iPrimProps) throws IOException {
        Color color = iPrimProps.getColor();
        IMaterial iMaterial = iPrimProps.getMaterial();
        if (color == null && iMaterial != null) {
            color = iMaterial.getAttributes().getDiffuseColorWithOpacity();
        }
        assert (color != null || iMaterial != null) : "Either a material or a color must be specified.";
        GeomWriter.write((DataOutput)objectOutput, color);
        objectOutput.writeObject(iMaterial);
        objectOutput.writeFloat((float)iPrimProps.getEdgeWidth());
        objectOutput.writeInt(iPrimProps.getEdgeStipple());
        objectOutput.writeFloat((float)iPrimProps.getPointSize());
        int n = iPrimProps.getOptions();
        if (iPrimProps.getMaterial() != null && (iPrimProps.getMaterial().getAttributes().getOptions() & 2) != 0) {
            n |= 2;
        }
        objectOutput.writeInt(n);
    }

    private static void write(DataOutput dataOutput, Color color) throws IOException {
        float[] fArray = new float[4];
        color.getComponents(fArray);
        dataOutput.writeFloat(fArray[0]);
        dataOutput.writeFloat(fArray[1]);
        dataOutput.writeFloat(fArray[2]);
        dataOutput.writeFloat(fArray[3]);
    }

    private static void writeTuple3dList(DataOutput dataOutput, List<? extends Tuple3d> list) throws IOException {
        GeomWriter.writeList(dataOutput, GeomWriter::writeTuple3d, list);
    }

    private static void writeArray(DataOutput dataOutput, Tuple3d ... tuple3dArray) throws IOException {
        GeomWriter.writeArray(dataOutput, GeomWriter::writeTuple3d, tuple3dArray);
    }

    private static void write(DataOutput dataOutput, Tuple3d ... tuple3dArray) throws IOException {
        for (Tuple3d tuple3d : tuple3dArray) {
            GeomWriter.writeTuple3d(dataOutput, tuple3d);
        }
    }

    private static void writeTuple3d(DataOutput dataOutput, Tuple3d tuple3d) throws IOException {
        dataOutput.writeFloat((float)tuple3d.x);
        dataOutput.writeFloat((float)tuple3d.y);
        dataOutput.writeFloat((float)tuple3d.z);
    }

    private static void writeTuple2dList(DataOutput dataOutput, List<? extends Tuple2d> list) throws IOException {
        GeomWriter.writeList(dataOutput, GeomWriter::writeTuple2d, list);
    }

    private static void writeTuple2d(DataOutput dataOutput, Tuple2d tuple2d) throws IOException {
        dataOutput.writeFloat((float)tuple2d.x);
        dataOutput.writeFloat((float)tuple2d.y);
    }

    private static void writeArray(DataOutput dataOutput, Tuple2d ... tuple2dArray) throws IOException {
        GeomWriter.writeTuple2dList(dataOutput, Arrays.asList(tuple2dArray));
    }

    private static void writeArray(DataOutput dataOutput, int ... nArray) throws IOException {
        dataOutput.writeInt(nArray.length);
        for (int n : nArray) {
            dataOutput.writeInt(n);
        }
    }

    private static void writeBooleanList(DataOutput dataOutput, List<Boolean> list) throws IOException {
        GeomWriter.writeList(dataOutput, dataOutput::writeBoolean, list);
    }

    private static void writeArray(DataOutput dataOutput, Boolean ... booleanArray) throws IOException {
        GeomWriter.writeArray(dataOutput, dataOutput::writeBoolean, booleanArray);
    }

    private static void writeOrientList(DataOutput dataOutput, List<Elements.Orient> list) throws IOException {
        GeomWriter.writeList(dataOutput, GeomWriter::writeOrient, list);
    }

    private static void writeArray(DataOutput dataOutput, Elements.Orient ... orientArray) throws IOException {
        GeomWriter.writeArray(dataOutput, GeomWriter::writeOrient, orientArray);
    }

    private static void writeOrient(DataOutput dataOutput, Elements.Orient orient) throws IOException {
        dataOutput.writeBoolean(orient == Elements.Orient.CCW);
    }

    private static <T> void writeList(DataOutput dataOutput, ThrowableConsumer<T> throwableConsumer, List<T> list) throws IOException {
        dataOutput.writeInt(list.size());
        for (T t : list) {
            throwableConsumer.accept(t);
        }
    }

    private static <T> void writeList(DataOutput dataOutput, ThrowableBiConsumer<DataOutput, T> throwableBiConsumer, List<T> list) throws IOException {
        dataOutput.writeInt(list.size());
        for (T t : list) {
            throwableBiConsumer.accept(dataOutput, (DataOutput)t);
        }
    }

    private static <T> void writeArray(DataOutput dataOutput, ThrowableConsumer<T> throwableConsumer, T ... TArray) throws IOException {
        dataOutput.writeInt(TArray.length);
        for (T t : TArray) {
            throwableConsumer.accept(t);
        }
    }

    private static <T> void writeArray(DataOutput dataOutput, ThrowableBiConsumer<DataOutput, T> throwableBiConsumer, T ... TArray) throws IOException {
        dataOutput.writeInt(TArray.length);
        for (T t : TArray) {
            throwableBiConsumer.accept(dataOutput, (DataOutput)t);
        }
    }

    public static void write(ObjectOutput objectOutput, IMaterial iMaterial) throws IOException {
        objectOutput.writeObject(iMaterial.getAttributes());
    }

    public static void write(ObjectOutput objectOutput, IMatAttrs iMatAttrs) throws IOException {
        GeomWriter.writeChannel(objectOutput, iMatAttrs, MatChannel.AMBIENT);
        GeomWriter.writeTexture(objectOutput, iMatAttrs, MatChannel.BUMP, false);
        objectOutput.writeFloat(GeomWriter.get(iMatAttrs, IMatAttrs.BUMP_SCALE).floatValue());
        GeomWriter.writeChannel(objectOutput, iMatAttrs, MatChannel.DIFFUSE);
        GeomWriter.writeChannel(objectOutput, iMatAttrs, MatChannel.EMISSIVE);
        GeomWriter.writeTexture(objectOutput, iMatAttrs, MatChannel.NORMAL, false);
        GeomWriter.writeChannel(objectOutput, iMatAttrs, MatChannel.OPACITY, true);
        GeomWriter.writeChannel(objectOutput, iMatAttrs, MatChannel.REFLECTION);
        GeomWriter.writeChannel(objectOutput, iMatAttrs, MatChannel.SPECULAR);
        objectOutput.writeFloat(GeomWriter.get(iMatAttrs, IMatAttrs.SHININESS).floatValue());
    }

    private static void writeChannel(ObjectOutput objectOutput, IMatAttrs iMatAttrs, MatChannel matChannel) throws IOException {
        GeomWriter.writeChannel(objectOutput, iMatAttrs, matChannel, false);
    }

    private static void writeChannel(ObjectOutput objectOutput, IMatAttrs iMatAttrs, MatChannel matChannel, boolean bl) throws IOException {
        GeomWriter.write((DataOutput)objectOutput, GeomWriter.getColor(iMatAttrs, matChannel, bl));
        GeomWriter.writeTexture(objectOutput, iMatAttrs, matChannel, false);
        objectOutput.writeFloat((float)GeomWriter.getFade(iMatAttrs, matChannel, false));
    }

    private static void writeTexture(ObjectOutput objectOutput, IMatAttrs iMatAttrs, MatChannel matChannel, boolean bl) throws IOException {
        objectOutput.writeObject(GeomWriter.getTexture(iMatAttrs, matChannel, bl));
    }

    public static void write(ObjectOutput objectOutput, Texture texture) throws IOException {
        if (texture.image == null) {
            objectOutput.writeObject(null);
        } else {
            objectOutput.writeObject(texture.image);
            objectOutput.writeInt(texture.mode.ordinal());
            objectOutput.writeInt(texture.wrap.ordinal());
            if (texture.wrap.requiresBorderColor) {
                GeomWriter.write((DataOutput)objectOutput, texture.borderColor);
            }
        }
    }

    private static Color getColor(IMatAttrs iMatAttrs, MatChannel matChannel, boolean bl) {
        if (bl || ADVANCED_PARAMS_ENABLED) {
            return iMatAttrs.getColor(matChannel);
        }
        switch (matChannel) {
            case DIFFUSE: {
                return iMatAttrs.getColor(matChannel);
            }
        }
        return s_defAttrs.getColor(matChannel);
    }

    private static Texture getTexture(IMatAttrs iMatAttrs, MatChannel matChannel, boolean bl) {
        if (bl || ADVANCED_PARAMS_ENABLED) {
            return iMatAttrs.getTexture(matChannel);
        }
        switch (matChannel) {
            case DIFFUSE: {
                return iMatAttrs.getTexture(matChannel);
            }
        }
        return s_defAttrs.getTexture(matChannel);
    }

    private static double getFade(IMatAttrs iMatAttrs, MatChannel matChannel, boolean bl) {
        if (bl || ADVANCED_PARAMS_ENABLED) {
            return iMatAttrs.getFade(matChannel);
        }
        switch (matChannel) {
            case DIFFUSE: {
                return iMatAttrs.getFade(matChannel);
            }
        }
        return s_defAttrs.getFade(matChannel);
    }

    private static <T> T get(IMatAttrs iMatAttrs, IPropertySet.Prop<T> prop) {
        if (ADVANCED_PARAMS_ENABLED) {
            return iMatAttrs.get(prop);
        }
        return s_defAttrs.get(prop);
    }

    private static class ElementSources {
        public final Map<Elements.ElemProp<?>, IElemSource<?>> sublists = new HashMap();
        public final Map<String, IElemSource<Point2d>> uvsublists;

        public ElementSources(IPropertySet iPropertySet, int n) {
            for (Elements.ElemProp<?> object : Elements.FIXED) {
                IElemSource iElemSource = ((IElemSource)iPropertySet.get(object)).subset(0, n);
                this.sublists.put(object, iElemSource);
            }
            this.uvsublists = new ListMap<String, IElemSource<Point2d>>();
            for (Map.Entry entry : iPropertySet.get(Elements.UV).entrySet()) {
                this.uvsublists.put((String)entry.getKey(), ((IElemSource)entry.getValue()).subset(0, n));
            }
        }

        public ElementSources(ElementSources elementSources, int n, int n2) {
            for (Elements.ElemProp<?> object : Elements.FIXED) {
                IElemSource<?> iElemSource = elementSources.sublists.get(object).subset(n, n2);
                this.sublists.put(object, iElemSource);
            }
            this.uvsublists = new ListMap<String, IElemSource<Point2d>>();
            for (Map.Entry entry : elementSources.uvsublists.entrySet()) {
                this.uvsublists.put((String)entry.getKey(), ((IElemSource)entry.getValue()).subset(n, n2));
            }
        }

        public ElementSources sublist(int n, int n2) {
            return new ElementSources(this, n, n2);
        }

        public boolean isUniformUV() {
            return this.uvsublists.size() == 1;
        }

        public IElemSource<Point2d> getUV(String string) {
            IElemSource<Point2d> iElemSource = this.uvsublists.get(string);
            if (iElemSource == null && (iElemSource = this.uvsublists.get("teciuv0x193fa")) == null) {
                iElemSource = this.getFirstUV();
            }
            return iElemSource;
        }

        public IElemSource<Point2d> getUniformUV() {
            return this.uvsublists.size() == 1 ? this.uvsublists.values().iterator().next() : Elements.NO_UV;
        }

        public IElemSource<Point2d> getFirstUV() {
            return !this.uvsublists.isEmpty() ? this.uvsublists.values().iterator().next() : Elements.NO_UV;
        }

        public <T> IElemSource<T> get(Elements.ElemProp<T> elemProp) {
            return this.sublists.get(elemProp);
        }
    }

    private static interface ThrowableConsumer<T> {
        public void accept(T var1) throws IOException;
    }

    private static interface ThrowableBiConsumer<T, U> {
        public void accept(T var1, U var2) throws IOException;
    }

    private static enum ElemMapping {
        EM_PER_INDEX,
        EM_PER_FACE,
        EM_ALL_SAME,
        EM_NONE;

    }

    private static enum GeomType {
        GT_END,
        GT_POINT,
        GT_LINE_STRIP,
        GT_LINESEG,
        GT_TRIANGLE,
        GT_QUAD,
        GT_POLYGON,
        GT_MESH;

    }

    public static enum Version {
        VERSION_0000,
        VERSION_0001,
        VERSION_0002,
        VERSION_0003,
        VERSION_0004,
        VERSION_0005;


        public static Version curr() {
            return Version.values()[Version.values().length - 1];
        }
    }
}

