/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.license3;

import com.reprisesoftware.rlm.RlmAvailableProduct;
import com.reprisesoftware.rlm.RlmException;
import com.reprisesoftware.rlm.RlmHandle;
import com.reprisesoftware.rlm.RlmLicense;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.license3.ActivationDlg;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;

public class LicenseManager {
    private static final Logger LOGGER = Logger.getLogger(LicenseManager.class.getName());
    private final String d_productName;
    private final String d_license;
    private final String d_lmVersion;
    private final Collection<String> d_possibleOptions;
    private RlmHandle d_rlm = null;
    private RlmLicense d_product = null;
    private Map<String, RlmLicense> d_options = new HashMap<String, RlmLicense>();
    private String d_licLoc = ".";
    private String d_lastError = "";
    private Timer d_timer;
    private int d_strikes = 0;
    private Map<RlmLicense, String> d_acquired;

    public LicenseManager(String string, String string2, String string3, Collection<String> collection) {
        this.d_productName = string;
        this.d_lmVersion = string3;
        this.d_license = string2;
        this.d_possibleOptions = collection;
        this.d_acquired = new LinkedHashMap<RlmLicense, String>();
    }

    public synchronized boolean startFromPrefs(TeciProps teciProps, TypedProp<String> typedProp, TypedProp<String> typedProp2) {
        String string = teciProps.getString(ActivationDlg.PROP_LOCATION);
        boolean bl = "not_set".equals(string) || "server".equals(string);
        boolean bl2 = "not_set".equals(string) || "file".equals(string);
        String string2 = teciProps.getString(typedProp2);
        if (bl && !string2.isEmpty() && this.startLM(string2)) {
            return true;
        }
        String string3 = teciProps.getString(typedProp);
        return bl2 && this.startLM(string3);
    }

    private String toString(RlmException rlmException) {
        switch (rlmException.getCode()) {
            case -171: 
            case -170: {
                return "No authorization for product (-1)";
            }
        }
        return rlmException.getMessage();
    }

    public synchronized boolean startLM(String string) {
        RlmAvailableProduct rlmAvailableProduct;
        if (string == null) {
            string = "";
        }
        try {
            LOGGER.log(Level.CONFIG, "*** Using " + string);
            this.d_rlm = new RlmHandle(string, ".", this.d_license);
        }
        catch (RlmException rlmException) {
            LOGGER.log(Level.SEVERE, "RLM Handle Exception...");
            LOGGER.log(Level.SEVERE, rlmException.toString(), rlmException);
            this.d_lastError = this.toString(rlmException);
            return false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            LOGGER.log(Level.SEVERE, "RLM Handle Exception...");
            LOGGER.log(Level.SEVERE, unsatisfiedLinkError.toString(), unsatisfiedLinkError);
            this.d_lastError = unsatisfiedLinkError.getMessage();
            return false;
        }
        try {
            this.d_product = new RlmLicense(this.d_rlm, this.d_productName, this.d_lmVersion, 1);
        }
        catch (RlmException rlmException) {
            LOGGER.log(Level.SEVERE, "RLM License Exception...");
            LOGGER.log(Level.SEVERE, rlmException.toString(), rlmException);
            this.d_lastError = this.toString(rlmException);
            return false;
        }
        try {
            rlmAvailableProduct = this.getProduct();
        }
        catch (NoAvailableProductsException noAvailableProductsException) {
            rlmAvailableProduct = null;
        }
        double d = Double.parseDouble(this.d_product.getVersion());
        double d2 = Double.parseDouble(this.d_lmVersion);
        if ((this.d_product.getHostID().equals("") && (this.d_product.getHostID().equalsIgnoreCase("ANY") || this.d_product.getShare() != 3 || rlmAvailableProduct != null && rlmAvailableProduct.getCount() == 0) || d - d2 > 5.0 || this.d_product.getIssuer().toLowerCase().contains("lz0")) && Application.getApp() != null) {
            TeciProps teciProps = Application.getApp().getPrefs();
            boolean bl = teciProps.getBoolean("runlog", false);
            if (!bl) {
                LicenseManager.reportAbuse(this.d_productName, this.d_lmVersion, "firstrun");
                teciProps.set("runlog", (Object)true);
            } else {
                LicenseManager.reportAbuse(this.d_productName, this.d_lmVersion, "run");
            }
        }
        if (this.d_product.getHostID().equals("")) {
            LOGGER.log(Level.FINER, "Starting timer");
            this.d_strikes = 0;
            this.d_timer = new Timer(true);
            this.d_timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    LicenseManager.this.checkServerStatus();
                }
            }, 60000L, 60000L);
        }
        return true;
    }

    private synchronized void checkServerStatus() {
        block9: {
            int n = -1;
            if (this.d_product != null) {
                try {
                    n = this.d_product.getAttrHealth();
                }
                catch (RlmException rlmException) {
                    LOGGER.log(Level.SEVERE, "RLM License Exception...");
                    LOGGER.log(Level.SEVERE, rlmException.toString(), rlmException);
                }
            }
            if (n != 0 && n != -25) {
                LOGGER.log(Level.INFO, "License Server Down -- status: " + n);
                ++this.d_strikes;
                if (this.d_strikes >= 3) {
                    this.checkin();
                    try {
                        this.d_product = new RlmLicense(this.d_rlm, this.d_productName, this.d_lmVersion, 1);
                    }
                    catch (RlmException rlmException) {
                        LOGGER.log(Level.SEVERE, "RLM License Exception...");
                        LOGGER.log(Level.SEVERE, rlmException.toString(), rlmException);
                        this.d_lastError = rlmException.getMessage();
                        JOptionPane.showMessageDialog(null, Intl.intl("Lost floating license -- closing program."), String.format(Intl.intl("%s (Unlicensed)"), this.d_productName), 0);
                        LOGGER.log(Level.INFO, "Licensing failure. Shutting down.");
                        if (Application.getApp() != null) {
                            SwingUtilities.invokeLater(() -> Application.getApp().quit(false));
                            break block9;
                        }
                        System.exit(0);
                    }
                }
            } else {
                this.d_strikes = 0;
            }
        }
    }

    private static void reportAbuse(final String string, final String string2, final String string3) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String string4 = "http://www.thunderheadeng.com/runlog.php?prod=" + string + "&vers=" + string2 + "&event=" + string3;
                    URL uRL = new URL(string4);
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.getResponseCode();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        thread.start();
    }

    public String getHostID(int n) {
        return this.d_rlm.getAllHostIDs(n)[0].trim();
    }

    public String getHostIDs() {
        if (this.d_rlm == null) {
            return Intl.intl("unavailable");
        }
        String[] stringArray = this.d_rlm.getAllHostIDs(3);
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string = string + " ";
            }
            string = string + stringArray[i].trim();
        }
        return "hostid=" + this.getHostID(1) + "\n" + "ether=" + string + "\n" + this.getHostID(6);
    }

    public String getEth0(String string) {
        String[] stringArray = this.d_rlm.getAllHostIDs(3);
        if (stringArray != null && 0 < stringArray.length) {
            return stringArray[0];
        }
        return string;
    }

    public String getLicenseLocation() {
        return this.d_product == null ? "" : this.d_product.getLFPath();
    }

    public boolean isAuthorized() {
        return this.d_product != null && this.d_product.goodOnce();
    }

    public boolean isRoaming() {
        return this.d_product != null && this.d_product.isRoaming();
    }

    public boolean inQueue() {
        if (this.d_product != null) {
            try {
                if (this.d_product.status() == -25) {
                    return true;
                }
            }
            catch (RlmException rlmException) {
                LOGGER.log(Level.SEVERE, "RLM License Exception...");
                LOGGER.log(Level.SEVERE, rlmException.toString(), rlmException);
                return false;
            }
        }
        return false;
    }

    public int getDaysRemaining() {
        return this.d_product.daysToExpiration();
    }

    private RlmAvailableProduct getProduct() throws NoAvailableProductsException {
        Vector vector = this.d_rlm.getAvailableProducts(this.d_productName, this.d_lmVersion);
        if (vector == null) {
            throw new NoAvailableProductsException();
        }
        return (RlmAvailableProduct)vector.get(0);
    }

    public String getDescription() {
        String string = Intl.intl("unknown error");
        if (this.d_rlm == null || this.d_product == null) {
            return this.d_lastError;
        }
        if (this.isAuthorized() || this.inQueue()) {
            try {
                RlmAvailableProduct rlmAvailableProduct = this.getProduct();
                string = "";
                int n = rlmAvailableProduct.getCount();
                LOGGER.log(Level.FINER, "Host ID: " + this.d_product.getHostID());
                String string2 = this.d_product.getHostID().equals("") ? Intl.intl("Floating") : Intl.intl("Node-Locked");
                String string3 = "";
                string3 = this.d_product.isRoaming() ? Intl.intl("Roaming") : (n == 0 ? Intl.intl("Unlimited") : String.format(Intl.intl("%1$d of %2$d"), rlmAvailableProduct.getCurrentInUse(), n));
                string = string + String.format(Intl.intl("Usage: %1$s, %2$s\n"), string2, string3);
                int n2 = this.d_product.daysToExpiration();
                String string4 = n2 == 0 ? Intl.intl("Unlimited") : Integer.toString(n2);
                string = string + String.format(Intl.intl("Days Remaining: %s\n"), string4);
                string = string + String.format(Intl.intl("Maintenance Expires: %s\n"), this.d_product.getVersion());
                String string5 = "";
                for (String string6 : this.d_possibleOptions) {
                    LicenseStatus licenseStatus = this.getAvailableProduct(string6);
                    if (licenseStatus != LicenseStatus.AVAILABLE && licenseStatus != LicenseStatus.IN_USE) continue;
                    if (!string5.isEmpty()) {
                        string5 = string5 + ", ";
                    }
                    string5 = string5 + string6;
                }
                if (!string5.isEmpty()) {
                    string = string + "\n" + String.format(Intl.intl("Options: %s\n"), string5);
                }
                LOGGER.log(Level.FINER, "ROAM: " + this.d_product.isRoaming());
            }
            catch (NoAvailableProductsException noAvailableProductsException) {
                string = Intl.intl("Unable to communicate with license server.");
            }
        }
        return string;
    }

    public String getLastError() {
        return this.d_lastError;
    }

    private synchronized void checkin() {
        if (this.d_product != null) {
            this.d_product.checkin();
            this.d_product = null;
        }
        for (RlmLicense rlmLicense : this.d_options.values()) {
            rlmLicense.checkin();
        }
        this.d_options.clear();
    }

    public synchronized void closeLM() {
        if (this.d_timer != null) {
            this.d_timer.cancel();
        }
        this.checkin();
        if (this.d_rlm != null) {
            this.d_rlm.close();
            this.d_rlm = null;
        }
        this.d_acquired.clear();
    }

    public LicenseStatus getAvailableProduct(String string) {
        if (this.d_rlm == null) {
            return LicenseStatus.NOT_FOUND;
        }
        Vector vector = this.d_rlm.getAvailableProducts(string, this.d_lmVersion);
        if (vector == null) {
            return LicenseStatus.NOT_FOUND;
        }
        Iterator iterator = vector.iterator();
        if (iterator.hasNext()) {
            RlmAvailableProduct rlmAvailableProduct = (RlmAvailableProduct)iterator.next();
            int n = rlmAvailableProduct.getCount();
            int n2 = rlmAvailableProduct.getCurrentInUse();
            return n2 < n ? LicenseStatus.AVAILABLE : LicenseStatus.IN_USE;
        }
        return LicenseStatus.NOT_FOUND;
    }

    public boolean acquireLicense(String string) {
        RlmLicense rlmLicense = this.findAcquiredLicenseByProduct(string);
        if (rlmLicense != null) {
            LOGGER.log(Level.FINER, String.format("acquireLicese(%s): %s%n", string, "License already acquired."));
            return true;
        }
        try {
            RlmLicense rlmLicense2 = new RlmLicense(this.d_rlm, string, this.d_lmVersion, 1);
            if (rlmLicense2.status() != 0) {
                LOGGER.log(Level.WARNING, String.format("aquireLicense(product=%s) - failed with status code %s%n", string, rlmLicense2.status()));
                rlmLicense2.checkin();
                return false;
            }
            LOGGER.log(Level.FINER, String.format("acquireLicese(%s): %s%n", string, "success"));
            this.d_acquired.put(rlmLicense2, string);
            return true;
        }
        catch (RlmException rlmException) {
            rlmException.printStackTrace();
            return false;
        }
    }

    public RlmLicense findAcquiredLicenseByProduct(String string) {
        for (Map.Entry<RlmLicense, String> entry : this.d_acquired.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(string)) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean releaseAcquiredLicense(RlmLicense rlmLicense) {
        String string = rlmLicense.getProduct();
        rlmLicense.checkin();
        boolean bl = this.d_acquired.remove(rlmLicense) != null;
        LOGGER.log(Level.FINER, String.format("releaseAcquiredLicense(%s): %s%n", string, bl ? "success" : "failed"));
        return bl;
    }

    public Collection<RlmLicense> getAcquiredLicenses() {
        return this.d_acquired.keySet();
    }

    protected RlmLicense getProductLicense() {
        return this.d_product;
    }

    public String getLicenseVersion() {
        return this.getProductLicense().getVersion();
    }

    public boolean isOptionAvailable(String string) throws Exception {
        throw new Exception();
    }

    public class NoAvailableProductsException
    extends Exception {
    }

    public static enum LicenseStatus {
        AVAILABLE,
        NOT_FOUND,
        IN_USE;

    }
}

