/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.license3;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultHighlighter;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.io.CopyFile;
import thunderheadeng.io.ExampleFileFilter;
import thunderheadeng.license3.LicenseManager;
import thunderheadeng.util.OnlineLicenseReq;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.Win32Native;

public class ActivationDlg
extends guiDialog {
    private static final long serialVersionUID = -5473590092572781810L;
    public static final String LOCATION_NONE = "not_set";
    public static final String LOCATION_FILE = "file";
    public static final String LOCATION_SERVER = "server";
    public static final TypedProp<String> PROP_LOCATION = new TypedProp<String>((Object)"thunderheadeng.license3.LicenseManager.location", "not_set");
    private guiLabel d_status = null;
    private MultiLineLabel d_details = null;
    private LicenseManager d_lm = null;
    private guiRadioButton d_dirRadio;
    private guiRadioButton d_srvRadio;
    private DirChooserPanel d_dirPanel;
    private SrvChooserPanel d_srvPanel;
    private MultiLineLabel hostid = null;
    private final String d_productName;
    private final TeciProps d_prefs;
    private static final MouseListener MOUSE_TRAP = new MouseAdapter(){};

    public ActivationDlg(JFrame jFrame, LicenseManager licenseManager, String string, Icon icon, TeciProps teciProps, TypedProp<String> typedProp, TypedProp<String> typedProp2, Color color) {
        super((Window)jFrame, string, 16);
        this.d_lm = licenseManager;
        guiPanel guiPanel2 = this.getDialogPane();
        this.d_productName = string;
        this.d_prefs = teciProps;
        TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Computer Information"));
        this.hostid = new MultiLineLabel(this.d_lm.getHostIDs());
        this.hostid.setHighlighter(new DefaultHighlighter());
        ImageIcon imageIcon = guiUtil.loadTeciIcon("Copy16.gif");
        JButton jButton = new JButton(Intl.intl("Copy"), imageIcon);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActivationDlg.this.hostid.selectAll();
                ActivationDlg.this.hostid.copy();
            }
        });
        TitleSeparator titleSeparator2 = new TitleSeparator(Intl.intl("License Location"));
        this.d_dirRadio = new guiRadioButton(Intl.intl("License File"));
        this.d_srvRadio = new guiRadioButton(Intl.intl("License Server"));
        this.d_dirPanel = new DirChooserPanel(this, typedProp, Intl.intl("Location:"));
        this.d_dirPanel.linkStatus(this.d_dirRadio);
        this.d_srvPanel = new SrvChooserPanel(this, typedProp2, Intl.intl("Server:"));
        this.d_srvPanel.linkStatus(this.d_srvRadio);
        TitleSeparator titleSeparator3 = new TitleSeparator(Intl.intl("Current License"));
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Status:"));
        this.d_status = new guiLabel(Intl.intl("Not Licensed"));
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Details:"));
        this.d_details = new MultiLineLabel("more stuff\nhere...");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.d_dirRadio);
        buttonGroup.add(this.d_srvRadio);
        OptListener optListener = new OptListener();
        this.d_dirRadio.addActionListener(optListener);
        this.d_srvRadio.addActionListener(optListener);
        TopBanner topBanner = new TopBanner(Color.WHITE, color);
        topBanner.setTitle(Intl.intl("Licensing and Activation"));
        topBanner.setSubTitle("");
        if (icon != null) {
            topBanner.setIcon(icon);
        }
        guiPanel2.setLayout(new GridBagLayout());
        GridBagUtil.add(guiPanel2, topBanner, 0, 0, 4, 1, -12, -12, 12, -12);
        GridBagUtil.add(guiPanel2, titleSeparator, 0, 1, 4, 1, 0, 0, 12, 0);
        GridBagUtil.add(guiPanel2, this.hostid, 0, 2, 3, 1, 0, 18, 12, 0, 2, 100.0, 1.0);
        GridBagUtil.add(guiPanel2, jButton, 3, 2, 1, 1, 0, 0, 12, 0, 0, 1.0, 1.0);
        GridBagUtil.add(guiPanel2, titleSeparator2, 0, 3, 4, 1, 0, 0, 12, 0);
        guiPanel guiPanel3 = new guiPanel();
        guiPanel3.setLayout(new GridBagLayout());
        int n = 0;
        GridBagUtil.add(guiPanel3, this.d_dirRadio, 0, n++, 4, 1, 0, 18, 3, 0);
        n = this.d_dirPanel.addToPanel(guiPanel3, 4);
        GridBagUtil.add(guiPanel3, this.d_srvRadio, 0, n++, 4, 1, 0, 18, 3, 0);
        n = this.d_srvPanel.addToPanel(guiPanel3, n);
        GridBagUtil.add(guiPanel2, guiPanel3, 0, 4, 4, 1, 0, 0, 0, 0);
        GridBagUtil.add(guiPanel2, titleSeparator3, 0, 5, 4, 1, 0, 0, 12, 0);
        guiPanel guiPanel4 = new guiPanel();
        guiPanel4.setLayout(new GridBagLayout());
        GridBagUtil.add(guiPanel4, guiLabel2, 0, 1, 1, 1, 0, 12, 12, 0);
        GridBagUtil.add(guiPanel4, this.d_status, 1, 1, 1, 1, 0, 12, 12, 0, 2, 100.0, 1.0);
        GridBagUtil.add(guiPanel4, guiLabel3, 0, 2, 1, 1, 0, 12, 12, 0);
        GridBagUtil.add(guiPanel4, this.d_details, 1, 2, 1, 1, 0, 12, 12, 0, 1, 100.0, 1.0);
        GridBagUtil.add(guiPanel2, guiPanel4, 0, 6, 4, 1, 0, 0, 0, 0, 1, 100.0, 100.0);
        this.loadPrefs();
        String string2 = this.inferCurrentLicenseLocation();
        this.d_dirRadio.setSelected(LOCATION_FILE.equals(string2));
        this.d_srvRadio.setSelected(LOCATION_SERVER.equals(string2));
        this.updateStatus();
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        return super.validateData(bl, bl2);
    }

    private void loadPrefs() {
        this.d_dirPanel.load(this.d_prefs);
        this.d_srvPanel.load(this.d_prefs);
    }

    private String inferCurrentLicenseLocation() {
        if (this.d_lm.isAuthorized()) {
            String string = this.d_lm.getDescription();
            if (string.toLowerCase().contains("floating")) {
                return LOCATION_SERVER;
            }
            if (string.toLowerCase().contains("node-locked")) {
                return LOCATION_FILE;
            }
            System.err.println("Unable to infer license location from description: " + string);
        }
        return this.d_prefs.getString(PROP_LOCATION);
    }

    private void updateStatus() {
        if (this.d_lm.isAuthorized()) {
            this.d_status.setText(Intl.intl("Licensed"));
        } else if (this.d_lm.inQueue()) {
            this.d_status.setText(Intl.intl("Licensed (Waiting in Queue)"));
        } else {
            this.d_status.setText(Intl.intl("Not Licensed"));
        }
        String string = this.d_lm.getDescription();
        if (string.contains("-59") && string.contains("-142")) {
            string = string + "\n";
            string = string + Intl.intl("Floating license server too old.\nThunderhead License Manager update required.");
        }
        this.d_details.setText(string);
        if (!this.d_lm.isAuthorized()) {
            this.d_details.setForeground(Color.RED);
        } else {
            this.d_details.setForeground(Color.BLACK);
        }
        this.pack();
        System.out.println(this.d_lm.getLicenseLocation());
    }

    private void refreshLicense(final Runnable runnable) {
        this.setModified(true);
        this.d_status.setText(Intl.intl("Checking for License..."));
        this.d_details.setText("");
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setCursor(Cursor.getPredefinedCursor(3));
        Component component = jRootPane.getGlassPane();
        component.addMouseListener(MOUSE_TRAP);
        component.setVisible(true);
        Thread thread = new Thread(){

            @Override
            public void run() {
                ActivationDlg.this.restartLM();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JRootPane jRootPane = ActivationDlg.this.getRootPane();
                        jRootPane.setCursor(Cursor.getDefaultCursor());
                        Component component = jRootPane.getGlassPane();
                        component.removeMouseListener(MOUSE_TRAP);
                        component.setVisible(false);
                        ActivationDlg.this.updateStatus();
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                });
            }
        };
        thread.start();
    }

    private void restartLM() {
        String string = "";
        string = this.d_srvRadio.isSelected() ? this.d_srvPanel.getLicenseSrv() : this.d_dirPanel.getLicenseDir();
        this.d_lm.closeLM();
        this.d_lm.startLM(string);
    }

    @Override
    public int doModal() {
        this.setModified(false);
        int n = super.doModal();
        this.d_dirPanel.save(this.d_prefs);
        this.d_srvPanel.save(this.d_prefs);
        if (this.d_srvRadio.isSelected()) {
            this.d_prefs.set(PROP_LOCATION, LOCATION_SERVER);
        } else if (this.d_dirRadio.isSelected()) {
            this.d_prefs.set(PROP_LOCATION, LOCATION_FILE);
        }
        if (this.isModified()) {
            this.restartLM();
        }
        if (!this.d_lm.isAuthorized()) {
            JOptionPane.showMessageDialog(this.getParent(), String.format(Intl.intl("%s is not Licensed and will close."), this.d_productName), String.format(Intl.intl("%s (Unlicensed)"), this.d_productName), 0);
            EventQueue.invokeLater(() -> {
                if (Application.getApp() != null) {
                    Application.getApp().quit(false);
                }
            });
        }
        return n;
    }

    private void installLicenseFromString(String string, Runnable runnable) {
        try {
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss");
            String string2 = simpleDateFormat.format(calendar.getTime());
            String string3 = System.getProperty("java.io.tmpdir");
            File file = new File(string3, this.d_productName.toLowerCase() + string2 + ".lic");
            file.deleteOnExit();
            PrintWriter printWriter = new PrintWriter(file);
            printWriter.println(string);
            printWriter.close();
            this.installLicenseFile(file, runnable);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void installLicenseFile(File file, Runnable runnable) {
        File file2 = new File(this.d_dirPanel.getLicenseDir());
        File file3 = new File(this.d_dirPanel.getLicenseDir(), file.getName());
        if (!file3.exists()) {
            try {
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                CopyFile.copy(file, file3);
                this.refreshLicense(runnable);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, Intl.intl("Could not copy license file to Local License folder."), Intl.intl("License Copy Error"), 0);
                iOException.printStackTrace();
            }
        }
    }

    private void installLicenseFile(Runnable runnable) {
        guiFileChooser guiFileChooser2 = new guiFileChooser();
        ExampleFileFilter exampleFileFilter = new ExampleFileFilter("lic", Intl.intl("License Files"));
        guiFileChooser2.addChoosableFileFilter(exampleFileFilter);
        guiFileChooser2.setAcceptAllFileFilterUsed(true);
        guiFileChooser2.setFileFilter(exampleFileFilter);
        guiFileChooser2.setMustExist(true);
        int n = guiFileChooser2.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        this.installLicenseFile(guiFileChooser2.getSelectedFile(), runnable);
    }

    private static class TopBanner
    extends guiPanel {
        private static final long serialVersionUID = -6696244371779433758L;
        private Paint d_gradient;
        private String d_title;
        private String d_subTitle;
        private Icon d_icon;

        public TopBanner(Color color, Color color2) {
            this.d_gradient = new GradientPaint(0.0f, 0.0f, color, 500.0f, 0.0f, color2);
            this.setPreferredSize(new Dimension(500, 59));
            this.d_title = null;
            this.d_subTitle = null;
            this.d_icon = null;
        }

        public void setTitle(String string) {
            this.d_title = string;
        }

        public void setSubTitle(String string) {
            this.d_subTitle = string;
        }

        public void setIcon(Icon icon) {
            this.d_icon = icon;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n;
            int n2;
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(this.d_gradient);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.d_icon != null) {
                int n3 = this.d_icon.getIconWidth();
                int n4 = this.d_icon.getIconHeight();
                n2 = (this.getHeight() - n4) / 2;
                n = this.getWidth() - (n2 > 0 ? n2 : 8) - n3;
                this.d_icon.paintIcon(this, graphics2D, n, n2);
            }
            graphics2D.setFont(this.getFont());
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds("M", graphics2D);
            graphics2D.setColor(Color.BLACK);
            n2 = (int)rectangle2D.getWidth() * 2;
            n = (int)rectangle2D.getHeight() * 3 / 2;
            graphics2D.setFont(this.getFont().deriveFont(1));
            graphics2D.drawString(this.d_title, n2, n);
            graphics2D.setFont(this.getFont());
            graphics2D.drawString(this.d_subTitle, n2 += (int)rectangle2D.getWidth() * 2, n += (int)rectangle2D.getHeight() * 5 / 4);
        }
    }

    private class SrvChooserPanel {
        private final TypedProp<String> d_preferenceKey;
        private final guiLabel d_label;
        private final guiTextField d_locationTF;
        private final JButton d_locationBtn;

        public SrvChooserPanel(final guiDialog guiDialog2, TypedProp<String> typedProp, String string) {
            this.d_preferenceKey = typedProp;
            this.d_label = new guiLabel(string);
            this.d_locationTF = new guiTextField();
            this.d_locationTF.setEditable(false);
            this.d_locationTF.setColumns(30);
            this.d_locationBtn = new JButton("Edit...");
            this.d_locationBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SrvChooserPanel.this.getServer(guiDialog2);
                }
            });
        }

        public int addToPanel(guiPanel guiPanel2, int n) {
            int n2 = n;
            GridBagUtil.add(guiPanel2, this.d_label, 0, n2, 1, 1, 0, 38, 12, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_locationTF, 1, n2, 2, 1, 0, 0, 12, 6, 2, 1.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_locationBtn, 3, n2++, 1, 1, 0, 0, 12, 0, 0, 0.0, 0.0, 13);
            return n2;
        }

        public void load(TeciProps teciProps) {
            String string = teciProps.getString(this.d_preferenceKey);
            if (string == null) {
                string = "";
            }
            this.d_locationTF.setText(string);
        }

        public void save(TeciProps teciProps) {
            String string = this.d_locationTF.getText();
            teciProps.set(this.d_preferenceKey, string);
        }

        public String getLicenseSrv() {
            return this.d_locationTF.getText();
        }

        public void linkStatus(guiRadioButton guiRadioButton2) {
            LinkStatus.link((AbstractButton)guiRadioButton2, this.d_label, this.d_locationTF, this.d_locationBtn);
        }

        public void getServer(guiDialog guiDialog2) {
            String string = "localhost";
            int n = 52100;
            String[] stringArray = this.d_locationTF.getText().split("@", 2);
            if (stringArray.length == 1) {
                string = stringArray[0];
            } else {
                try {
                    n = Integer.parseInt(stringArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                string = stringArray[1];
            }
            guiDialog guiDialog3 = new guiDialog((Window)guiDialog2, Intl.intl("License Server"), 9);
            guiPanel guiPanel2 = guiDialog3.getDialogPane();
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Server:"));
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Port:"));
            guiTextField guiTextField2 = new guiTextField(string);
            guiTextField2.setColumns(20);
            guiIntField guiIntField2 = new guiIntField(n);
            guiIntField2.setColumns(20);
            guiPanel2.setLayout(new GridBagLayout());
            int n2 = 0;
            GridBagUtil.add(guiPanel2, guiLabel2, 0, n2, 1, 1, 0, 0, 12, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, guiTextField2, 1, n2++, 1, 1, 0, 0, 12, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, guiLabel3, 0, n2, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, guiIntField2, 1, n2++, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
            int n3 = guiDialog3.doModal();
            if (n3 == 1) {
                this.d_locationTF.setText(guiIntField2.getValue() + "@" + guiTextField2.getValue());
                ActivationDlg.this.refreshLicense(null);
            }
        }
    }

    private class DirChooserPanel {
        private TypedProp<String> d_preferenceKey;
        private final guiLabel d_label;
        private final guiTextField d_locationTF;
        private JButton d_installLicense;
        private JButton d_activationKey;

        public DirChooserPanel(guiDialog guiDialog2, TypedProp<String> typedProp, String string) {
            this.d_label = new guiLabel(string);
            this.d_preferenceKey = typedProp;
            this.d_locationTF = new guiTextField();
            this.d_locationTF.setEditable(false);
            this.d_locationTF.setColumns(30);
            this.d_installLicense = new JButton(Intl.intl("Local..."));
            this.d_installLicense.addActionListener(actionEvent -> ActivationDlg.this.installLicenseFile(null));
            this.d_activationKey = new JButton(Intl.intl("Online..."));
            this.d_activationKey.addActionListener(actionEvent -> {
                guiDialog guiDialog3 = new guiDialog((Window)guiDialog2, Intl.intl("Online Activation"), 9);
                guiTextField guiTextField2 = new guiTextField();
                guiTextField2.setColumns(30);
                guiPanel guiPanel2 = new guiPanel(new GridBagLayout());
                GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2);
                gridBagHelper.addRow(Intl.intl("Key:"), guiTextField2);
                guiDialog3.setDialogComponent(guiPanel2);
                if (guiDialog3.doModal() == 1) {
                    TaskProgress taskProgress = new TaskProgress();
                    guiProgressMonitor guiProgressMonitor2 = new guiProgressMonitor(guiDialog2, Intl.intl("Loading license..."), true, taskProgress, 0);
                    Runnable runnable = () -> this.onlineActivation(guiTextField2, taskProgress);
                    new Thread(runnable).start();
                    guiProgressMonitor2.begin();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onlineActivation(guiTextField guiTextField2, TaskProgress taskProgress) {
            Cursor cursor = ActivationDlg.this.getCursor();
            try {
                Object object;
                ActivationDlg.this.setCursor(Cursor.getPredefinedCursor(3));
                String string = guiTextField2.getText();
                guiTextField2.setModified(false);
                string = string.trim();
                string = string.toUpperCase();
                string = string.replaceAll("[^0-9A-F]", "");
                OnlineLicenseReq.Response response = null;
                try {
                    try {
                        object = Win32Native.getProxyConfig();
                        Win32Native.setJVMDefaultProxyProps((Win32Native.ProxyConfig)object);
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        unsatisfiedLinkError.printStackTrace();
                    }
                    response = OnlineLicenseReq.getAuth(string, ActivationDlg.this.d_lm.getHostID(1), ActivationDlg.this.d_lm.getEth0("000000000000"));
                }
                catch (ConnectException connectException) {
                    connectException.printStackTrace();
                    response = new OnlineLicenseReq.Response();
                    response.err = -10;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    response = new OnlineLicenseReq.Response();
                    response.license = exception.getClass().getName() + ": " + exception.getLocalizedMessage();
                    response.err = -1;
                }
                if (!taskProgress.isRunning()) {
                    return;
                }
                if (!response.isError()) {
                    ActivationDlg.this.installLicenseFromString(response.getLicenseString(), new AuthMessage());
                    taskProgress.cancel();
                } else {
                    object = response.getErrorString() + "\n" + Intl.intl("For additional information, please contact Thunderhead Engineering.\n");
                    if (response.err == -10) {
                        object = response.getErrorString() + "\n" + Intl.intl("Your computer may be behind a proxy server. \n To activate your license, please contact Thunderhead Engineering. \nAutomated activation is available at: http://www.thunderheadeng.com/license/");
                    }
                    taskProgress.cancel();
                    JOptionPane.showMessageDialog(ActivationDlg.this, object, Intl.intl("Online Authorization Failed"), 1);
                }
            }
            finally {
                ActivationDlg.this.setCursor(cursor);
            }
        }

        public int addToPanel(guiPanel guiPanel2, int n) {
            int n2 = n;
            GridBagUtil.add(guiPanel2, this.d_label, 0, n2, 1, 1, 0, 38, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_locationTF, 1, n2, 2, 1, 0, 0, 6, 6, 2, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_activationKey, 1, ++n2, 1, 1, 0, -1, 6, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_installLicense, 2, n2, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
            return ++n2;
        }

        public void load(TeciProps teciProps) {
            String string = teciProps.getString(this.d_preferenceKey);
            if (string == null) {
                string = "";
            }
            this.d_locationTF.setText(string);
        }

        public void save(TeciProps teciProps) {
            String string = this.d_locationTF.getText();
            teciProps.set(this.d_preferenceKey, string);
        }

        public String getLicenseDir() {
            return this.d_locationTF.getText();
        }

        public void linkStatus(guiRadioButton guiRadioButton2) {
            LinkStatus.link((AbstractButton)guiRadioButton2, this.d_label, this.d_locationTF, this.d_installLicense, this.d_activationKey);
        }

        public void getFile(Component component) {
            guiFileChooser guiFileChooser2 = new guiFileChooser();
            guiFileChooser2.setFileSelectionMode(1);
            guiFileChooser2.setMustExist(true);
            File file = new File(this.d_locationTF.getText());
            guiFileChooser2.setCurrentDirectory(file.getParentFile());
            guiFileChooser2.setSelectedFile(file);
            int n = guiFileChooser2.showOpenDialog(component);
            if (n == 0) {
                File file2 = guiFileChooser2.getSelectedFile();
                this.d_locationTF.setText(file2.getAbsolutePath());
                ActivationDlg.this.refreshLicense(null);
            }
        }
    }

    private class AuthMessage
    implements Runnable {
        private AuthMessage() {
        }

        @Override
        public void run() {
            if (!EventQueue.isDispatchThread()) {
                try {
                    EventQueue.invokeAndWait(this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return;
            }
            String string = Intl.intl("Authorization Failed");
            if (ActivationDlg.this.d_lm.isAuthorized()) {
                int n = ActivationDlg.this.d_lm.getDaysRemaining();
                String string2 = n == 0 ? Intl.intl("Unlimited") : Integer.toString(n);
                string = Intl.intl("Authorization Successful") + "\n" + String.format(Intl.intl("Days Remaining: %s"), string2);
                ActivationDlg.this.d_dirRadio.setSelected(true);
            }
            JOptionPane.showMessageDialog(ActivationDlg.this, string, Intl.intl("Online Authorization"), 1);
        }
    }

    private class OptListener
    implements ActionListener {
        private OptListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActivationDlg.this.refreshLicense(null);
        }
    }
}

