/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.license2.crypkey;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.license2.LicenseManager;
import thunderheadeng.license2.NetworkWaitDlg;
import thunderheadeng.license2.crypkey.CrypKeyAPI;
import thunderheadeng.license2.crypkey.KillLicenseDlg;
import thunderheadeng.license2.crypkey.RegisterDlg;

public class CrypKeyLM
implements LicenseManager {
    private String d_filepath;
    private String d_masterKey;
    private String d_userKey;
    private ReadyToTryConfig d_rttc;
    private String d_currError;
    private int d_requiredLevel;
    private boolean d_firstAuth = true;
    private static final int NUM_OPTION_BITS = 25;
    private static final int NETWORK_MAX_CHECKTIME = 540;
    private static final boolean ALLOW_FLOPPY = false;
    private static final String APP_NOT_AUTHORIZED = Intl.intl("Application not authorized. Please obtain a Site Key.");
    private static final String OPTION_NOT_ALLOWED = Intl.intl("The requested operation is not authorized. It can be enabled by obtaining a new Site Key.");
    private static final String LEVEL_TOO_LOW = Intl.intl("The current license will not work with this version. Please obtain a new Site Key.");

    public CrypKeyLM(String string, String string2, String string3, ReadyToTryConfig readyToTryConfig, int n) {
        this.d_filepath = string;
        this.d_masterKey = string2;
        this.d_userKey = string3;
        this.d_rttc = readyToTryConfig;
        this.d_requiredLevel = n;
    }

    private int readyToTry(ReadyToTryConfig readyToTryConfig) {
        return CrypKeyAPI.readyToTryDays(readyToTryConfig.getAuthBits(), (short)readyToTryConfig.getCount(), (short)readyToTryConfig.getTrialVer(), (short)1);
    }

    @Override
    public final boolean startLicenseManager() {
        int n = 0;
        int n2 = CrypKeyAPI.initCrypkey(this.d_filepath, this.d_masterKey, this.d_userKey, n, 540);
        if (n2 != 0) {
            this.d_currError = CrypKeyAPI.explainErr(8, n2);
            return false;
        }
        int n3 = CrypKeyAPI.getAuthorization2(1);
        if (n3 > 0) {
            NetworkWaitDlg networkWaitDlg = new NetworkWaitDlg(null, this);
            networkWaitDlg.doModal();
            n3 = CrypKeyAPI.getAuthorization2(0);
        }
        if (n3 != 0 && !this.isAuthorized()) {
            return false;
        }
        this.d_firstAuth = false;
        return true;
    }

    @Override
    public final void endLicenseManager() {
        CrypKeyAPI.endCrypkey();
    }

    @Override
    public final boolean isAuthorized() {
        int n;
        int n2 = CrypKeyAPI.getAuthorization2(0);
        if (n2 != 0 && this.d_firstAuth && (n = this.readyToTry(this.d_rttc)) != 0) {
            System.out.println(n2);
            this.d_currError = CrypKeyAPI.explainErr(1, n2) + " (" + CrypKeyAPI.explainErr(9, n) + ")";
            return false;
        }
        if (this.d_firstAuth) {
            this.d_firstAuth = false;
            CrypKeyAPI.getAuthorization2(1);
        }
        return this.isLevelAllowed();
    }

    @Override
    public final boolean isOptionAllowed(int n) {
        if (!this.isAuthorized()) {
            return false;
        }
        int n2 = CrypKeyAPI.getOption(25, n);
        if (n2 == 0) {
            this.d_currError = OPTION_NOT_ALLOWED;
            return false;
        }
        if (n2 == -1) {
            this.d_currError = APP_NOT_AUTHORIZED;
            return false;
        }
        return true;
    }

    public final boolean isLevelAllowed() {
        return this.isLevelAllowed(this.d_requiredLevel);
    }

    @Override
    public final boolean isLevelAllowed(int n) {
        if (this.d_firstAuth) {
            return false;
        }
        int n2 = CrypKeyAPI.getLevel(25);
        if (n > n2) {
            this.d_currError = LEVEL_TOO_LOW;
            return false;
        }
        return true;
    }

    @Override
    public String getError() {
        return this.d_currError;
    }

    @Override
    public final boolean register() {
        RegisterDlg registerDlg = new RegisterDlg(Application.getApp().getMainFrame(), this);
        int n = registerDlg.doModal();
        return n == 1;
    }

    @Override
    public final boolean kill() {
        KillLicenseDlg killLicenseDlg = new KillLicenseDlg(Application.getApp().getMainFrame(), this);
        killLicenseDlg.doModal();
        return killLicenseDlg.isKilled();
    }

    @Override
    public String getLicenseDesc() {
        int n = CrypKeyAPI.getAuthOpt();
        int n2 = CrypKeyAPI.getLevel(25);
        int n3 = CrypKeyAPI.getNumMultiUsers();
        String string = Intl.intl("Current License") + ": ";
        string = n3 > 0 ? string + Intl.intl("Floating,") + " " : string + Intl.intl("Node-Locked,") + " ";
        string = n == 0 ? string + Intl.intl("Perpetual") : (n == 1 ? string + Intl.intl("Time-Limited\nDays used") + ": " + CrypKeyAPI.getNumUsed() + "\n" + Intl.intl("Days licensed") + ": " + CrypKeyAPI.getNumAllowed() : (n == 2 ? string + Intl.intl("Runs-limited\nRuns used") + ": " + CrypKeyAPI.getNumUsed() + "\n" + Intl.intl("Runs licensed") + ": " + CrypKeyAPI.getNumAllowed() : string + Intl.intl("None")));
        if (n3 > 0) {
            string = string + "\n" + Intl.intl("Max Users") + ": " + n3;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(2005, 10, 5);
        calendar.add(2, n2);
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3);
        simpleDateFormat.applyPattern("MMMM yyyy");
        string = string + "\n" + Intl.intl("Support Ends") + ": " + simpleDateFormat.format(calendar.getTime());
        return string;
    }

    public static class ReadyToTryConfig {
        private int d_type;
        private int d_count;
        private int d_auth;
        private int d_trialVer;
        public static final int DAYS = 0;
        public static final int RUNS = 1;

        public ReadyToTryConfig(int n, int n2, int n3, int n4) {
            this.d_type = n;
            this.d_count = n2;
            this.d_auth = n4;
            this.d_trialVer = n3;
        }

        public boolean isDaysLimited() {
            return this.d_type == 0;
        }

        public boolean isRunsLimited() {
            return this.d_type == 1;
        }

        public int getCount() {
            return this.d_count;
        }

        public int getTrialVer() {
            return this.d_trialVer;
        }

        public int getAuthBits() {
            return this.d_auth;
        }
    }
}

