/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.license;

import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import thunderheadeng.Intl;
import thunderheadeng.gui.AbstractCommand;
import thunderheadeng.gui.CmdButton;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.license.LicenseManager;
import thunderheadeng.license.RegisterDlg;

public class AuthFailedDlg
extends guiDialog {
    public static final int QUIT = 10;
    private LicenseManager d_ck;
    private CmdButton d_registerBtn;
    private CmdButton d_quitBtn;
    private int d_status;

    public AuthFailedDlg(JFrame jFrame, LicenseManager licenseManager) {
        super((Window)jFrame, "Access Denied");
        this.d_ck = licenseManager;
        this.d_status = 10;
        this.setHelpIDString("site_key");
        this.d_registerBtn = new CmdButton(new RegisterCmd());
        this.d_quitBtn = new CmdButton(new QuitCmd());
        JComponent[] jComponentArray = new JComponent[]{this.d_registerBtn, new CmdButton(new DetailsCmd()), this.d_quitBtn};
        this.setButtons(jComponentArray);
        MultiLineLabel multiLineLabel = new MultiLineLabel("To continue using PetraSim you must register your Site Code with Thunderhead.  Click 'Register' to register now.");
        multiLineLabel.setPreferredSize(new Dimension(200, 50));
        this.getDialogPane().add(multiLineLabel);
    }

    @Override
    public int doModal() {
        super.doModal();
        return this.d_status;
    }

    class QuitCmd
    extends AbstractCommand {
        public QuitCmd() {
            super("Quit", "");
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void execute() {
            AuthFailedDlg.this.d_status = 10;
            AuthFailedDlg.this.setVisible(false);
        }
    }

    class DetailsCmd
    extends AbstractCommand {
        public DetailsCmd() {
            super("Details", "");
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void execute() {
            int n = AuthFailedDlg.this.d_ck.getAuthorization(0);
            int n2 = 0;
            if (n != 0) {
                n2 = AuthFailedDlg.this.d_ck.readyToTryDays(-125829120, (short)5, (short)2, (short)1);
            }
            int n3 = AuthFailedDlg.this.d_ck.getVersion();
            int n4 = AuthFailedDlg.this.d_ck.getLevel();
            String string = "Unknown Software Licensing Error.";
            if (n2 == 0 && n3 <= 1 && n3 >= 0 && (n4 == 0 || n4 == 3)) {
                string = AuthFailedDlg.this.d_ck.getLicenseDesc();
            } else if (n != 0) {
                String string2 = AuthFailedDlg.this.d_ck.explainErr(1, n);
                String string3 = AuthFailedDlg.this.d_ck.explainErr(9, n2);
                string = "Software Licensing Error (" + n + ").\n" + string2 + "\n\nCouldn't establish trial license (" + n2 + ")\n" + string3;
            } else if (n4 == 1 || n4 == 2) {
                string = "Software Licensing Error.\n\nThis license is for an Educational or Research version of PetraSim.\nPlease install the correct version and run again.";
            } else if (n3 > 1) {
                string = "Software Licensing Error.\n\nThis license is for a newer version of PetraSim.\nPlease install the latest version and run again.";
            } else if (n3 < 0) {
                string = "Software Licensing Error.\n\nThis license is for an older version of PetraSim. Please contact\nThunderhead Engineering for a new Site Key and run again.";
            }
            JOptionPane.showMessageDialog(null, string, "License Details", 1);
        }
    }

    class RegisterCmd
    extends AbstractCommand {
        public RegisterCmd() {
            super(Intl.intl("Register"), "");
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void execute() {
            RegisterDlg registerDlg = new RegisterDlg(AuthFailedDlg.this.d_ck);
            int n = registerDlg.doModal();
            if (n == 1) {
                AuthFailedDlg.this.d_status = 1;
                AuthFailedDlg.this.setVisible(false);
            }
        }
    }
}

