/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.legacy.v9.image;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import thunderheadeng.io.FileSystem;
import thunderheadeng.io.IOUtil;
import thunderheadeng.io.streamsrc.ByteBufferStreamSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;

public class Image
implements Serializable {
    static final long serialVersionUID = 1L;
    private Integer d_version = Version.curr().ordinal();
    private int d_width;
    private int d_height;
    private String d_filename;
    private IStreamSrc d_source;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        objectInputStream.defaultReadObject();
        int n2 = n = this.d_version == null ? Version.VERSION_0001.ordinal() : this.d_version.intValue();
        if (n < Version.VERSION_0003.ordinal()) {
            IStreamSrc iStreamSrc;
            boolean bl = objectInputStream.readBoolean();
            if (!bl) {
                iStreamSrc = FileSystem.INSTANCE.getStreamSrc(this.d_filename, 3);
            } else {
                int n3 = objectInputStream.readInt();
                if (n < Version.VERSION_0002.ordinal()) {
                    byte[] byArray = new byte[n3];
                    objectInputStream.readFully(byArray);
                    int n4 = 2;
                    int n5 = 1;
                    int n6 = 0;
                    int n7 = this.d_width * 3;
                    int n8 = n7 % 4 == 0 ? n7 : (n7 >> 2) + 1 << 2;
                    iStreamSrc = Image.createSrcFromLegacy(this.d_filename, byArray, this.d_width, this.d_height, n8, n4, n5, n6);
                } else {
                    ByteBuffer byteBuffer = IOUtil.readByteBuffer(objectInputStream, n3, true, ByteOrder.nativeOrder());
                    iStreamSrc = new ByteBufferStreamSrc(byteBuffer);
                }
            }
            this.d_source = iStreamSrc;
        }
        this.d_version = Version.curr().ordinal();
    }

    private static IStreamSrc createSrcFromLegacy(String string, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        assert (byArray.length >= n3 * n2);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        int n7 = 0;
        for (int i = 0; i < n2; ++i) {
            int n8 = n2 - i - 1;
            for (int j = 0; j < n; ++j) {
                int n9 = n7 + j * 3;
                int n10 = byArray[n9 + n4] & 0xFF;
                int n11 = byArray[n9 + n5] & 0xFF;
                int n12 = byArray[n9 + n6] & 0xFF;
                int n13 = 0xFF000000 | n10 << 16 | n11 << 8 | n12 << 0;
                bufferedImage.setRGB(j, n8, n13);
            }
            n7 += n3;
        }
        byte[] byArray2 = thunderheadeng.image.Image.compress(bufferedImage);
        ByteBuffer byteBuffer = Image.allocate(byArray2.length);
        byteBuffer.put(byArray2);
        return new ByteBufferStreamSrc(byteBuffer);
    }

    public static ByteBuffer allocate(long l) {
        if (l == 0L || l > Integer.MAX_VALUE) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect((int)l);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    public Object readResolve() throws ObjectStreamException {
        return thunderheadeng.image.Image.loadUnchecked(this.d_filename, this.d_source);
    }

    private static enum Version {
        VERSION_0000,
        VERSION_0001,
        VERSION_0002,
        VERSION_0003;


        public static Version curr() {
            return Version.values()[Version.values().length - 1];
        }
    }
}

