/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.legacy.v8.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import thunderheadeng.io.IFileSystem;
import thunderheadeng.io.IOUtil;
import thunderheadeng.io.streamsrc.ByteArrayStreamSrc;
import thunderheadeng.io.streamsrc.ByteBufferStreamSrc;
import thunderheadeng.io.streamsrc.DecryptStreamSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;
import thunderheadeng.util.theUtil;

public class StreamSources {

    public static class DecryptSrc
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private IStreamSrc baseSrc;

        public Object readResolve() throws ObjectStreamException {
            if (this.baseSrc instanceof DecryptSrc) {
                return this.baseSrc;
            }
            return new DecryptStreamSrc(this.baseSrc);
        }
    }

    public static class ByteBufferSrc
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private transient ByteBuffer buffer;

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.readInt();
            boolean bl = objectInputStream.readBoolean();
            boolean bl2 = objectInputStream.readBoolean();
            ByteOrder byteOrder = bl2 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
            int n = objectInputStream.readInt();
            ByteBuffer byteBuffer = IOUtil.readByteBuffer(objectInputStream, n, bl, byteOrder);
            try {
                theUtil.assignFinalField(this, ByteBufferSrc.class, "buffer", byteBuffer);
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }

        public Object readResolve() throws ObjectStreamException {
            return new ByteBufferStreamSrc(this.buffer);
        }
    }

    public static class ByteArraySrc
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private byte[] data;
        private int offset;
        private int length;

        public Object readResolve() throws ObjectStreamException {
            return new ByteArrayStreamSrc(this.data, this.offset, this.length);
        }
    }

    public static class FileSrc {
        private static final long serialVersionUID = 0L;
        private String filename;
        private IFileSystem fileSystem;
        private boolean buffered;

        public Object readResolve() throws ObjectStreamException {
            int n = 3;
            return this.fileSystem.getStreamSrc(this.filename, n);
        }
    }
}

