/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.legacy.v14.geometry.objs;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.objs.ClosedLinearCurve;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.ILinearCurve;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.util.Pair;

public class WallGeom
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double NONLINEAR_CURVE_TOL = 0.001;
    private ICurve refCurve;
    private WallGeom.Alignment alignment;
    private double thickness;
    private double height;

    public Object readResolve() throws ObjectStreamException {
        Pair<Point3d[], Boolean> pair = this.getReferenceVerts();
        boolean bl = WallGeom.isWrapped((Point3d[])pair.v1);
        if (bl) {
            return new thunderheadeng.geometry.objs.WallGeom(new ClosedLinearCurve(new PolyLine((Point3d[])pair.v1)), this.alignment, this.thickness, this.height);
        }
        ICurve iCurve = (Boolean)pair.v2 == false ? this.refCurve : (((Point3d[])pair.v1).length == 2 ? new LineSeg(((Point3d[])pair.v1)[0], ((Point3d[])pair.v1)[1]) : new PolyLine((Point3d[])pair.v1));
        return new thunderheadeng.geometry.objs.WallGeom(iCurve, this.alignment, this.thickness, this.height);
    }

    private static boolean isWrapped(Point3d[] point3dArray) {
        return point3dArray.length >= 3 && point3dArray[0].epsilonEquals(point3dArray[point3dArray.length - 1], 1.0E-9);
    }

    private Pair<Point3d[], Boolean> getReferenceVerts() {
        ArrayList<Point3d> arrayList;
        IManipulatable iManipulatable;
        boolean bl = false;
        if (this.refCurve instanceof ILinearCurve) {
            iManipulatable = (ILinearCurve)this.refCurve;
            arrayList = new ArrayList<Point3d>(iManipulatable.getNumVerts());
            Point3d point3d = null;
            for (int i = 0; i < iManipulatable.getNumVerts(); ++i) {
                Point3d point3d2 = iManipulatable.getVert(i);
                if (point3d == null) {
                    arrayList.add(point3d2);
                } else if (!WallGeom.equal2d(point3d, point3d2)) {
                    arrayList.add(point3d2);
                } else {
                    bl = true;
                }
                point3d = point3d2;
            }
        } else {
            iManipulatable = this.refCurve.getSegments(0.001);
            if (((Mesh)iManipulatable).indices.length == 0) {
                return new Pair<Point3d[], Boolean>(new Point3d[0], false);
            }
            arrayList = new ArrayList(((Mesh)iManipulatable).indices.length / 2 - 1);
            Point3d point3d = null;
            for (int i = 0; i < ((Mesh)iManipulatable).indices.length; i += 2) {
                Point3d point3d3 = ((Mesh)iManipulatable).vertices[((Mesh)iManipulatable).indices[i]];
                if (point3d == null || !WallGeom.equal2d(point3d, point3d3)) {
                    arrayList.add(point3d3);
                }
                point3d = point3d3;
            }
            Point3d point3d4 = ((Mesh)iManipulatable).vertices[((Mesh)iManipulatable).indices[((Mesh)iManipulatable).indices.length - 1]];
            if (point3d == null || !WallGeom.equal2d(point3d, point3d4)) {
                arrayList.add(point3d4);
            }
        }
        iManipulatable = arrayList.toArray(new Point3d[arrayList.size()]);
        return new Pair<IManipulatable, Boolean>(iManipulatable, bl);
    }

    private static boolean equal2d(Point3d point3d, Point3d point3d2) {
        return point3d.x == point3d2.x && point3d.y == point3d2.y;
    }
}

