/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.legacy.v12.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.function.Predicate;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class Filters {
    private static <T> boolean setsEqual(T[] TArray, T[] TArray2) {
        if (TArray.length != TArray2.length) {
            return false;
        }
        for (T t : TArray) {
            if (Filters.contains(TArray2, t)) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean contains(T[] TArray, T t) {
        for (T t2 : TArray) {
            if (!theUtil.equal(t2, t)) continue;
            return true;
        }
        return false;
    }

    public static class CachedFilter<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        private Predicate<T> d_baseFilter;

        public boolean equals(Object object) {
            return object instanceof CachedFilter && ((CachedFilter)object).d_baseFilter.equals(this.d_baseFilter);
        }

        public int hashCode() {
            return 0x15623 ^ this.d_baseFilter.hashCode();
        }

        private Object readResolve() throws ObjectStreamException {
            return Predicates.cache(this.d_baseFilter);
        }
    }

    public static class MultiCompoundFilter<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public Predicate<T>[] filters;
        public Logic logic;

        public int hashCode() {
            int n = this.logic.hashCode();
            for (Predicate<T> predicate : this.filters) {
                n += predicate.hashCode();
            }
            return n ^= 0x92548AA3;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof MultiCompoundFilter && ((MultiCompoundFilter)object).logic == this.logic && Filters.setsEqual(((MultiCompoundFilter)object).filters, this.filters);
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.logic) {
                case ACCEPT_ALL: {
                    return Predicates.and(this.filters);
                }
            }
            return Predicates.or(this.filters);
        }
    }

    public static class CompoundFilter<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public Predicate<? super T> f1;
        public Predicate<? super T> f2;
        public Logic logic;

        public int hashCode() {
            return 0x1692362 ^ this.logic.hashCode() + this.f1.hashCode() + this.f2.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof CompoundFilter && ((CompoundFilter)object).logic == this.logic && (((CompoundFilter)object).f1.equals(this.f1) && ((CompoundFilter)object).f2.equals(this.f2) || ((CompoundFilter)object).f1.equals(this.f2) && ((CompoundFilter)object).f2.equals(this.f1));
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.logic) {
                case ACCEPT_ALL: {
                    return Predicates.and(this.f1, this.f2);
                }
            }
            return Predicates.or(this.f1, this.f2);
        }
    }

    public static class InvertFilter<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public Predicate<T> filter;

        public int hashCode() {
            return 0x61234F3 ^ this.filter.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof InvertFilter && ((InvertFilter)object).filter.equals(this.filter);
        }

        private Object readResolve() throws ObjectStreamException {
            return new Predicates.Negate<T>(this.filter);
        }
    }

    public static enum Logic {
        ACCEPT_ANY,
        ACCEPT_ALL;

    }
}

