/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io.streamsrc;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import thunderheadeng.io.DecryptInputStream;
import thunderheadeng.io.TeciEncrypt;
import thunderheadeng.io.streamsrc.IFilterStreamSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;

public class DecryptStreamSrc
implements IFilterStreamSrc,
Serializable {
    private static final long serialVersionUID = 0L;
    public final IStreamSrc baseSrc;
    private transient long d_headerRetrievalTime = -1L;
    private transient DecryptInputStream.Header d_encryptHeader;

    public DecryptStreamSrc(IStreamSrc iStreamSrc) {
        this.baseSrc = iStreamSrc;
        this.d_encryptHeader = null;
    }

    @Override
    public IStreamSrc getBaseSource() {
        return this.baseSrc;
    }

    @Override
    public long getSize(int n) throws IOException {
        if ((n & 1) == 0) {
            DecryptInputStream.Header header = this.getEncryptionHeader(0);
            if (header.type.encrypted) {
                return header.dataLen;
            }
        }
        return this.baseSrc.getSize(n);
    }

    @Override
    public InputStream open(int n) throws IOException {
        if ((n & 1) == 1) {
            return this.baseSrc.open(n);
        }
        DecryptInputStream.Header header = this.getEncryptionHeader(n);
        InputStream inputStream = this.baseSrc.open(n);
        if (header.type.encrypted) {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            inputStream = new DecryptInputStream(inputStream);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecryptInputStream.Header getEncryptionHeader(int n) {
        long l = this.baseSrc.getModTime();
        if (this.d_encryptHeader == null || l != this.d_headerRetrievalTime) {
            DecryptInputStream.Header header = new DecryptInputStream.Header(TeciEncrypt.Type.UNENCRYPTED, 0L);
            InputStream inputStream = null;
            try {
                inputStream = this.baseSrc.open(n);
                if (!inputStream.markSupported()) {
                    inputStream = new BufferedInputStream(inputStream);
                }
                header = DecryptInputStream.getEncryptionHeader(inputStream);
            }
            catch (IOException iOException) {
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.d_encryptHeader = header;
            this.d_headerRetrievalTime = l;
        }
        return this.d_encryptHeader;
    }

    @Override
    public long getModTime() {
        return this.baseSrc.getModTime();
    }

    @Override
    public boolean isLocal() {
        return this.baseSrc.isLocal();
    }

    @Override
    public IStreamSrc refilter(IStreamSrc iStreamSrc) {
        return new DecryptStreamSrc(this.baseSrc.refilter(iStreamSrc));
    }
}

