/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io.streamsrc;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import thunderheadeng.io.ByteBufferInputStream;
import thunderheadeng.io.IOUtil;
import thunderheadeng.io.streamsrc.ILocalStreamSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;
import thunderheadeng.util.theUtil;

public class ByteBufferStreamSrc
implements ILocalStreamSrc,
Serializable {
    private static final long serialVersionUID = 0L;
    public final transient ByteBuffer buffer;

    public ByteBufferStreamSrc(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(Version.curr().ordinal());
        objectOutputStream.writeBoolean(this.buffer.isDirect());
        objectOutputStream.writeBoolean(this.buffer.order() == ByteOrder.LITTLE_ENDIAN);
        objectOutputStream.writeInt(this.buffer.limit());
        IOUtil.write(objectOutputStream, this.buffer);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.readInt();
        boolean bl = objectInputStream.readBoolean();
        boolean bl2 = objectInputStream.readBoolean();
        ByteOrder byteOrder = bl2 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        int n = objectInputStream.readInt();
        ByteBuffer byteBuffer = IOUtil.readByteBuffer(objectInputStream, n, bl, byteOrder);
        try {
            theUtil.assignFinalField(this, ByteBufferStreamSrc.class, "buffer", byteBuffer);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public ByteBuffer getLocalData() {
        return this.buffer.duplicate();
    }

    @Override
    public InputStream open(int n) throws IOException {
        return new ByteBufferInputStream(this.buffer);
    }

    @Override
    public long getSize(int n) throws IOException {
        return this.buffer.capacity();
    }

    @Override
    public long getModTime() {
        return 0L;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public void transferData(OutputStream outputStream) throws IOException {
        IOUtil.write(outputStream, this.buffer);
    }

    @Override
    public IStreamSrc refilter(IStreamSrc iStreamSrc) {
        return iStreamSrc;
    }

    private static enum Version {
        VERSION_0000;


        public static Version curr() {
            return Version.values()[Version.values().length - 1];
        }
    }
}

